package zio.aws.networkmanager.model
import zio.ZIO
import zio.aws.networkmanager.model.primitives.{
  IPAddress,
  TransitGatewayAttachmentArn
}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class RouteAnalysisEndpointOptionsSpecification(
    transitGatewayAttachmentArn: Optional[TransitGatewayAttachmentArn] =
      Optional.Absent,
    ipAddress: Optional[IPAddress] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.networkmanager.model.RouteAnalysisEndpointOptionsSpecification = {
    import RouteAnalysisEndpointOptionsSpecification.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.networkmanager.model.RouteAnalysisEndpointOptionsSpecification
      .builder()
      .optionallyWith(
        transitGatewayAttachmentArn.map(value =>
          TransitGatewayAttachmentArn.unwrap(value): java.lang.String
        )
      )(_.transitGatewayAttachmentArn)
      .optionallyWith(
        ipAddress.map(value => IPAddress.unwrap(value): java.lang.String)
      )(_.ipAddress)
      .build()
  }
  def asReadOnly
      : zio.aws.networkmanager.model.RouteAnalysisEndpointOptionsSpecification.ReadOnly =
    zio.aws.networkmanager.model.RouteAnalysisEndpointOptionsSpecification
      .wrap(buildAwsValue())
}
object RouteAnalysisEndpointOptionsSpecification {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.networkmanager.model.RouteAnalysisEndpointOptionsSpecification
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.networkmanager.model.RouteAnalysisEndpointOptionsSpecification =
      zio.aws.networkmanager.model.RouteAnalysisEndpointOptionsSpecification(
        transitGatewayAttachmentArn.map(value => value),
        ipAddress.map(value => value)
      )
    def transitGatewayAttachmentArn: Optional[TransitGatewayAttachmentArn]
    def ipAddress: Optional[IPAddress]
    def getTransitGatewayAttachmentArn
        : ZIO[Any, AwsError, TransitGatewayAttachmentArn] =
      AwsError.unwrapOptionField(
        "transitGatewayAttachmentArn",
        transitGatewayAttachmentArn
      )
    def getIpAddress: ZIO[Any, AwsError, IPAddress] =
      AwsError.unwrapOptionField("ipAddress", ipAddress)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.networkmanager.model.RouteAnalysisEndpointOptionsSpecification
  ) extends zio.aws.networkmanager.model.RouteAnalysisEndpointOptionsSpecification.ReadOnly {
    override val transitGatewayAttachmentArn
        : Optional[TransitGatewayAttachmentArn] = zio.aws.core.internal
      .optionalFromNullable(impl.transitGatewayAttachmentArn())
      .map(value =>
        zio.aws.networkmanager.model.primitives
          .TransitGatewayAttachmentArn(value)
      )
    override val ipAddress: Optional[IPAddress] = zio.aws.core.internal
      .optionalFromNullable(impl.ipAddress())
      .map(value => zio.aws.networkmanager.model.primitives.IPAddress(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.networkmanager.model.RouteAnalysisEndpointOptionsSpecification
  ): zio.aws.networkmanager.model.RouteAnalysisEndpointOptionsSpecification.ReadOnly =
    new Wrapper(impl)
}
