package zio.aws.networkmanager.model
import zio.ZIO
import zio.aws.networkmanager.model.primitives.NextToken
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ListCoreNetworksResponse(
    coreNetworks: Optional[
      Iterable[zio.aws.networkmanager.model.CoreNetworkSummary]
    ] = Optional.Absent,
    nextToken: Optional[NextToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.networkmanager.model.ListCoreNetworksResponse = {
    import ListCoreNetworksResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.networkmanager.model.ListCoreNetworksResponse
      .builder()
      .optionallyWith(
        coreNetworks.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.coreNetworks)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly
      : zio.aws.networkmanager.model.ListCoreNetworksResponse.ReadOnly =
    zio.aws.networkmanager.model.ListCoreNetworksResponse.wrap(buildAwsValue())
}
object ListCoreNetworksResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.networkmanager.model.ListCoreNetworksResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.networkmanager.model.ListCoreNetworksResponse =
      zio.aws.networkmanager.model.ListCoreNetworksResponse(
        coreNetworks.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def coreNetworks: Optional[
      List[zio.aws.networkmanager.model.CoreNetworkSummary.ReadOnly]
    ]
    def nextToken: Optional[NextToken]
    def getCoreNetworks: ZIO[Any, AwsError, List[
      zio.aws.networkmanager.model.CoreNetworkSummary.ReadOnly
    ]] = AwsError.unwrapOptionField("coreNetworks", coreNetworks)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.networkmanager.model.ListCoreNetworksResponse
  ) extends zio.aws.networkmanager.model.ListCoreNetworksResponse.ReadOnly {
    override val coreNetworks: Optional[
      List[zio.aws.networkmanager.model.CoreNetworkSummary.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.coreNetworks())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.networkmanager.model.CoreNetworkSummary.wrap(item)
        }.toList
      )
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.networkmanager.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.networkmanager.model.ListCoreNetworksResponse
  ): zio.aws.networkmanager.model.ListCoreNetworksResponse.ReadOnly =
    new Wrapper(impl)
}
