package zio.aws.networkmanager.model
import scala.jdk.CollectionConverters._
sealed trait RouteState {
  def unwrap: software.amazon.awssdk.services.networkmanager.model.RouteState
}
object RouteState {
  def wrap(
      value: software.amazon.awssdk.services.networkmanager.model.RouteState
  ): zio.aws.networkmanager.model.RouteState = value match {
    case software.amazon.awssdk.services.networkmanager.model.RouteState.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.networkmanager.model.RouteState.ACTIVE =>
      val r = ACTIVE
      r
    case software.amazon.awssdk.services.networkmanager.model.RouteState.BLACKHOLE =>
      val r = BLACKHOLE
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.networkmanager.model.RouteState {
    override def unwrap
        : software.amazon.awssdk.services.networkmanager.model.RouteState =
      software.amazon.awssdk.services.networkmanager.model.RouteState.UNKNOWN_TO_SDK_VERSION
  }
  case object ACTIVE extends zio.aws.networkmanager.model.RouteState {
    override def unwrap
        : software.amazon.awssdk.services.networkmanager.model.RouteState =
      software.amazon.awssdk.services.networkmanager.model.RouteState.ACTIVE
  }
  case object BLACKHOLE extends zio.aws.networkmanager.model.RouteState {
    override def unwrap
        : software.amazon.awssdk.services.networkmanager.model.RouteState =
      software.amazon.awssdk.services.networkmanager.model.RouteState.BLACKHOLE
  }
}
