package zio.aws.networkmanager.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class CreateTransitGatewayRouteTableAttachmentResponse(
    transitGatewayRouteTableAttachment: Optional[
      zio.aws.networkmanager.model.TransitGatewayRouteTableAttachment
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.networkmanager.model.CreateTransitGatewayRouteTableAttachmentResponse = {
    import CreateTransitGatewayRouteTableAttachmentResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.networkmanager.model.CreateTransitGatewayRouteTableAttachmentResponse
      .builder()
      .optionallyWith(
        transitGatewayRouteTableAttachment.map(value => value.buildAwsValue())
      )(_.transitGatewayRouteTableAttachment)
      .build()
  }
  def asReadOnly
      : zio.aws.networkmanager.model.CreateTransitGatewayRouteTableAttachmentResponse.ReadOnly =
    zio.aws.networkmanager.model.CreateTransitGatewayRouteTableAttachmentResponse
      .wrap(buildAwsValue())
}
object CreateTransitGatewayRouteTableAttachmentResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.networkmanager.model.CreateTransitGatewayRouteTableAttachmentResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.networkmanager.model.CreateTransitGatewayRouteTableAttachmentResponse =
      zio.aws.networkmanager.model
        .CreateTransitGatewayRouteTableAttachmentResponse(
          transitGatewayRouteTableAttachment.map(value => value.asEditable)
        )
    def transitGatewayRouteTableAttachment: Optional[
      zio.aws.networkmanager.model.TransitGatewayRouteTableAttachment.ReadOnly
    ]
    def getTransitGatewayRouteTableAttachment: ZIO[
      Any,
      AwsError,
      zio.aws.networkmanager.model.TransitGatewayRouteTableAttachment.ReadOnly
    ] = AwsError.unwrapOptionField(
      "transitGatewayRouteTableAttachment",
      transitGatewayRouteTableAttachment
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.networkmanager.model.CreateTransitGatewayRouteTableAttachmentResponse
  ) extends zio.aws.networkmanager.model.CreateTransitGatewayRouteTableAttachmentResponse.ReadOnly {
    override val transitGatewayRouteTableAttachment: Optional[
      zio.aws.networkmanager.model.TransitGatewayRouteTableAttachment.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.transitGatewayRouteTableAttachment())
      .map(value =>
        zio.aws.networkmanager.model.TransitGatewayRouteTableAttachment
          .wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.networkmanager.model.CreateTransitGatewayRouteTableAttachmentResponse
  ): zio.aws.networkmanager.model.CreateTransitGatewayRouteTableAttachmentResponse.ReadOnly =
    new Wrapper(impl)
}
