package zio.aws.networkmanager.model
import zio.ZIO
import zio.aws.networkmanager.model.primitives.NextToken
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class GetCoreNetworkChangeEventsResponse(
    coreNetworkChangeEvents: Optional[
      Iterable[zio.aws.networkmanager.model.CoreNetworkChangeEvent]
    ] = Optional.Absent,
    nextToken: Optional[NextToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.networkmanager.model.GetCoreNetworkChangeEventsResponse = {
    import GetCoreNetworkChangeEventsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.networkmanager.model.GetCoreNetworkChangeEventsResponse
      .builder()
      .optionallyWith(
        coreNetworkChangeEvents.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.coreNetworkChangeEvents)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly
      : zio.aws.networkmanager.model.GetCoreNetworkChangeEventsResponse.ReadOnly =
    zio.aws.networkmanager.model.GetCoreNetworkChangeEventsResponse
      .wrap(buildAwsValue())
}
object GetCoreNetworkChangeEventsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.networkmanager.model.GetCoreNetworkChangeEventsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.networkmanager.model.GetCoreNetworkChangeEventsResponse =
      zio.aws.networkmanager.model.GetCoreNetworkChangeEventsResponse(
        coreNetworkChangeEvents.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def coreNetworkChangeEvents: Optional[
      List[zio.aws.networkmanager.model.CoreNetworkChangeEvent.ReadOnly]
    ]
    def nextToken: Optional[NextToken]
    def getCoreNetworkChangeEvents: ZIO[Any, AwsError, List[
      zio.aws.networkmanager.model.CoreNetworkChangeEvent.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "coreNetworkChangeEvents",
      coreNetworkChangeEvents
    )
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.networkmanager.model.GetCoreNetworkChangeEventsResponse
  ) extends zio.aws.networkmanager.model.GetCoreNetworkChangeEventsResponse.ReadOnly {
    override val coreNetworkChangeEvents: Optional[
      List[zio.aws.networkmanager.model.CoreNetworkChangeEvent.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.coreNetworkChangeEvents())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.networkmanager.model.CoreNetworkChangeEvent.wrap(item)
        }.toList
      )
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.networkmanager.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.networkmanager.model.GetCoreNetworkChangeEventsResponse
  ): zio.aws.networkmanager.model.GetCoreNetworkChangeEventsResponse.ReadOnly =
    new Wrapper(impl)
}
