package zio.aws.networkmanager.model
import zio.ZIO
import zio.aws.networkmanager.model.primitives.{
  SLRDeploymentStatus,
  OrganizationAwsServiceAccessStatus,
  OrganizationId
}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class OrganizationStatus(
    organizationId: Optional[OrganizationId] = Optional.Absent,
    organizationAwsServiceAccessStatus: Optional[
      OrganizationAwsServiceAccessStatus
    ] = Optional.Absent,
    slrDeploymentStatus: Optional[SLRDeploymentStatus] = Optional.Absent,
    accountStatusList: Optional[
      Iterable[zio.aws.networkmanager.model.AccountStatus]
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.networkmanager.model.OrganizationStatus = {
    import OrganizationStatus.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.networkmanager.model.OrganizationStatus
      .builder()
      .optionallyWith(
        organizationId.map(value =>
          OrganizationId.unwrap(value): java.lang.String
        )
      )(_.organizationId)
      .optionallyWith(
        organizationAwsServiceAccessStatus.map(value =>
          OrganizationAwsServiceAccessStatus.unwrap(value): java.lang.String
        )
      )(_.organizationAwsServiceAccessStatus)
      .optionallyWith(
        slrDeploymentStatus.map(value =>
          SLRDeploymentStatus.unwrap(value): java.lang.String
        )
      )(_.slrDeploymentStatus)
      .optionallyWith(
        accountStatusList.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.accountStatusList)
      .build()
  }
  def asReadOnly: zio.aws.networkmanager.model.OrganizationStatus.ReadOnly =
    zio.aws.networkmanager.model.OrganizationStatus.wrap(buildAwsValue())
}
object OrganizationStatus {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.networkmanager.model.OrganizationStatus
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.networkmanager.model.OrganizationStatus =
      zio.aws.networkmanager.model.OrganizationStatus(
        organizationId.map(value => value),
        organizationAwsServiceAccessStatus.map(value => value),
        slrDeploymentStatus.map(value => value),
        accountStatusList.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def organizationId: Optional[OrganizationId]
    def organizationAwsServiceAccessStatus
        : Optional[OrganizationAwsServiceAccessStatus]
    def slrDeploymentStatus: Optional[SLRDeploymentStatus]
    def accountStatusList
        : Optional[List[zio.aws.networkmanager.model.AccountStatus.ReadOnly]]
    def getOrganizationId: ZIO[Any, AwsError, OrganizationId] =
      AwsError.unwrapOptionField("organizationId", organizationId)
    def getOrganizationAwsServiceAccessStatus
        : ZIO[Any, AwsError, OrganizationAwsServiceAccessStatus] =
      AwsError.unwrapOptionField(
        "organizationAwsServiceAccessStatus",
        organizationAwsServiceAccessStatus
      )
    def getSlrDeploymentStatus: ZIO[Any, AwsError, SLRDeploymentStatus] =
      AwsError.unwrapOptionField("slrDeploymentStatus", slrDeploymentStatus)
    def getAccountStatusList: ZIO[Any, AwsError, List[
      zio.aws.networkmanager.model.AccountStatus.ReadOnly
    ]] = AwsError.unwrapOptionField("accountStatusList", accountStatusList)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.networkmanager.model.OrganizationStatus
  ) extends zio.aws.networkmanager.model.OrganizationStatus.ReadOnly {
    override val organizationId: Optional[OrganizationId] =
      zio.aws.core.internal
        .optionalFromNullable(impl.organizationId())
        .map(value =>
          zio.aws.networkmanager.model.primitives.OrganizationId(value)
        )
    override val organizationAwsServiceAccessStatus
        : Optional[OrganizationAwsServiceAccessStatus] = zio.aws.core.internal
      .optionalFromNullable(impl.organizationAwsServiceAccessStatus())
      .map(value =>
        zio.aws.networkmanager.model.primitives
          .OrganizationAwsServiceAccessStatus(value)
      )
    override val slrDeploymentStatus: Optional[SLRDeploymentStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.slrDeploymentStatus())
        .map(value =>
          zio.aws.networkmanager.model.primitives.SLRDeploymentStatus(value)
        )
    override val accountStatusList
        : Optional[List[zio.aws.networkmanager.model.AccountStatus.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.accountStatusList())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.networkmanager.model.AccountStatus.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.networkmanager.model.OrganizationStatus
  ): zio.aws.networkmanager.model.OrganizationStatus.ReadOnly = new Wrapper(
    impl
  )
}
