package zio.aws.networkmanager.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.networkmanager.model.primitives.{
  ConstrainedString,
  NextToken,
  GlobalNetworkId,
  LinkId,
  SiteId,
  MaxResults
}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class GetLinksRequest(
    globalNetworkId: GlobalNetworkId,
    linkIds: Optional[Iterable[LinkId]] = Optional.Absent,
    siteId: Optional[SiteId] = Optional.Absent,
    `type`: Optional[ConstrainedString] = Optional.Absent,
    provider: Optional[ConstrainedString] = Optional.Absent,
    maxResults: Optional[MaxResults] = Optional.Absent,
    nextToken: Optional[NextToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.networkmanager.model.GetLinksRequest = {
    import GetLinksRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.networkmanager.model.GetLinksRequest
      .builder()
      .globalNetworkId(
        GlobalNetworkId.unwrap(globalNetworkId): java.lang.String
      )
      .optionallyWith(
        linkIds.map(value =>
          value.map { item =>
            LinkId.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.linkIds)
      .optionallyWith(
        siteId.map(value => SiteId.unwrap(value): java.lang.String)
      )(_.siteId)
      .optionallyWith(
        `type`.map(value => ConstrainedString.unwrap(value): java.lang.String)
      )(_.`type`)
      .optionallyWith(
        provider.map(value => ConstrainedString.unwrap(value): java.lang.String)
      )(_.provider)
      .optionallyWith(
        maxResults.map(value => MaxResults.unwrap(value): Integer)
      )(_.maxResults)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly: zio.aws.networkmanager.model.GetLinksRequest.ReadOnly =
    zio.aws.networkmanager.model.GetLinksRequest.wrap(buildAwsValue())
}
object GetLinksRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.networkmanager.model.GetLinksRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.networkmanager.model.GetLinksRequest =
      zio.aws.networkmanager.model.GetLinksRequest(
        globalNetworkId,
        linkIds.map(value => value),
        siteId.map(value => value),
        `type`.map(value => value),
        provider.map(value => value),
        maxResults.map(value => value),
        nextToken.map(value => value)
      )
    def globalNetworkId: GlobalNetworkId
    def linkIds: Optional[List[LinkId]]
    def siteId: Optional[SiteId]
    def `type`: Optional[ConstrainedString]
    def provider: Optional[ConstrainedString]
    def maxResults: Optional[MaxResults]
    def nextToken: Optional[NextToken]
    def getGlobalNetworkId: ZIO[Any, Nothing, GlobalNetworkId] =
      ZIO.succeed(globalNetworkId)
    def getLinkIds: ZIO[Any, AwsError, List[LinkId]] =
      AwsError.unwrapOptionField("linkIds", linkIds)
    def getSiteId: ZIO[Any, AwsError, SiteId] =
      AwsError.unwrapOptionField("siteId", siteId)
    def getType: ZIO[Any, AwsError, ConstrainedString] =
      AwsError.unwrapOptionField("type", `type`)
    def getProvider: ZIO[Any, AwsError, ConstrainedString] =
      AwsError.unwrapOptionField("provider", provider)
    def getMaxResults: ZIO[Any, AwsError, MaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.networkmanager.model.GetLinksRequest
  ) extends zio.aws.networkmanager.model.GetLinksRequest.ReadOnly {
    override val globalNetworkId: GlobalNetworkId =
      zio.aws.networkmanager.model.primitives
        .GlobalNetworkId(impl.globalNetworkId())
    override val linkIds: Optional[List[LinkId]] = zio.aws.core.internal
      .optionalFromNullable(impl.linkIds())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.networkmanager.model.primitives.LinkId(item)
        }.toList
      )
    override val siteId: Optional[SiteId] = zio.aws.core.internal
      .optionalFromNullable(impl.siteId())
      .map(value => zio.aws.networkmanager.model.primitives.SiteId(value))
    override val `type`: Optional[ConstrainedString] = zio.aws.core.internal
      .optionalFromNullable(impl.`type`())
      .map(value =>
        zio.aws.networkmanager.model.primitives.ConstrainedString(value)
      )
    override val provider: Optional[ConstrainedString] = zio.aws.core.internal
      .optionalFromNullable(impl.provider())
      .map(value =>
        zio.aws.networkmanager.model.primitives.ConstrainedString(value)
      )
    override val maxResults: Optional[MaxResults] = zio.aws.core.internal
      .optionalFromNullable(impl.maxResults())
      .map(value => zio.aws.networkmanager.model.primitives.MaxResults(value))
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.networkmanager.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.networkmanager.model.GetLinksRequest
  ): zio.aws.networkmanager.model.GetLinksRequest.ReadOnly = new Wrapper(impl)
}
