package zio.aws.networkmanager.model
import zio.ZIO
import zio.aws.networkmanager.model.primitives.CoreNetworkId
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class GetCoreNetworkRequest(coreNetworkId: CoreNetworkId) {
  def buildAwsValue()
      : software.amazon.awssdk.services.networkmanager.model.GetCoreNetworkRequest = {
    import GetCoreNetworkRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.networkmanager.model.GetCoreNetworkRequest
      .builder()
      .coreNetworkId(CoreNetworkId.unwrap(coreNetworkId): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.networkmanager.model.GetCoreNetworkRequest.ReadOnly =
    zio.aws.networkmanager.model.GetCoreNetworkRequest.wrap(buildAwsValue())
}
object GetCoreNetworkRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.networkmanager.model.GetCoreNetworkRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.networkmanager.model.GetCoreNetworkRequest =
      zio.aws.networkmanager.model.GetCoreNetworkRequest(coreNetworkId)
    def coreNetworkId: CoreNetworkId
    def getCoreNetworkId: ZIO[Any, Nothing, CoreNetworkId] =
      ZIO.succeed(coreNetworkId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.networkmanager.model.GetCoreNetworkRequest
  ) extends zio.aws.networkmanager.model.GetCoreNetworkRequest.ReadOnly {
    override val coreNetworkId: CoreNetworkId =
      zio.aws.networkmanager.model.primitives
        .CoreNetworkId(impl.coreNetworkId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.networkmanager.model.GetCoreNetworkRequest
  ): zio.aws.networkmanager.model.GetCoreNetworkRequest.ReadOnly = new Wrapper(
    impl
  )
}
