package zio.aws.networkmanager.model
import zio.ZIO
import zio.aws.networkmanager.model.primitives.NextToken
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ListOrganizationServiceAccessStatusResponse(
    organizationStatus: Optional[
      zio.aws.networkmanager.model.OrganizationStatus
    ] = Optional.Absent,
    nextToken: Optional[NextToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.networkmanager.model.ListOrganizationServiceAccessStatusResponse = {
    import ListOrganizationServiceAccessStatusResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.networkmanager.model.ListOrganizationServiceAccessStatusResponse
      .builder()
      .optionallyWith(organizationStatus.map(value => value.buildAwsValue()))(
        _.organizationStatus
      )
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly
      : zio.aws.networkmanager.model.ListOrganizationServiceAccessStatusResponse.ReadOnly =
    zio.aws.networkmanager.model.ListOrganizationServiceAccessStatusResponse
      .wrap(buildAwsValue())
}
object ListOrganizationServiceAccessStatusResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.networkmanager.model.ListOrganizationServiceAccessStatusResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.networkmanager.model.ListOrganizationServiceAccessStatusResponse =
      zio.aws.networkmanager.model.ListOrganizationServiceAccessStatusResponse(
        organizationStatus.map(value => value.asEditable),
        nextToken.map(value => value)
      )
    def organizationStatus
        : Optional[zio.aws.networkmanager.model.OrganizationStatus.ReadOnly]
    def nextToken: Optional[NextToken]
    def getOrganizationStatus: ZIO[
      Any,
      AwsError,
      zio.aws.networkmanager.model.OrganizationStatus.ReadOnly
    ] = AwsError.unwrapOptionField("organizationStatus", organizationStatus)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.networkmanager.model.ListOrganizationServiceAccessStatusResponse
  ) extends zio.aws.networkmanager.model.ListOrganizationServiceAccessStatusResponse.ReadOnly {
    override val organizationStatus
        : Optional[zio.aws.networkmanager.model.OrganizationStatus.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.organizationStatus())
        .map(value =>
          zio.aws.networkmanager.model.OrganizationStatus.wrap(value)
        )
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.networkmanager.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.networkmanager.model.ListOrganizationServiceAccessStatusResponse
  ): zio.aws.networkmanager.model.ListOrganizationServiceAccessStatusResponse.ReadOnly =
    new Wrapper(impl)
}
