package zio.aws.networkmanager.model
import zio.ZIO
import zio.aws.networkmanager.model.primitives.{
  ConstrainedString,
  GlobalNetworkId,
  AWSAccountId,
  CoreNetworkArn,
  CoreNetworkId
}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class CoreNetworkSummary(
    coreNetworkId: Optional[CoreNetworkId] = Optional.Absent,
    coreNetworkArn: Optional[CoreNetworkArn] = Optional.Absent,
    globalNetworkId: Optional[GlobalNetworkId] = Optional.Absent,
    ownerAccountId: Optional[AWSAccountId] = Optional.Absent,
    state: Optional[zio.aws.networkmanager.model.CoreNetworkState] =
      Optional.Absent,
    description: Optional[ConstrainedString] = Optional.Absent,
    tags: Optional[Iterable[zio.aws.networkmanager.model.Tag]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.networkmanager.model.CoreNetworkSummary = {
    import CoreNetworkSummary.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.networkmanager.model.CoreNetworkSummary
      .builder()
      .optionallyWith(
        coreNetworkId.map(value =>
          CoreNetworkId.unwrap(value): java.lang.String
        )
      )(_.coreNetworkId)
      .optionallyWith(
        coreNetworkArn.map(value =>
          CoreNetworkArn.unwrap(value): java.lang.String
        )
      )(_.coreNetworkArn)
      .optionallyWith(
        globalNetworkId.map(value =>
          GlobalNetworkId.unwrap(value): java.lang.String
        )
      )(_.globalNetworkId)
      .optionallyWith(
        ownerAccountId.map(value =>
          AWSAccountId.unwrap(value): java.lang.String
        )
      )(_.ownerAccountId)
      .optionallyWith(state.map(value => value.unwrap))(_.state)
      .optionallyWith(
        description.map(value =>
          ConstrainedString.unwrap(value): java.lang.String
        )
      )(_.description)
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .build()
  }
  def asReadOnly: zio.aws.networkmanager.model.CoreNetworkSummary.ReadOnly =
    zio.aws.networkmanager.model.CoreNetworkSummary.wrap(buildAwsValue())
}
object CoreNetworkSummary {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.networkmanager.model.CoreNetworkSummary
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.networkmanager.model.CoreNetworkSummary =
      zio.aws.networkmanager.model.CoreNetworkSummary(
        coreNetworkId.map(value => value),
        coreNetworkArn.map(value => value),
        globalNetworkId.map(value => value),
        ownerAccountId.map(value => value),
        state.map(value => value),
        description.map(value => value),
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def coreNetworkId: Optional[CoreNetworkId]
    def coreNetworkArn: Optional[CoreNetworkArn]
    def globalNetworkId: Optional[GlobalNetworkId]
    def ownerAccountId: Optional[AWSAccountId]
    def state: Optional[zio.aws.networkmanager.model.CoreNetworkState]
    def description: Optional[ConstrainedString]
    def tags: Optional[List[zio.aws.networkmanager.model.Tag.ReadOnly]]
    def getCoreNetworkId: ZIO[Any, AwsError, CoreNetworkId] =
      AwsError.unwrapOptionField("coreNetworkId", coreNetworkId)
    def getCoreNetworkArn: ZIO[Any, AwsError, CoreNetworkArn] =
      AwsError.unwrapOptionField("coreNetworkArn", coreNetworkArn)
    def getGlobalNetworkId: ZIO[Any, AwsError, GlobalNetworkId] =
      AwsError.unwrapOptionField("globalNetworkId", globalNetworkId)
    def getOwnerAccountId: ZIO[Any, AwsError, AWSAccountId] =
      AwsError.unwrapOptionField("ownerAccountId", ownerAccountId)
    def getState
        : ZIO[Any, AwsError, zio.aws.networkmanager.model.CoreNetworkState] =
      AwsError.unwrapOptionField("state", state)
    def getDescription: ZIO[Any, AwsError, ConstrainedString] =
      AwsError.unwrapOptionField("description", description)
    def getTags
        : ZIO[Any, AwsError, List[zio.aws.networkmanager.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.networkmanager.model.CoreNetworkSummary
  ) extends zio.aws.networkmanager.model.CoreNetworkSummary.ReadOnly {
    override val coreNetworkId: Optional[CoreNetworkId] = zio.aws.core.internal
      .optionalFromNullable(impl.coreNetworkId())
      .map(value =>
        zio.aws.networkmanager.model.primitives.CoreNetworkId(value)
      )
    override val coreNetworkArn: Optional[CoreNetworkArn] =
      zio.aws.core.internal
        .optionalFromNullable(impl.coreNetworkArn())
        .map(value =>
          zio.aws.networkmanager.model.primitives.CoreNetworkArn(value)
        )
    override val globalNetworkId: Optional[GlobalNetworkId] =
      zio.aws.core.internal
        .optionalFromNullable(impl.globalNetworkId())
        .map(value =>
          zio.aws.networkmanager.model.primitives.GlobalNetworkId(value)
        )
    override val ownerAccountId: Optional[AWSAccountId] = zio.aws.core.internal
      .optionalFromNullable(impl.ownerAccountId())
      .map(value => zio.aws.networkmanager.model.primitives.AWSAccountId(value))
    override val state
        : Optional[zio.aws.networkmanager.model.CoreNetworkState] =
      zio.aws.core.internal
        .optionalFromNullable(impl.state())
        .map(value => zio.aws.networkmanager.model.CoreNetworkState.wrap(value))
    override val description: Optional[ConstrainedString] =
      zio.aws.core.internal
        .optionalFromNullable(impl.description())
        .map(value =>
          zio.aws.networkmanager.model.primitives.ConstrainedString(value)
        )
    override val tags
        : Optional[List[zio.aws.networkmanager.model.Tag.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.tags())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.networkmanager.model.Tag.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.networkmanager.model.CoreNetworkSummary
  ): zio.aws.networkmanager.model.CoreNetworkSummary.ReadOnly = new Wrapper(
    impl
  )
}
