package zio.aws.networkmanager.model
import scala.jdk.CollectionConverters._
sealed trait ConnectionStatus {
  def unwrap
      : software.amazon.awssdk.services.networkmanager.model.ConnectionStatus
}
object ConnectionStatus {
  def wrap(
      value: software.amazon.awssdk.services.networkmanager.model.ConnectionStatus
  ): zio.aws.networkmanager.model.ConnectionStatus = value match {
    case software.amazon.awssdk.services.networkmanager.model.ConnectionStatus.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.networkmanager.model.ConnectionStatus.UP =>
      val r = UP
      r
    case software.amazon.awssdk.services.networkmanager.model.ConnectionStatus.DOWN =>
      val r = DOWN
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.networkmanager.model.ConnectionStatus {
    override def unwrap
        : software.amazon.awssdk.services.networkmanager.model.ConnectionStatus =
      software.amazon.awssdk.services.networkmanager.model.ConnectionStatus.UNKNOWN_TO_SDK_VERSION
  }
  case object UP extends zio.aws.networkmanager.model.ConnectionStatus {
    override def unwrap
        : software.amazon.awssdk.services.networkmanager.model.ConnectionStatus =
      software.amazon.awssdk.services.networkmanager.model.ConnectionStatus.UP
  }
  case object DOWN extends zio.aws.networkmanager.model.ConnectionStatus {
    override def unwrap
        : software.amazon.awssdk.services.networkmanager.model.ConnectionStatus =
      software.amazon.awssdk.services.networkmanager.model.ConnectionStatus.DOWN
  }
}
