package zio.aws.networkmanager.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.networkmanager.model.primitives.{
  ConstrainedString,
  DateTime,
  AWSAccountId,
  Integer,
  CoreNetworkArn,
  AttachmentId,
  ExternalRegionCode,
  ResourceArn,
  CoreNetworkId
}
import zio.ZIO
import scala.jdk.CollectionConverters._
final case class Attachment(
    coreNetworkId: Optional[CoreNetworkId] = Optional.Absent,
    coreNetworkArn: Optional[CoreNetworkArn] = Optional.Absent,
    attachmentId: Optional[AttachmentId] = Optional.Absent,
    ownerAccountId: Optional[AWSAccountId] = Optional.Absent,
    attachmentType: Optional[zio.aws.networkmanager.model.AttachmentType] =
      Optional.Absent,
    state: Optional[zio.aws.networkmanager.model.AttachmentState] =
      Optional.Absent,
    edgeLocation: Optional[ExternalRegionCode] = Optional.Absent,
    resourceArn: Optional[ResourceArn] = Optional.Absent,
    attachmentPolicyRuleNumber: Optional[Integer] = Optional.Absent,
    segmentName: Optional[ConstrainedString] = Optional.Absent,
    tags: Optional[Iterable[zio.aws.networkmanager.model.Tag]] =
      Optional.Absent,
    proposedSegmentChange: Optional[
      zio.aws.networkmanager.model.ProposedSegmentChange
    ] = Optional.Absent,
    createdAt: Optional[DateTime] = Optional.Absent,
    updatedAt: Optional[DateTime] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.networkmanager.model.Attachment = {
    import Attachment.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.networkmanager.model.Attachment
      .builder()
      .optionallyWith(
        coreNetworkId.map(value =>
          CoreNetworkId.unwrap(value): java.lang.String
        )
      )(_.coreNetworkId)
      .optionallyWith(
        coreNetworkArn.map(value =>
          CoreNetworkArn.unwrap(value): java.lang.String
        )
      )(_.coreNetworkArn)
      .optionallyWith(
        attachmentId.map(value => AttachmentId.unwrap(value): java.lang.String)
      )(_.attachmentId)
      .optionallyWith(
        ownerAccountId.map(value =>
          AWSAccountId.unwrap(value): java.lang.String
        )
      )(_.ownerAccountId)
      .optionallyWith(attachmentType.map(value => value.unwrap))(
        _.attachmentType
      )
      .optionallyWith(state.map(value => value.unwrap))(_.state)
      .optionallyWith(
        edgeLocation.map(value =>
          ExternalRegionCode.unwrap(value): java.lang.String
        )
      )(_.edgeLocation)
      .optionallyWith(
        resourceArn.map(value => ResourceArn.unwrap(value): java.lang.String)
      )(_.resourceArn)
      .optionallyWith(
        attachmentPolicyRuleNumber.map(value => value: java.lang.Integer)
      )(_.attachmentPolicyRuleNumber)
      .optionallyWith(
        segmentName.map(value =>
          ConstrainedString.unwrap(value): java.lang.String
        )
      )(_.segmentName)
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .optionallyWith(
        proposedSegmentChange.map(value => value.buildAwsValue())
      )(_.proposedSegmentChange)
      .optionallyWith(createdAt.map(value => DateTime.unwrap(value): Instant))(
        _.createdAt
      )
      .optionallyWith(updatedAt.map(value => DateTime.unwrap(value): Instant))(
        _.updatedAt
      )
      .build()
  }
  def asReadOnly: zio.aws.networkmanager.model.Attachment.ReadOnly =
    zio.aws.networkmanager.model.Attachment.wrap(buildAwsValue())
}
object Attachment {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.networkmanager.model.Attachment
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.networkmanager.model.Attachment =
      zio.aws.networkmanager.model.Attachment(
        coreNetworkId.map(value => value),
        coreNetworkArn.map(value => value),
        attachmentId.map(value => value),
        ownerAccountId.map(value => value),
        attachmentType.map(value => value),
        state.map(value => value),
        edgeLocation.map(value => value),
        resourceArn.map(value => value),
        attachmentPolicyRuleNumber.map(value => value),
        segmentName.map(value => value),
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        proposedSegmentChange.map(value => value.asEditable),
        createdAt.map(value => value),
        updatedAt.map(value => value)
      )
    def coreNetworkId: Optional[CoreNetworkId]
    def coreNetworkArn: Optional[CoreNetworkArn]
    def attachmentId: Optional[AttachmentId]
    def ownerAccountId: Optional[AWSAccountId]
    def attachmentType: Optional[zio.aws.networkmanager.model.AttachmentType]
    def state: Optional[zio.aws.networkmanager.model.AttachmentState]
    def edgeLocation: Optional[ExternalRegionCode]
    def resourceArn: Optional[ResourceArn]
    def attachmentPolicyRuleNumber: Optional[Integer]
    def segmentName: Optional[ConstrainedString]
    def tags: Optional[List[zio.aws.networkmanager.model.Tag.ReadOnly]]
    def proposedSegmentChange
        : Optional[zio.aws.networkmanager.model.ProposedSegmentChange.ReadOnly]
    def createdAt: Optional[DateTime]
    def updatedAt: Optional[DateTime]
    def getCoreNetworkId: ZIO[Any, AwsError, CoreNetworkId] =
      AwsError.unwrapOptionField("coreNetworkId", coreNetworkId)
    def getCoreNetworkArn: ZIO[Any, AwsError, CoreNetworkArn] =
      AwsError.unwrapOptionField("coreNetworkArn", coreNetworkArn)
    def getAttachmentId: ZIO[Any, AwsError, AttachmentId] =
      AwsError.unwrapOptionField("attachmentId", attachmentId)
    def getOwnerAccountId: ZIO[Any, AwsError, AWSAccountId] =
      AwsError.unwrapOptionField("ownerAccountId", ownerAccountId)
    def getAttachmentType
        : ZIO[Any, AwsError, zio.aws.networkmanager.model.AttachmentType] =
      AwsError.unwrapOptionField("attachmentType", attachmentType)
    def getState
        : ZIO[Any, AwsError, zio.aws.networkmanager.model.AttachmentState] =
      AwsError.unwrapOptionField("state", state)
    def getEdgeLocation: ZIO[Any, AwsError, ExternalRegionCode] =
      AwsError.unwrapOptionField("edgeLocation", edgeLocation)
    def getResourceArn: ZIO[Any, AwsError, ResourceArn] =
      AwsError.unwrapOptionField("resourceArn", resourceArn)
    def getAttachmentPolicyRuleNumber: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField(
        "attachmentPolicyRuleNumber",
        attachmentPolicyRuleNumber
      )
    def getSegmentName: ZIO[Any, AwsError, ConstrainedString] =
      AwsError.unwrapOptionField("segmentName", segmentName)
    def getTags
        : ZIO[Any, AwsError, List[zio.aws.networkmanager.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("tags", tags)
    def getProposedSegmentChange: ZIO[
      Any,
      AwsError,
      zio.aws.networkmanager.model.ProposedSegmentChange.ReadOnly
    ] =
      AwsError.unwrapOptionField("proposedSegmentChange", proposedSegmentChange)
    def getCreatedAt: ZIO[Any, AwsError, DateTime] =
      AwsError.unwrapOptionField("createdAt", createdAt)
    def getUpdatedAt: ZIO[Any, AwsError, DateTime] =
      AwsError.unwrapOptionField("updatedAt", updatedAt)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.networkmanager.model.Attachment
  ) extends zio.aws.networkmanager.model.Attachment.ReadOnly {
    override val coreNetworkId: Optional[CoreNetworkId] = zio.aws.core.internal
      .optionalFromNullable(impl.coreNetworkId())
      .map(value =>
        zio.aws.networkmanager.model.primitives.CoreNetworkId(value)
      )
    override val coreNetworkArn: Optional[CoreNetworkArn] =
      zio.aws.core.internal
        .optionalFromNullable(impl.coreNetworkArn())
        .map(value =>
          zio.aws.networkmanager.model.primitives.CoreNetworkArn(value)
        )
    override val attachmentId: Optional[AttachmentId] = zio.aws.core.internal
      .optionalFromNullable(impl.attachmentId())
      .map(value => zio.aws.networkmanager.model.primitives.AttachmentId(value))
    override val ownerAccountId: Optional[AWSAccountId] = zio.aws.core.internal
      .optionalFromNullable(impl.ownerAccountId())
      .map(value => zio.aws.networkmanager.model.primitives.AWSAccountId(value))
    override val attachmentType
        : Optional[zio.aws.networkmanager.model.AttachmentType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.attachmentType())
        .map(value => zio.aws.networkmanager.model.AttachmentType.wrap(value))
    override val state: Optional[zio.aws.networkmanager.model.AttachmentState] =
      zio.aws.core.internal
        .optionalFromNullable(impl.state())
        .map(value => zio.aws.networkmanager.model.AttachmentState.wrap(value))
    override val edgeLocation: Optional[ExternalRegionCode] =
      zio.aws.core.internal
        .optionalFromNullable(impl.edgeLocation())
        .map(value =>
          zio.aws.networkmanager.model.primitives.ExternalRegionCode(value)
        )
    override val resourceArn: Optional[ResourceArn] = zio.aws.core.internal
      .optionalFromNullable(impl.resourceArn())
      .map(value => zio.aws.networkmanager.model.primitives.ResourceArn(value))
    override val attachmentPolicyRuleNumber: Optional[Integer] =
      zio.aws.core.internal
        .optionalFromNullable(impl.attachmentPolicyRuleNumber())
        .map(value => value: Integer)
    override val segmentName: Optional[ConstrainedString] =
      zio.aws.core.internal
        .optionalFromNullable(impl.segmentName())
        .map(value =>
          zio.aws.networkmanager.model.primitives.ConstrainedString(value)
        )
    override val tags
        : Optional[List[zio.aws.networkmanager.model.Tag.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.tags())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.networkmanager.model.Tag.wrap(item)
          }.toList
        )
    override val proposedSegmentChange: Optional[
      zio.aws.networkmanager.model.ProposedSegmentChange.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.proposedSegmentChange())
      .map(value =>
        zio.aws.networkmanager.model.ProposedSegmentChange.wrap(value)
      )
    override val createdAt: Optional[DateTime] = zio.aws.core.internal
      .optionalFromNullable(impl.createdAt())
      .map(value => zio.aws.networkmanager.model.primitives.DateTime(value))
    override val updatedAt: Optional[DateTime] = zio.aws.core.internal
      .optionalFromNullable(impl.updatedAt())
      .map(value => zio.aws.networkmanager.model.primitives.DateTime(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.networkmanager.model.Attachment
  ): zio.aws.networkmanager.model.Attachment.ReadOnly = new Wrapper(impl)
}
