package zio.aws.networkmanager.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class UpdateVpcAttachmentResponse(
    vpcAttachment: Optional[zio.aws.networkmanager.model.VpcAttachment] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.networkmanager.model.UpdateVpcAttachmentResponse = {
    import UpdateVpcAttachmentResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.networkmanager.model.UpdateVpcAttachmentResponse
      .builder()
      .optionallyWith(vpcAttachment.map(value => value.buildAwsValue()))(
        _.vpcAttachment
      )
      .build()
  }
  def asReadOnly
      : zio.aws.networkmanager.model.UpdateVpcAttachmentResponse.ReadOnly =
    zio.aws.networkmanager.model.UpdateVpcAttachmentResponse
      .wrap(buildAwsValue())
}
object UpdateVpcAttachmentResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.networkmanager.model.UpdateVpcAttachmentResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.networkmanager.model.UpdateVpcAttachmentResponse =
      zio.aws.networkmanager.model.UpdateVpcAttachmentResponse(
        vpcAttachment.map(value => value.asEditable)
      )
    def vpcAttachment
        : Optional[zio.aws.networkmanager.model.VpcAttachment.ReadOnly]
    def getVpcAttachment: ZIO[
      Any,
      AwsError,
      zio.aws.networkmanager.model.VpcAttachment.ReadOnly
    ] = AwsError.unwrapOptionField("vpcAttachment", vpcAttachment)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.networkmanager.model.UpdateVpcAttachmentResponse
  ) extends zio.aws.networkmanager.model.UpdateVpcAttachmentResponse.ReadOnly {
    override val vpcAttachment
        : Optional[zio.aws.networkmanager.model.VpcAttachment.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.vpcAttachment())
        .map(value => zio.aws.networkmanager.model.VpcAttachment.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.networkmanager.model.UpdateVpcAttachmentResponse
  ): zio.aws.networkmanager.model.UpdateVpcAttachmentResponse.ReadOnly =
    new Wrapper(impl)
}
