package zio.aws.networkmanager.model
import zio.ZIO
import zio.aws.networkmanager.model.primitives.ConnectPeerId
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class DeleteConnectPeerRequest(connectPeerId: ConnectPeerId) {
  def buildAwsValue()
      : software.amazon.awssdk.services.networkmanager.model.DeleteConnectPeerRequest = {
    import DeleteConnectPeerRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.networkmanager.model.DeleteConnectPeerRequest
      .builder()
      .connectPeerId(ConnectPeerId.unwrap(connectPeerId): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.networkmanager.model.DeleteConnectPeerRequest.ReadOnly =
    zio.aws.networkmanager.model.DeleteConnectPeerRequest.wrap(buildAwsValue())
}
object DeleteConnectPeerRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.networkmanager.model.DeleteConnectPeerRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.networkmanager.model.DeleteConnectPeerRequest =
      zio.aws.networkmanager.model.DeleteConnectPeerRequest(connectPeerId)
    def connectPeerId: ConnectPeerId
    def getConnectPeerId: ZIO[Any, Nothing, ConnectPeerId] =
      ZIO.succeed(connectPeerId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.networkmanager.model.DeleteConnectPeerRequest
  ) extends zio.aws.networkmanager.model.DeleteConnectPeerRequest.ReadOnly {
    override val connectPeerId: ConnectPeerId =
      zio.aws.networkmanager.model.primitives
        .ConnectPeerId(impl.connectPeerId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.networkmanager.model.DeleteConnectPeerRequest
  ): zio.aws.networkmanager.model.DeleteConnectPeerRequest.ReadOnly =
    new Wrapper(impl)
}
