package zio.aws.networkmanager.model
import zio.ZIO
import zio.aws.networkmanager.model.primitives.{ConnectionId, GlobalNetworkId}
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class DeleteConnectionRequest(
    globalNetworkId: GlobalNetworkId,
    connectionId: ConnectionId
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.networkmanager.model.DeleteConnectionRequest = {
    import DeleteConnectionRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.networkmanager.model.DeleteConnectionRequest
      .builder()
      .globalNetworkId(
        GlobalNetworkId.unwrap(globalNetworkId): java.lang.String
      )
      .connectionId(ConnectionId.unwrap(connectionId): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.networkmanager.model.DeleteConnectionRequest.ReadOnly =
    zio.aws.networkmanager.model.DeleteConnectionRequest.wrap(buildAwsValue())
}
object DeleteConnectionRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.networkmanager.model.DeleteConnectionRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.networkmanager.model.DeleteConnectionRequest =
      zio.aws.networkmanager.model
        .DeleteConnectionRequest(globalNetworkId, connectionId)
    def globalNetworkId: GlobalNetworkId
    def connectionId: ConnectionId
    def getGlobalNetworkId: ZIO[Any, Nothing, GlobalNetworkId] =
      ZIO.succeed(globalNetworkId)
    def getConnectionId: ZIO[Any, Nothing, ConnectionId] =
      ZIO.succeed(connectionId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.networkmanager.model.DeleteConnectionRequest
  ) extends zio.aws.networkmanager.model.DeleteConnectionRequest.ReadOnly {
    override val globalNetworkId: GlobalNetworkId =
      zio.aws.networkmanager.model.primitives
        .GlobalNetworkId(impl.globalNetworkId())
    override val connectionId: ConnectionId =
      zio.aws.networkmanager.model.primitives.ConnectionId(impl.connectionId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.networkmanager.model.DeleteConnectionRequest
  ): zio.aws.networkmanager.model.DeleteConnectionRequest.ReadOnly =
    new Wrapper(impl)
}
