package zio.aws.networkmanager.model
import zio.ZIO
import zio.aws.networkmanager.model.primitives.PeeringId
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class DeletePeeringRequest(peeringId: PeeringId) {
  def buildAwsValue()
      : software.amazon.awssdk.services.networkmanager.model.DeletePeeringRequest = {
    import DeletePeeringRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.networkmanager.model.DeletePeeringRequest
      .builder()
      .peeringId(PeeringId.unwrap(peeringId): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.networkmanager.model.DeletePeeringRequest.ReadOnly =
    zio.aws.networkmanager.model.DeletePeeringRequest.wrap(buildAwsValue())
}
object DeletePeeringRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.networkmanager.model.DeletePeeringRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.networkmanager.model.DeletePeeringRequest =
      zio.aws.networkmanager.model.DeletePeeringRequest(peeringId)
    def peeringId: PeeringId
    def getPeeringId: ZIO[Any, Nothing, PeeringId] = ZIO.succeed(peeringId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.networkmanager.model.DeletePeeringRequest
  ) extends zio.aws.networkmanager.model.DeletePeeringRequest.ReadOnly {
    override val peeringId: PeeringId =
      zio.aws.networkmanager.model.primitives.PeeringId(impl.peeringId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.networkmanager.model.DeletePeeringRequest
  ): zio.aws.networkmanager.model.DeletePeeringRequest.ReadOnly = new Wrapper(
    impl
  )
}
