package zio.aws.networkmanager.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class DeleteLinkResponse(
    link: Optional[zio.aws.networkmanager.model.Link] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.networkmanager.model.DeleteLinkResponse = {
    import DeleteLinkResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.networkmanager.model.DeleteLinkResponse
      .builder()
      .optionallyWith(link.map(value => value.buildAwsValue()))(_.link)
      .build()
  }
  def asReadOnly: zio.aws.networkmanager.model.DeleteLinkResponse.ReadOnly =
    zio.aws.networkmanager.model.DeleteLinkResponse.wrap(buildAwsValue())
}
object DeleteLinkResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.networkmanager.model.DeleteLinkResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.networkmanager.model.DeleteLinkResponse =
      zio.aws.networkmanager.model
        .DeleteLinkResponse(link.map(value => value.asEditable))
    def link: Optional[zio.aws.networkmanager.model.Link.ReadOnly]
    def getLink
        : ZIO[Any, AwsError, zio.aws.networkmanager.model.Link.ReadOnly] =
      AwsError.unwrapOptionField("link", link)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.networkmanager.model.DeleteLinkResponse
  ) extends zio.aws.networkmanager.model.DeleteLinkResponse.ReadOnly {
    override val link: Optional[zio.aws.networkmanager.model.Link.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.link())
        .map(value => zio.aws.networkmanager.model.Link.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.networkmanager.model.DeleteLinkResponse
  ): zio.aws.networkmanager.model.DeleteLinkResponse.ReadOnly = new Wrapper(
    impl
  )
}
