package zio.aws.networkmanager.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.networkmanager.model.primitives.{
  NextToken,
  MaxResults,
  ExternalRegionCode,
  CoreNetworkId
}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class ListPeeringsRequest(
    coreNetworkId: Optional[CoreNetworkId] = Optional.Absent,
    peeringType: Optional[zio.aws.networkmanager.model.PeeringType] =
      Optional.Absent,
    edgeLocation: Optional[ExternalRegionCode] = Optional.Absent,
    state: Optional[zio.aws.networkmanager.model.PeeringState] =
      Optional.Absent,
    maxResults: Optional[MaxResults] = Optional.Absent,
    nextToken: Optional[NextToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.networkmanager.model.ListPeeringsRequest = {
    import ListPeeringsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.networkmanager.model.ListPeeringsRequest
      .builder()
      .optionallyWith(
        coreNetworkId.map(value =>
          CoreNetworkId.unwrap(value): java.lang.String
        )
      )(_.coreNetworkId)
      .optionallyWith(peeringType.map(value => value.unwrap))(_.peeringType)
      .optionallyWith(
        edgeLocation.map(value =>
          ExternalRegionCode.unwrap(value): java.lang.String
        )
      )(_.edgeLocation)
      .optionallyWith(state.map(value => value.unwrap))(_.state)
      .optionallyWith(
        maxResults.map(value => MaxResults.unwrap(value): Integer)
      )(_.maxResults)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly: zio.aws.networkmanager.model.ListPeeringsRequest.ReadOnly =
    zio.aws.networkmanager.model.ListPeeringsRequest.wrap(buildAwsValue())
}
object ListPeeringsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.networkmanager.model.ListPeeringsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.networkmanager.model.ListPeeringsRequest =
      zio.aws.networkmanager.model.ListPeeringsRequest(
        coreNetworkId.map(value => value),
        peeringType.map(value => value),
        edgeLocation.map(value => value),
        state.map(value => value),
        maxResults.map(value => value),
        nextToken.map(value => value)
      )
    def coreNetworkId: Optional[CoreNetworkId]
    def peeringType: Optional[zio.aws.networkmanager.model.PeeringType]
    def edgeLocation: Optional[ExternalRegionCode]
    def state: Optional[zio.aws.networkmanager.model.PeeringState]
    def maxResults: Optional[MaxResults]
    def nextToken: Optional[NextToken]
    def getCoreNetworkId: ZIO[Any, AwsError, CoreNetworkId] =
      AwsError.unwrapOptionField("coreNetworkId", coreNetworkId)
    def getPeeringType
        : ZIO[Any, AwsError, zio.aws.networkmanager.model.PeeringType] =
      AwsError.unwrapOptionField("peeringType", peeringType)
    def getEdgeLocation: ZIO[Any, AwsError, ExternalRegionCode] =
      AwsError.unwrapOptionField("edgeLocation", edgeLocation)
    def getState
        : ZIO[Any, AwsError, zio.aws.networkmanager.model.PeeringState] =
      AwsError.unwrapOptionField("state", state)
    def getMaxResults: ZIO[Any, AwsError, MaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.networkmanager.model.ListPeeringsRequest
  ) extends zio.aws.networkmanager.model.ListPeeringsRequest.ReadOnly {
    override val coreNetworkId: Optional[CoreNetworkId] = zio.aws.core.internal
      .optionalFromNullable(impl.coreNetworkId())
      .map(value =>
        zio.aws.networkmanager.model.primitives.CoreNetworkId(value)
      )
    override val peeringType
        : Optional[zio.aws.networkmanager.model.PeeringType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.peeringType())
        .map(value => zio.aws.networkmanager.model.PeeringType.wrap(value))
    override val edgeLocation: Optional[ExternalRegionCode] =
      zio.aws.core.internal
        .optionalFromNullable(impl.edgeLocation())
        .map(value =>
          zio.aws.networkmanager.model.primitives.ExternalRegionCode(value)
        )
    override val state: Optional[zio.aws.networkmanager.model.PeeringState] =
      zio.aws.core.internal
        .optionalFromNullable(impl.state())
        .map(value => zio.aws.networkmanager.model.PeeringState.wrap(value))
    override val maxResults: Optional[MaxResults] = zio.aws.core.internal
      .optionalFromNullable(impl.maxResults())
      .map(value => zio.aws.networkmanager.model.primitives.MaxResults(value))
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.networkmanager.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.networkmanager.model.ListPeeringsRequest
  ): zio.aws.networkmanager.model.ListPeeringsRequest.ReadOnly = new Wrapper(
    impl
  )
}
