package zio.aws.networkmanager.model
import scala.jdk.CollectionConverters._
sealed trait LinkState {
  def unwrap: software.amazon.awssdk.services.networkmanager.model.LinkState
}
object LinkState {
  def wrap(
      value: software.amazon.awssdk.services.networkmanager.model.LinkState
  ): zio.aws.networkmanager.model.LinkState = value match {
    case software.amazon.awssdk.services.networkmanager.model.LinkState.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.networkmanager.model.LinkState.PENDING =>
      val r = PENDING
      r
    case software.amazon.awssdk.services.networkmanager.model.LinkState.AVAILABLE =>
      val r = AVAILABLE
      r
    case software.amazon.awssdk.services.networkmanager.model.LinkState.DELETING =>
      val r = DELETING
      r
    case software.amazon.awssdk.services.networkmanager.model.LinkState.UPDATING =>
      val r = UPDATING
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.networkmanager.model.LinkState {
    override def unwrap
        : software.amazon.awssdk.services.networkmanager.model.LinkState =
      software.amazon.awssdk.services.networkmanager.model.LinkState.UNKNOWN_TO_SDK_VERSION
  }
  case object PENDING extends zio.aws.networkmanager.model.LinkState {
    override def unwrap
        : software.amazon.awssdk.services.networkmanager.model.LinkState =
      software.amazon.awssdk.services.networkmanager.model.LinkState.PENDING
  }
  case object AVAILABLE extends zio.aws.networkmanager.model.LinkState {
    override def unwrap
        : software.amazon.awssdk.services.networkmanager.model.LinkState =
      software.amazon.awssdk.services.networkmanager.model.LinkState.AVAILABLE
  }
  case object DELETING extends zio.aws.networkmanager.model.LinkState {
    override def unwrap
        : software.amazon.awssdk.services.networkmanager.model.LinkState =
      software.amazon.awssdk.services.networkmanager.model.LinkState.DELETING
  }
  case object UPDATING extends zio.aws.networkmanager.model.LinkState {
    override def unwrap
        : software.amazon.awssdk.services.networkmanager.model.LinkState =
      software.amazon.awssdk.services.networkmanager.model.LinkState.UPDATING
  }
}
