package zio.aws.networkmanager.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class CreateDeviceResponse(
    device: Optional[zio.aws.networkmanager.model.Device] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.networkmanager.model.CreateDeviceResponse = {
    import CreateDeviceResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.networkmanager.model.CreateDeviceResponse
      .builder()
      .optionallyWith(device.map(value => value.buildAwsValue()))(_.device)
      .build()
  }
  def asReadOnly: zio.aws.networkmanager.model.CreateDeviceResponse.ReadOnly =
    zio.aws.networkmanager.model.CreateDeviceResponse.wrap(buildAwsValue())
}
object CreateDeviceResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.networkmanager.model.CreateDeviceResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.networkmanager.model.CreateDeviceResponse =
      zio.aws.networkmanager.model
        .CreateDeviceResponse(device.map(value => value.asEditable))
    def device: Optional[zio.aws.networkmanager.model.Device.ReadOnly]
    def getDevice
        : ZIO[Any, AwsError, zio.aws.networkmanager.model.Device.ReadOnly] =
      AwsError.unwrapOptionField("device", device)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.networkmanager.model.CreateDeviceResponse
  ) extends zio.aws.networkmanager.model.CreateDeviceResponse.ReadOnly {
    override val device
        : Optional[zio.aws.networkmanager.model.Device.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.device())
        .map(value => zio.aws.networkmanager.model.Device.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.networkmanager.model.CreateDeviceResponse
  ): zio.aws.networkmanager.model.CreateDeviceResponse.ReadOnly = new Wrapper(
    impl
  )
}
