package zio.aws.networkmanager.model
import zio.ZIO
import zio.aws.networkmanager.model.primitives.{
  LinkId,
  DeviceId,
  GlobalNetworkId,
  ConnectPeerId
}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ConnectPeerAssociation(
    connectPeerId: Optional[ConnectPeerId] = Optional.Absent,
    globalNetworkId: Optional[GlobalNetworkId] = Optional.Absent,
    deviceId: Optional[DeviceId] = Optional.Absent,
    linkId: Optional[LinkId] = Optional.Absent,
    state: Optional[zio.aws.networkmanager.model.ConnectPeerAssociationState] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.networkmanager.model.ConnectPeerAssociation = {
    import ConnectPeerAssociation.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.networkmanager.model.ConnectPeerAssociation
      .builder()
      .optionallyWith(
        connectPeerId.map(value =>
          ConnectPeerId.unwrap(value): java.lang.String
        )
      )(_.connectPeerId)
      .optionallyWith(
        globalNetworkId.map(value =>
          GlobalNetworkId.unwrap(value): java.lang.String
        )
      )(_.globalNetworkId)
      .optionallyWith(
        deviceId.map(value => DeviceId.unwrap(value): java.lang.String)
      )(_.deviceId)
      .optionallyWith(
        linkId.map(value => LinkId.unwrap(value): java.lang.String)
      )(_.linkId)
      .optionallyWith(state.map(value => value.unwrap))(_.state)
      .build()
  }
  def asReadOnly: zio.aws.networkmanager.model.ConnectPeerAssociation.ReadOnly =
    zio.aws.networkmanager.model.ConnectPeerAssociation.wrap(buildAwsValue())
}
object ConnectPeerAssociation {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.networkmanager.model.ConnectPeerAssociation
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.networkmanager.model.ConnectPeerAssociation =
      zio.aws.networkmanager.model.ConnectPeerAssociation(
        connectPeerId.map(value => value),
        globalNetworkId.map(value => value),
        deviceId.map(value => value),
        linkId.map(value => value),
        state.map(value => value)
      )
    def connectPeerId: Optional[ConnectPeerId]
    def globalNetworkId: Optional[GlobalNetworkId]
    def deviceId: Optional[DeviceId]
    def linkId: Optional[LinkId]
    def state
        : Optional[zio.aws.networkmanager.model.ConnectPeerAssociationState]
    def getConnectPeerId: ZIO[Any, AwsError, ConnectPeerId] =
      AwsError.unwrapOptionField("connectPeerId", connectPeerId)
    def getGlobalNetworkId: ZIO[Any, AwsError, GlobalNetworkId] =
      AwsError.unwrapOptionField("globalNetworkId", globalNetworkId)
    def getDeviceId: ZIO[Any, AwsError, DeviceId] =
      AwsError.unwrapOptionField("deviceId", deviceId)
    def getLinkId: ZIO[Any, AwsError, LinkId] =
      AwsError.unwrapOptionField("linkId", linkId)
    def getState: ZIO[
      Any,
      AwsError,
      zio.aws.networkmanager.model.ConnectPeerAssociationState
    ] = AwsError.unwrapOptionField("state", state)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.networkmanager.model.ConnectPeerAssociation
  ) extends zio.aws.networkmanager.model.ConnectPeerAssociation.ReadOnly {
    override val connectPeerId: Optional[ConnectPeerId] = zio.aws.core.internal
      .optionalFromNullable(impl.connectPeerId())
      .map(value =>
        zio.aws.networkmanager.model.primitives.ConnectPeerId(value)
      )
    override val globalNetworkId: Optional[GlobalNetworkId] =
      zio.aws.core.internal
        .optionalFromNullable(impl.globalNetworkId())
        .map(value =>
          zio.aws.networkmanager.model.primitives.GlobalNetworkId(value)
        )
    override val deviceId: Optional[DeviceId] = zio.aws.core.internal
      .optionalFromNullable(impl.deviceId())
      .map(value => zio.aws.networkmanager.model.primitives.DeviceId(value))
    override val linkId: Optional[LinkId] = zio.aws.core.internal
      .optionalFromNullable(impl.linkId())
      .map(value => zio.aws.networkmanager.model.primitives.LinkId(value))
    override val state
        : Optional[zio.aws.networkmanager.model.ConnectPeerAssociationState] =
      zio.aws.core.internal
        .optionalFromNullable(impl.state())
        .map(value =>
          zio.aws.networkmanager.model.ConnectPeerAssociationState.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.networkmanager.model.ConnectPeerAssociation
  ): zio.aws.networkmanager.model.ConnectPeerAssociation.ReadOnly = new Wrapper(
    impl
  )
}
