package zio.aws.networkmanager.model
import zio.ZIO
import zio.aws.networkmanager.model.primitives.{
  TransitGatewayArn,
  GlobalNetworkId
}
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class DeregisterTransitGatewayRequest(
    globalNetworkId: GlobalNetworkId,
    transitGatewayArn: TransitGatewayArn
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.networkmanager.model.DeregisterTransitGatewayRequest = {
    import DeregisterTransitGatewayRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.networkmanager.model.DeregisterTransitGatewayRequest
      .builder()
      .globalNetworkId(
        GlobalNetworkId.unwrap(globalNetworkId): java.lang.String
      )
      .transitGatewayArn(
        TransitGatewayArn.unwrap(transitGatewayArn): java.lang.String
      )
      .build()
  }
  def asReadOnly
      : zio.aws.networkmanager.model.DeregisterTransitGatewayRequest.ReadOnly =
    zio.aws.networkmanager.model.DeregisterTransitGatewayRequest
      .wrap(buildAwsValue())
}
object DeregisterTransitGatewayRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.networkmanager.model.DeregisterTransitGatewayRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.networkmanager.model.DeregisterTransitGatewayRequest =
      zio.aws.networkmanager.model
        .DeregisterTransitGatewayRequest(globalNetworkId, transitGatewayArn)
    def globalNetworkId: GlobalNetworkId
    def transitGatewayArn: TransitGatewayArn
    def getGlobalNetworkId: ZIO[Any, Nothing, GlobalNetworkId] =
      ZIO.succeed(globalNetworkId)
    def getTransitGatewayArn: ZIO[Any, Nothing, TransitGatewayArn] =
      ZIO.succeed(transitGatewayArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.networkmanager.model.DeregisterTransitGatewayRequest
  ) extends zio.aws.networkmanager.model.DeregisterTransitGatewayRequest.ReadOnly {
    override val globalNetworkId: GlobalNetworkId =
      zio.aws.networkmanager.model.primitives
        .GlobalNetworkId(impl.globalNetworkId())
    override val transitGatewayArn: TransitGatewayArn =
      zio.aws.networkmanager.model.primitives
        .TransitGatewayArn(impl.transitGatewayArn())
  }
  def wrap(
      impl: software.amazon.awssdk.services.networkmanager.model.DeregisterTransitGatewayRequest
  ): zio.aws.networkmanager.model.DeregisterTransitGatewayRequest.ReadOnly =
    new Wrapper(impl)
}
