package zio.aws.networkmanager.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class StartOrganizationServiceAccessUpdateResponse(
    organizationStatus: Optional[
      zio.aws.networkmanager.model.OrganizationStatus
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.networkmanager.model.StartOrganizationServiceAccessUpdateResponse = {
    import StartOrganizationServiceAccessUpdateResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.networkmanager.model.StartOrganizationServiceAccessUpdateResponse
      .builder()
      .optionallyWith(organizationStatus.map(value => value.buildAwsValue()))(
        _.organizationStatus
      )
      .build()
  }
  def asReadOnly
      : zio.aws.networkmanager.model.StartOrganizationServiceAccessUpdateResponse.ReadOnly =
    zio.aws.networkmanager.model.StartOrganizationServiceAccessUpdateResponse
      .wrap(buildAwsValue())
}
object StartOrganizationServiceAccessUpdateResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.networkmanager.model.StartOrganizationServiceAccessUpdateResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.networkmanager.model.StartOrganizationServiceAccessUpdateResponse =
      zio.aws.networkmanager.model.StartOrganizationServiceAccessUpdateResponse(
        organizationStatus.map(value => value.asEditable)
      )
    def organizationStatus
        : Optional[zio.aws.networkmanager.model.OrganizationStatus.ReadOnly]
    def getOrganizationStatus: ZIO[
      Any,
      AwsError,
      zio.aws.networkmanager.model.OrganizationStatus.ReadOnly
    ] = AwsError.unwrapOptionField("organizationStatus", organizationStatus)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.networkmanager.model.StartOrganizationServiceAccessUpdateResponse
  ) extends zio.aws.networkmanager.model.StartOrganizationServiceAccessUpdateResponse.ReadOnly {
    override val organizationStatus
        : Optional[zio.aws.networkmanager.model.OrganizationStatus.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.organizationStatus())
        .map(value =>
          zio.aws.networkmanager.model.OrganizationStatus.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.networkmanager.model.StartOrganizationServiceAccessUpdateResponse
  ): zio.aws.networkmanager.model.StartOrganizationServiceAccessUpdateResponse.ReadOnly =
    new Wrapper(impl)
}
