package zio.aws.networkmanager.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.networkmanager.model.primitives.{
  ConstrainedString,
  SiteArn,
  GlobalNetworkId,
  DateTime,
  SiteId
}
import zio.ZIO
import scala.jdk.CollectionConverters._
final case class Site(
    siteId: Optional[SiteId] = Optional.Absent,
    siteArn: Optional[SiteArn] = Optional.Absent,
    globalNetworkId: Optional[GlobalNetworkId] = Optional.Absent,
    description: Optional[ConstrainedString] = Optional.Absent,
    location: Optional[zio.aws.networkmanager.model.Location] = Optional.Absent,
    createdAt: Optional[DateTime] = Optional.Absent,
    state: Optional[zio.aws.networkmanager.model.SiteState] = Optional.Absent,
    tags: Optional[Iterable[zio.aws.networkmanager.model.Tag]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.networkmanager.model.Site = {
    import Site.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.networkmanager.model.Site
      .builder()
      .optionallyWith(
        siteId.map(value => SiteId.unwrap(value): java.lang.String)
      )(_.siteId)
      .optionallyWith(
        siteArn.map(value => SiteArn.unwrap(value): java.lang.String)
      )(_.siteArn)
      .optionallyWith(
        globalNetworkId.map(value =>
          GlobalNetworkId.unwrap(value): java.lang.String
        )
      )(_.globalNetworkId)
      .optionallyWith(
        description.map(value =>
          ConstrainedString.unwrap(value): java.lang.String
        )
      )(_.description)
      .optionallyWith(location.map(value => value.buildAwsValue()))(_.location)
      .optionallyWith(createdAt.map(value => DateTime.unwrap(value): Instant))(
        _.createdAt
      )
      .optionallyWith(state.map(value => value.unwrap))(_.state)
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .build()
  }
  def asReadOnly: zio.aws.networkmanager.model.Site.ReadOnly =
    zio.aws.networkmanager.model.Site.wrap(buildAwsValue())
}
object Site {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.networkmanager.model.Site
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.networkmanager.model.Site =
      zio.aws.networkmanager.model.Site(
        siteId.map(value => value),
        siteArn.map(value => value),
        globalNetworkId.map(value => value),
        description.map(value => value),
        location.map(value => value.asEditable),
        createdAt.map(value => value),
        state.map(value => value),
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def siteId: Optional[SiteId]
    def siteArn: Optional[SiteArn]
    def globalNetworkId: Optional[GlobalNetworkId]
    def description: Optional[ConstrainedString]
    def location: Optional[zio.aws.networkmanager.model.Location.ReadOnly]
    def createdAt: Optional[DateTime]
    def state: Optional[zio.aws.networkmanager.model.SiteState]
    def tags: Optional[List[zio.aws.networkmanager.model.Tag.ReadOnly]]
    def getSiteId: ZIO[Any, AwsError, SiteId] =
      AwsError.unwrapOptionField("siteId", siteId)
    def getSiteArn: ZIO[Any, AwsError, SiteArn] =
      AwsError.unwrapOptionField("siteArn", siteArn)
    def getGlobalNetworkId: ZIO[Any, AwsError, GlobalNetworkId] =
      AwsError.unwrapOptionField("globalNetworkId", globalNetworkId)
    def getDescription: ZIO[Any, AwsError, ConstrainedString] =
      AwsError.unwrapOptionField("description", description)
    def getLocation
        : ZIO[Any, AwsError, zio.aws.networkmanager.model.Location.ReadOnly] =
      AwsError.unwrapOptionField("location", location)
    def getCreatedAt: ZIO[Any, AwsError, DateTime] =
      AwsError.unwrapOptionField("createdAt", createdAt)
    def getState: ZIO[Any, AwsError, zio.aws.networkmanager.model.SiteState] =
      AwsError.unwrapOptionField("state", state)
    def getTags
        : ZIO[Any, AwsError, List[zio.aws.networkmanager.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.networkmanager.model.Site
  ) extends zio.aws.networkmanager.model.Site.ReadOnly {
    override val siteId: Optional[SiteId] = zio.aws.core.internal
      .optionalFromNullable(impl.siteId())
      .map(value => zio.aws.networkmanager.model.primitives.SiteId(value))
    override val siteArn: Optional[SiteArn] = zio.aws.core.internal
      .optionalFromNullable(impl.siteArn())
      .map(value => zio.aws.networkmanager.model.primitives.SiteArn(value))
    override val globalNetworkId: Optional[GlobalNetworkId] =
      zio.aws.core.internal
        .optionalFromNullable(impl.globalNetworkId())
        .map(value =>
          zio.aws.networkmanager.model.primitives.GlobalNetworkId(value)
        )
    override val description: Optional[ConstrainedString] =
      zio.aws.core.internal
        .optionalFromNullable(impl.description())
        .map(value =>
          zio.aws.networkmanager.model.primitives.ConstrainedString(value)
        )
    override val location
        : Optional[zio.aws.networkmanager.model.Location.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.location())
        .map(value => zio.aws.networkmanager.model.Location.wrap(value))
    override val createdAt: Optional[DateTime] = zio.aws.core.internal
      .optionalFromNullable(impl.createdAt())
      .map(value => zio.aws.networkmanager.model.primitives.DateTime(value))
    override val state: Optional[zio.aws.networkmanager.model.SiteState] =
      zio.aws.core.internal
        .optionalFromNullable(impl.state())
        .map(value => zio.aws.networkmanager.model.SiteState.wrap(value))
    override val tags
        : Optional[List[zio.aws.networkmanager.model.Tag.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.tags())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.networkmanager.model.Tag.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.networkmanager.model.Site
  ): zio.aws.networkmanager.model.Site.ReadOnly = new Wrapper(impl)
}
