package zio.aws.networkmanager.model
import zio.ZIO
import zio.aws.networkmanager.model.primitives.AttachmentId
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class RejectAttachmentRequest(attachmentId: AttachmentId) {
  def buildAwsValue()
      : software.amazon.awssdk.services.networkmanager.model.RejectAttachmentRequest = {
    import RejectAttachmentRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.networkmanager.model.RejectAttachmentRequest
      .builder()
      .attachmentId(AttachmentId.unwrap(attachmentId): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.networkmanager.model.RejectAttachmentRequest.ReadOnly =
    zio.aws.networkmanager.model.RejectAttachmentRequest.wrap(buildAwsValue())
}
object RejectAttachmentRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.networkmanager.model.RejectAttachmentRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.networkmanager.model.RejectAttachmentRequest =
      zio.aws.networkmanager.model.RejectAttachmentRequest(attachmentId)
    def attachmentId: AttachmentId
    def getAttachmentId: ZIO[Any, Nothing, AttachmentId] =
      ZIO.succeed(attachmentId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.networkmanager.model.RejectAttachmentRequest
  ) extends zio.aws.networkmanager.model.RejectAttachmentRequest.ReadOnly {
    override val attachmentId: AttachmentId =
      zio.aws.networkmanager.model.primitives.AttachmentId(impl.attachmentId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.networkmanager.model.RejectAttachmentRequest
  ): zio.aws.networkmanager.model.RejectAttachmentRequest.ReadOnly =
    new Wrapper(impl)
}
