package zio.aws.networkmanager.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class GetTransitGatewayPeeringResponse(
    transitGatewayPeering: Optional[
      zio.aws.networkmanager.model.TransitGatewayPeering
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.networkmanager.model.GetTransitGatewayPeeringResponse = {
    import GetTransitGatewayPeeringResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.networkmanager.model.GetTransitGatewayPeeringResponse
      .builder()
      .optionallyWith(
        transitGatewayPeering.map(value => value.buildAwsValue())
      )(_.transitGatewayPeering)
      .build()
  }
  def asReadOnly
      : zio.aws.networkmanager.model.GetTransitGatewayPeeringResponse.ReadOnly =
    zio.aws.networkmanager.model.GetTransitGatewayPeeringResponse
      .wrap(buildAwsValue())
}
object GetTransitGatewayPeeringResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.networkmanager.model.GetTransitGatewayPeeringResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.networkmanager.model.GetTransitGatewayPeeringResponse =
      zio.aws.networkmanager.model.GetTransitGatewayPeeringResponse(
        transitGatewayPeering.map(value => value.asEditable)
      )
    def transitGatewayPeering
        : Optional[zio.aws.networkmanager.model.TransitGatewayPeering.ReadOnly]
    def getTransitGatewayPeering: ZIO[
      Any,
      AwsError,
      zio.aws.networkmanager.model.TransitGatewayPeering.ReadOnly
    ] =
      AwsError.unwrapOptionField("transitGatewayPeering", transitGatewayPeering)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.networkmanager.model.GetTransitGatewayPeeringResponse
  ) extends zio.aws.networkmanager.model.GetTransitGatewayPeeringResponse.ReadOnly {
    override val transitGatewayPeering: Optional[
      zio.aws.networkmanager.model.TransitGatewayPeering.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.transitGatewayPeering())
      .map(value =>
        zio.aws.networkmanager.model.TransitGatewayPeering.wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.networkmanager.model.GetTransitGatewayPeeringResponse
  ): zio.aws.networkmanager.model.GetTransitGatewayPeeringResponse.ReadOnly =
    new Wrapper(impl)
}
