package zio.aws.networkmanager.model
import zio.ZIO
import zio.aws.networkmanager.model.primitives.{SubnetArn, ConstrainedString}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class AWSLocation(
    zone: Optional[ConstrainedString] = Optional.Absent,
    subnetArn: Optional[SubnetArn] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.networkmanager.model.AWSLocation = {
    import AWSLocation.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.networkmanager.model.AWSLocation
      .builder()
      .optionallyWith(
        zone.map(value => ConstrainedString.unwrap(value): java.lang.String)
      )(_.zone)
      .optionallyWith(
        subnetArn.map(value => SubnetArn.unwrap(value): java.lang.String)
      )(_.subnetArn)
      .build()
  }
  def asReadOnly: zio.aws.networkmanager.model.AWSLocation.ReadOnly =
    zio.aws.networkmanager.model.AWSLocation.wrap(buildAwsValue())
}
object AWSLocation {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.networkmanager.model.AWSLocation
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.networkmanager.model.AWSLocation =
      zio.aws.networkmanager.model
        .AWSLocation(zone.map(value => value), subnetArn.map(value => value))
    def zone: Optional[ConstrainedString]
    def subnetArn: Optional[SubnetArn]
    def getZone: ZIO[Any, AwsError, ConstrainedString] =
      AwsError.unwrapOptionField("zone", zone)
    def getSubnetArn: ZIO[Any, AwsError, SubnetArn] =
      AwsError.unwrapOptionField("subnetArn", subnetArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.networkmanager.model.AWSLocation
  ) extends zio.aws.networkmanager.model.AWSLocation.ReadOnly {
    override val zone: Optional[ConstrainedString] = zio.aws.core.internal
      .optionalFromNullable(impl.zone())
      .map(value =>
        zio.aws.networkmanager.model.primitives.ConstrainedString(value)
      )
    override val subnetArn: Optional[SubnetArn] = zio.aws.core.internal
      .optionalFromNullable(impl.subnetArn())
      .map(value => zio.aws.networkmanager.model.primitives.SubnetArn(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.networkmanager.model.AWSLocation
  ): zio.aws.networkmanager.model.AWSLocation.ReadOnly = new Wrapper(impl)
}
