package zio.aws.networkmanager.model
import zio.ZIO
import zio.aws.networkmanager.model.primitives.{
  CustomerGatewayArn,
  GlobalNetworkId
}
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class DisassociateCustomerGatewayRequest(
    globalNetworkId: GlobalNetworkId,
    customerGatewayArn: CustomerGatewayArn
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.networkmanager.model.DisassociateCustomerGatewayRequest = {
    import DisassociateCustomerGatewayRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.networkmanager.model.DisassociateCustomerGatewayRequest
      .builder()
      .globalNetworkId(
        GlobalNetworkId.unwrap(globalNetworkId): java.lang.String
      )
      .customerGatewayArn(
        CustomerGatewayArn.unwrap(customerGatewayArn): java.lang.String
      )
      .build()
  }
  def asReadOnly
      : zio.aws.networkmanager.model.DisassociateCustomerGatewayRequest.ReadOnly =
    zio.aws.networkmanager.model.DisassociateCustomerGatewayRequest
      .wrap(buildAwsValue())
}
object DisassociateCustomerGatewayRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.networkmanager.model.DisassociateCustomerGatewayRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.networkmanager.model.DisassociateCustomerGatewayRequest =
      zio.aws.networkmanager.model
        .DisassociateCustomerGatewayRequest(globalNetworkId, customerGatewayArn)
    def globalNetworkId: GlobalNetworkId
    def customerGatewayArn: CustomerGatewayArn
    def getGlobalNetworkId: ZIO[Any, Nothing, GlobalNetworkId] =
      ZIO.succeed(globalNetworkId)
    def getCustomerGatewayArn: ZIO[Any, Nothing, CustomerGatewayArn] =
      ZIO.succeed(customerGatewayArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.networkmanager.model.DisassociateCustomerGatewayRequest
  ) extends zio.aws.networkmanager.model.DisassociateCustomerGatewayRequest.ReadOnly {
    override val globalNetworkId: GlobalNetworkId =
      zio.aws.networkmanager.model.primitives
        .GlobalNetworkId(impl.globalNetworkId())
    override val customerGatewayArn: CustomerGatewayArn =
      zio.aws.networkmanager.model.primitives
        .CustomerGatewayArn(impl.customerGatewayArn())
  }
  def wrap(
      impl: software.amazon.awssdk.services.networkmanager.model.DisassociateCustomerGatewayRequest
  ): zio.aws.networkmanager.model.DisassociateCustomerGatewayRequest.ReadOnly =
    new Wrapper(impl)
}
