package zio.aws.networkmanager.model
import zio.ZIO
import zio.aws.networkmanager.model.primitives.{
  ClientToken,
  TransitGatewayArn,
  CoreNetworkId
}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class CreateTransitGatewayPeeringRequest(
    coreNetworkId: CoreNetworkId,
    transitGatewayArn: TransitGatewayArn,
    tags: Optional[Iterable[zio.aws.networkmanager.model.Tag]] =
      Optional.Absent,
    clientToken: Optional[ClientToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.networkmanager.model.CreateTransitGatewayPeeringRequest = {
    import CreateTransitGatewayPeeringRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.networkmanager.model.CreateTransitGatewayPeeringRequest
      .builder()
      .coreNetworkId(CoreNetworkId.unwrap(coreNetworkId): java.lang.String)
      .transitGatewayArn(
        TransitGatewayArn.unwrap(transitGatewayArn): java.lang.String
      )
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .optionallyWith(
        clientToken.map(value => ClientToken.unwrap(value): java.lang.String)
      )(_.clientToken)
      .build()
  }
  def asReadOnly
      : zio.aws.networkmanager.model.CreateTransitGatewayPeeringRequest.ReadOnly =
    zio.aws.networkmanager.model.CreateTransitGatewayPeeringRequest
      .wrap(buildAwsValue())
}
object CreateTransitGatewayPeeringRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.networkmanager.model.CreateTransitGatewayPeeringRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.networkmanager.model.CreateTransitGatewayPeeringRequest =
      zio.aws.networkmanager.model.CreateTransitGatewayPeeringRequest(
        coreNetworkId,
        transitGatewayArn,
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        clientToken.map(value => value)
      )
    def coreNetworkId: CoreNetworkId
    def transitGatewayArn: TransitGatewayArn
    def tags: Optional[List[zio.aws.networkmanager.model.Tag.ReadOnly]]
    def clientToken: Optional[ClientToken]
    def getCoreNetworkId: ZIO[Any, Nothing, CoreNetworkId] =
      ZIO.succeed(coreNetworkId)
    def getTransitGatewayArn: ZIO[Any, Nothing, TransitGatewayArn] =
      ZIO.succeed(transitGatewayArn)
    def getTags
        : ZIO[Any, AwsError, List[zio.aws.networkmanager.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("tags", tags)
    def getClientToken: ZIO[Any, AwsError, ClientToken] =
      AwsError.unwrapOptionField("clientToken", clientToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.networkmanager.model.CreateTransitGatewayPeeringRequest
  ) extends zio.aws.networkmanager.model.CreateTransitGatewayPeeringRequest.ReadOnly {
    override val coreNetworkId: CoreNetworkId =
      zio.aws.networkmanager.model.primitives
        .CoreNetworkId(impl.coreNetworkId())
    override val transitGatewayArn: TransitGatewayArn =
      zio.aws.networkmanager.model.primitives
        .TransitGatewayArn(impl.transitGatewayArn())
    override val tags
        : Optional[List[zio.aws.networkmanager.model.Tag.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.tags())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.networkmanager.model.Tag.wrap(item)
          }.toList
        )
    override val clientToken: Optional[ClientToken] = zio.aws.core.internal
      .optionalFromNullable(impl.clientToken())
      .map(value => zio.aws.networkmanager.model.primitives.ClientToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.networkmanager.model.CreateTransitGatewayPeeringRequest
  ): zio.aws.networkmanager.model.CreateTransitGatewayPeeringRequest.ReadOnly =
    new Wrapper(impl)
}
