package zio.aws.networkmanager.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class CreateConnectionResponse(
    connection: Optional[zio.aws.networkmanager.model.Connection] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.networkmanager.model.CreateConnectionResponse = {
    import CreateConnectionResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.networkmanager.model.CreateConnectionResponse
      .builder()
      .optionallyWith(connection.map(value => value.buildAwsValue()))(
        _.connection
      )
      .build()
  }
  def asReadOnly
      : zio.aws.networkmanager.model.CreateConnectionResponse.ReadOnly =
    zio.aws.networkmanager.model.CreateConnectionResponse.wrap(buildAwsValue())
}
object CreateConnectionResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.networkmanager.model.CreateConnectionResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.networkmanager.model.CreateConnectionResponse =
      zio.aws.networkmanager.model
        .CreateConnectionResponse(connection.map(value => value.asEditable))
    def connection: Optional[zio.aws.networkmanager.model.Connection.ReadOnly]
    def getConnection
        : ZIO[Any, AwsError, zio.aws.networkmanager.model.Connection.ReadOnly] =
      AwsError.unwrapOptionField("connection", connection)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.networkmanager.model.CreateConnectionResponse
  ) extends zio.aws.networkmanager.model.CreateConnectionResponse.ReadOnly {
    override val connection
        : Optional[zio.aws.networkmanager.model.Connection.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.connection())
        .map(value => zio.aws.networkmanager.model.Connection.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.networkmanager.model.CreateConnectionResponse
  ): zio.aws.networkmanager.model.CreateConnectionResponse.ReadOnly =
    new Wrapper(impl)
}
