package zio.aws.networkmanager.model
import zio.ZIO
import zio.aws.networkmanager.model.primitives.TransitGatewayArn
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class TransitGatewayPeering(
    peering: Optional[zio.aws.networkmanager.model.Peering] = Optional.Absent,
    transitGatewayArn: Optional[TransitGatewayArn] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.networkmanager.model.TransitGatewayPeering = {
    import TransitGatewayPeering.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.networkmanager.model.TransitGatewayPeering
      .builder()
      .optionallyWith(peering.map(value => value.buildAwsValue()))(_.peering)
      .optionallyWith(
        transitGatewayArn.map(value =>
          TransitGatewayArn.unwrap(value): java.lang.String
        )
      )(_.transitGatewayArn)
      .build()
  }
  def asReadOnly: zio.aws.networkmanager.model.TransitGatewayPeering.ReadOnly =
    zio.aws.networkmanager.model.TransitGatewayPeering.wrap(buildAwsValue())
}
object TransitGatewayPeering {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.networkmanager.model.TransitGatewayPeering
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.networkmanager.model.TransitGatewayPeering =
      zio.aws.networkmanager.model.TransitGatewayPeering(
        peering.map(value => value.asEditable),
        transitGatewayArn.map(value => value)
      )
    def peering: Optional[zio.aws.networkmanager.model.Peering.ReadOnly]
    def transitGatewayArn: Optional[TransitGatewayArn]
    def getPeering
        : ZIO[Any, AwsError, zio.aws.networkmanager.model.Peering.ReadOnly] =
      AwsError.unwrapOptionField("peering", peering)
    def getTransitGatewayArn: ZIO[Any, AwsError, TransitGatewayArn] =
      AwsError.unwrapOptionField("transitGatewayArn", transitGatewayArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.networkmanager.model.TransitGatewayPeering
  ) extends zio.aws.networkmanager.model.TransitGatewayPeering.ReadOnly {
    override val peering
        : Optional[zio.aws.networkmanager.model.Peering.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.peering())
        .map(value => zio.aws.networkmanager.model.Peering.wrap(value))
    override val transitGatewayArn: Optional[TransitGatewayArn] =
      zio.aws.core.internal
        .optionalFromNullable(impl.transitGatewayArn())
        .map(value =>
          zio.aws.networkmanager.model.primitives.TransitGatewayArn(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.networkmanager.model.TransitGatewayPeering
  ): zio.aws.networkmanager.model.TransitGatewayPeering.ReadOnly = new Wrapper(
    impl
  )
}
