package zio.aws.networkmanager.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.networkmanager.model.primitives.{
  PeeringId,
  DateTime,
  AWSAccountId,
  CoreNetworkArn,
  ExternalRegionCode,
  ResourceArn,
  CoreNetworkId
}
import zio.ZIO
import scala.jdk.CollectionConverters._
final case class Peering(
    coreNetworkId: Optional[CoreNetworkId] = Optional.Absent,
    coreNetworkArn: Optional[CoreNetworkArn] = Optional.Absent,
    peeringId: Optional[PeeringId] = Optional.Absent,
    ownerAccountId: Optional[AWSAccountId] = Optional.Absent,
    peeringType: Optional[zio.aws.networkmanager.model.PeeringType] =
      Optional.Absent,
    state: Optional[zio.aws.networkmanager.model.PeeringState] =
      Optional.Absent,
    edgeLocation: Optional[ExternalRegionCode] = Optional.Absent,
    resourceArn: Optional[ResourceArn] = Optional.Absent,
    tags: Optional[Iterable[zio.aws.networkmanager.model.Tag]] =
      Optional.Absent,
    createdAt: Optional[DateTime] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.networkmanager.model.Peering = {
    import Peering.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.networkmanager.model.Peering
      .builder()
      .optionallyWith(
        coreNetworkId.map(value =>
          CoreNetworkId.unwrap(value): java.lang.String
        )
      )(_.coreNetworkId)
      .optionallyWith(
        coreNetworkArn.map(value =>
          CoreNetworkArn.unwrap(value): java.lang.String
        )
      )(_.coreNetworkArn)
      .optionallyWith(
        peeringId.map(value => PeeringId.unwrap(value): java.lang.String)
      )(_.peeringId)
      .optionallyWith(
        ownerAccountId.map(value =>
          AWSAccountId.unwrap(value): java.lang.String
        )
      )(_.ownerAccountId)
      .optionallyWith(peeringType.map(value => value.unwrap))(_.peeringType)
      .optionallyWith(state.map(value => value.unwrap))(_.state)
      .optionallyWith(
        edgeLocation.map(value =>
          ExternalRegionCode.unwrap(value): java.lang.String
        )
      )(_.edgeLocation)
      .optionallyWith(
        resourceArn.map(value => ResourceArn.unwrap(value): java.lang.String)
      )(_.resourceArn)
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .optionallyWith(createdAt.map(value => DateTime.unwrap(value): Instant))(
        _.createdAt
      )
      .build()
  }
  def asReadOnly: zio.aws.networkmanager.model.Peering.ReadOnly =
    zio.aws.networkmanager.model.Peering.wrap(buildAwsValue())
}
object Peering {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.networkmanager.model.Peering
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.networkmanager.model.Peering =
      zio.aws.networkmanager.model.Peering(
        coreNetworkId.map(value => value),
        coreNetworkArn.map(value => value),
        peeringId.map(value => value),
        ownerAccountId.map(value => value),
        peeringType.map(value => value),
        state.map(value => value),
        edgeLocation.map(value => value),
        resourceArn.map(value => value),
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        createdAt.map(value => value)
      )
    def coreNetworkId: Optional[CoreNetworkId]
    def coreNetworkArn: Optional[CoreNetworkArn]
    def peeringId: Optional[PeeringId]
    def ownerAccountId: Optional[AWSAccountId]
    def peeringType: Optional[zio.aws.networkmanager.model.PeeringType]
    def state: Optional[zio.aws.networkmanager.model.PeeringState]
    def edgeLocation: Optional[ExternalRegionCode]
    def resourceArn: Optional[ResourceArn]
    def tags: Optional[List[zio.aws.networkmanager.model.Tag.ReadOnly]]
    def createdAt: Optional[DateTime]
    def getCoreNetworkId: ZIO[Any, AwsError, CoreNetworkId] =
      AwsError.unwrapOptionField("coreNetworkId", coreNetworkId)
    def getCoreNetworkArn: ZIO[Any, AwsError, CoreNetworkArn] =
      AwsError.unwrapOptionField("coreNetworkArn", coreNetworkArn)
    def getPeeringId: ZIO[Any, AwsError, PeeringId] =
      AwsError.unwrapOptionField("peeringId", peeringId)
    def getOwnerAccountId: ZIO[Any, AwsError, AWSAccountId] =
      AwsError.unwrapOptionField("ownerAccountId", ownerAccountId)
    def getPeeringType
        : ZIO[Any, AwsError, zio.aws.networkmanager.model.PeeringType] =
      AwsError.unwrapOptionField("peeringType", peeringType)
    def getState
        : ZIO[Any, AwsError, zio.aws.networkmanager.model.PeeringState] =
      AwsError.unwrapOptionField("state", state)
    def getEdgeLocation: ZIO[Any, AwsError, ExternalRegionCode] =
      AwsError.unwrapOptionField("edgeLocation", edgeLocation)
    def getResourceArn: ZIO[Any, AwsError, ResourceArn] =
      AwsError.unwrapOptionField("resourceArn", resourceArn)
    def getTags
        : ZIO[Any, AwsError, List[zio.aws.networkmanager.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("tags", tags)
    def getCreatedAt: ZIO[Any, AwsError, DateTime] =
      AwsError.unwrapOptionField("createdAt", createdAt)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.networkmanager.model.Peering
  ) extends zio.aws.networkmanager.model.Peering.ReadOnly {
    override val coreNetworkId: Optional[CoreNetworkId] = zio.aws.core.internal
      .optionalFromNullable(impl.coreNetworkId())
      .map(value =>
        zio.aws.networkmanager.model.primitives.CoreNetworkId(value)
      )
    override val coreNetworkArn: Optional[CoreNetworkArn] =
      zio.aws.core.internal
        .optionalFromNullable(impl.coreNetworkArn())
        .map(value =>
          zio.aws.networkmanager.model.primitives.CoreNetworkArn(value)
        )
    override val peeringId: Optional[PeeringId] = zio.aws.core.internal
      .optionalFromNullable(impl.peeringId())
      .map(value => zio.aws.networkmanager.model.primitives.PeeringId(value))
    override val ownerAccountId: Optional[AWSAccountId] = zio.aws.core.internal
      .optionalFromNullable(impl.ownerAccountId())
      .map(value => zio.aws.networkmanager.model.primitives.AWSAccountId(value))
    override val peeringType
        : Optional[zio.aws.networkmanager.model.PeeringType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.peeringType())
        .map(value => zio.aws.networkmanager.model.PeeringType.wrap(value))
    override val state: Optional[zio.aws.networkmanager.model.PeeringState] =
      zio.aws.core.internal
        .optionalFromNullable(impl.state())
        .map(value => zio.aws.networkmanager.model.PeeringState.wrap(value))
    override val edgeLocation: Optional[ExternalRegionCode] =
      zio.aws.core.internal
        .optionalFromNullable(impl.edgeLocation())
        .map(value =>
          zio.aws.networkmanager.model.primitives.ExternalRegionCode(value)
        )
    override val resourceArn: Optional[ResourceArn] = zio.aws.core.internal
      .optionalFromNullable(impl.resourceArn())
      .map(value => zio.aws.networkmanager.model.primitives.ResourceArn(value))
    override val tags
        : Optional[List[zio.aws.networkmanager.model.Tag.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.tags())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.networkmanager.model.Tag.wrap(item)
          }.toList
        )
    override val createdAt: Optional[DateTime] = zio.aws.core.internal
      .optionalFromNullable(impl.createdAt())
      .map(value => zio.aws.networkmanager.model.primitives.DateTime(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.networkmanager.model.Peering
  ): zio.aws.networkmanager.model.Peering.ReadOnly = new Wrapper(impl)
}
