package zio.aws.networkmanager.model
import scala.jdk.CollectionConverters._
sealed trait AttachmentType {
  def unwrap
      : software.amazon.awssdk.services.networkmanager.model.AttachmentType
}
object AttachmentType {
  def wrap(
      value: software.amazon.awssdk.services.networkmanager.model.AttachmentType
  ): zio.aws.networkmanager.model.AttachmentType = value match {
    case software.amazon.awssdk.services.networkmanager.model.AttachmentType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.networkmanager.model.AttachmentType.CONNECT =>
      val r = CONNECT
      r
    case software.amazon.awssdk.services.networkmanager.model.AttachmentType.SITE_TO_SITE_VPN =>
      val r = SITE_TO_SITE_VPN
      r
    case software.amazon.awssdk.services.networkmanager.model.AttachmentType.VPC =>
      val r = VPC
      r
    case software.amazon.awssdk.services.networkmanager.model.AttachmentType.TRANSIT_GATEWAY_ROUTE_TABLE =>
      val r = TRANSIT_GATEWAY_ROUTE_TABLE
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.networkmanager.model.AttachmentType {
    override def unwrap
        : software.amazon.awssdk.services.networkmanager.model.AttachmentType =
      software.amazon.awssdk.services.networkmanager.model.AttachmentType.UNKNOWN_TO_SDK_VERSION
  }
  case object CONNECT extends zio.aws.networkmanager.model.AttachmentType {
    override def unwrap
        : software.amazon.awssdk.services.networkmanager.model.AttachmentType =
      software.amazon.awssdk.services.networkmanager.model.AttachmentType.CONNECT
  }
  case object SITE_TO_SITE_VPN
      extends zio.aws.networkmanager.model.AttachmentType {
    override def unwrap
        : software.amazon.awssdk.services.networkmanager.model.AttachmentType =
      software.amazon.awssdk.services.networkmanager.model.AttachmentType.SITE_TO_SITE_VPN
  }
  case object VPC extends zio.aws.networkmanager.model.AttachmentType {
    override def unwrap
        : software.amazon.awssdk.services.networkmanager.model.AttachmentType =
      software.amazon.awssdk.services.networkmanager.model.AttachmentType.VPC
  }
  case object TRANSIT_GATEWAY_ROUTE_TABLE
      extends zio.aws.networkmanager.model.AttachmentType {
    override def unwrap
        : software.amazon.awssdk.services.networkmanager.model.AttachmentType =
      software.amazon.awssdk.services.networkmanager.model.AttachmentType.TRANSIT_GATEWAY_ROUTE_TABLE
  }
}
