package zio.aws.networkmanager.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class CreateCoreNetworkResponse(
    coreNetwork: Optional[zio.aws.networkmanager.model.CoreNetwork] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.networkmanager.model.CreateCoreNetworkResponse = {
    import CreateCoreNetworkResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.networkmanager.model.CreateCoreNetworkResponse
      .builder()
      .optionallyWith(coreNetwork.map(value => value.buildAwsValue()))(
        _.coreNetwork
      )
      .build()
  }
  def asReadOnly
      : zio.aws.networkmanager.model.CreateCoreNetworkResponse.ReadOnly =
    zio.aws.networkmanager.model.CreateCoreNetworkResponse.wrap(buildAwsValue())
}
object CreateCoreNetworkResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.networkmanager.model.CreateCoreNetworkResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.networkmanager.model.CreateCoreNetworkResponse =
      zio.aws.networkmanager.model
        .CreateCoreNetworkResponse(coreNetwork.map(value => value.asEditable))
    def coreNetwork: Optional[zio.aws.networkmanager.model.CoreNetwork.ReadOnly]
    def getCoreNetwork: ZIO[
      Any,
      AwsError,
      zio.aws.networkmanager.model.CoreNetwork.ReadOnly
    ] = AwsError.unwrapOptionField("coreNetwork", coreNetwork)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.networkmanager.model.CreateCoreNetworkResponse
  ) extends zio.aws.networkmanager.model.CreateCoreNetworkResponse.ReadOnly {
    override val coreNetwork
        : Optional[zio.aws.networkmanager.model.CoreNetwork.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.coreNetwork())
        .map(value => zio.aws.networkmanager.model.CoreNetwork.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.networkmanager.model.CreateCoreNetworkResponse
  ): zio.aws.networkmanager.model.CreateCoreNetworkResponse.ReadOnly =
    new Wrapper(impl)
}
