package zio.aws.networkmanager.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class RegisterTransitGatewayResponse(
    transitGatewayRegistration: Optional[
      zio.aws.networkmanager.model.TransitGatewayRegistration
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.networkmanager.model.RegisterTransitGatewayResponse = {
    import RegisterTransitGatewayResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.networkmanager.model.RegisterTransitGatewayResponse
      .builder()
      .optionallyWith(
        transitGatewayRegistration.map(value => value.buildAwsValue())
      )(_.transitGatewayRegistration)
      .build()
  }
  def asReadOnly
      : zio.aws.networkmanager.model.RegisterTransitGatewayResponse.ReadOnly =
    zio.aws.networkmanager.model.RegisterTransitGatewayResponse
      .wrap(buildAwsValue())
}
object RegisterTransitGatewayResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.networkmanager.model.RegisterTransitGatewayResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.networkmanager.model.RegisterTransitGatewayResponse =
      zio.aws.networkmanager.model.RegisterTransitGatewayResponse(
        transitGatewayRegistration.map(value => value.asEditable)
      )
    def transitGatewayRegistration: Optional[
      zio.aws.networkmanager.model.TransitGatewayRegistration.ReadOnly
    ]
    def getTransitGatewayRegistration: ZIO[
      Any,
      AwsError,
      zio.aws.networkmanager.model.TransitGatewayRegistration.ReadOnly
    ] = AwsError.unwrapOptionField(
      "transitGatewayRegistration",
      transitGatewayRegistration
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.networkmanager.model.RegisterTransitGatewayResponse
  ) extends zio.aws.networkmanager.model.RegisterTransitGatewayResponse.ReadOnly {
    override val transitGatewayRegistration: Optional[
      zio.aws.networkmanager.model.TransitGatewayRegistration.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.transitGatewayRegistration())
      .map(value =>
        zio.aws.networkmanager.model.TransitGatewayRegistration.wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.networkmanager.model.RegisterTransitGatewayResponse
  ): zio.aws.networkmanager.model.RegisterTransitGatewayResponse.ReadOnly =
    new Wrapper(impl)
}
