package zio.aws.networkmanager.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.networkmanager.model.primitives.{
  NextToken,
  MaxResults,
  TransitGatewayArn,
  GlobalNetworkId
}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class GetTransitGatewayRegistrationsRequest(
    globalNetworkId: GlobalNetworkId,
    transitGatewayArns: Optional[Iterable[TransitGatewayArn]] = Optional.Absent,
    maxResults: Optional[MaxResults] = Optional.Absent,
    nextToken: Optional[NextToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.networkmanager.model.GetTransitGatewayRegistrationsRequest = {
    import GetTransitGatewayRegistrationsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.networkmanager.model.GetTransitGatewayRegistrationsRequest
      .builder()
      .globalNetworkId(
        GlobalNetworkId.unwrap(globalNetworkId): java.lang.String
      )
      .optionallyWith(
        transitGatewayArns.map(value =>
          value.map { item =>
            TransitGatewayArn.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.transitGatewayArns)
      .optionallyWith(
        maxResults.map(value => MaxResults.unwrap(value): Integer)
      )(_.maxResults)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly
      : zio.aws.networkmanager.model.GetTransitGatewayRegistrationsRequest.ReadOnly =
    zio.aws.networkmanager.model.GetTransitGatewayRegistrationsRequest
      .wrap(buildAwsValue())
}
object GetTransitGatewayRegistrationsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.networkmanager.model.GetTransitGatewayRegistrationsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.networkmanager.model.GetTransitGatewayRegistrationsRequest =
      zio.aws.networkmanager.model.GetTransitGatewayRegistrationsRequest(
        globalNetworkId,
        transitGatewayArns.map(value => value),
        maxResults.map(value => value),
        nextToken.map(value => value)
      )
    def globalNetworkId: GlobalNetworkId
    def transitGatewayArns: Optional[List[TransitGatewayArn]]
    def maxResults: Optional[MaxResults]
    def nextToken: Optional[NextToken]
    def getGlobalNetworkId: ZIO[Any, Nothing, GlobalNetworkId] =
      ZIO.succeed(globalNetworkId)
    def getTransitGatewayArns: ZIO[Any, AwsError, List[TransitGatewayArn]] =
      AwsError.unwrapOptionField("transitGatewayArns", transitGatewayArns)
    def getMaxResults: ZIO[Any, AwsError, MaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.networkmanager.model.GetTransitGatewayRegistrationsRequest
  ) extends zio.aws.networkmanager.model.GetTransitGatewayRegistrationsRequest.ReadOnly {
    override val globalNetworkId: GlobalNetworkId =
      zio.aws.networkmanager.model.primitives
        .GlobalNetworkId(impl.globalNetworkId())
    override val transitGatewayArns: Optional[List[TransitGatewayArn]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.transitGatewayArns())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.networkmanager.model.primitives.TransitGatewayArn(item)
          }.toList
        )
    override val maxResults: Optional[MaxResults] = zio.aws.core.internal
      .optionalFromNullable(impl.maxResults())
      .map(value => zio.aws.networkmanager.model.primitives.MaxResults(value))
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.networkmanager.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.networkmanager.model.GetTransitGatewayRegistrationsRequest
  ): zio.aws.networkmanager.model.GetTransitGatewayRegistrationsRequest.ReadOnly =
    new Wrapper(impl)
}
