package zio.aws.networkmanager.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class GetConnectAttachmentResponse(
    connectAttachment: Optional[
      zio.aws.networkmanager.model.ConnectAttachment
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.networkmanager.model.GetConnectAttachmentResponse = {
    import GetConnectAttachmentResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.networkmanager.model.GetConnectAttachmentResponse
      .builder()
      .optionallyWith(connectAttachment.map(value => value.buildAwsValue()))(
        _.connectAttachment
      )
      .build()
  }
  def asReadOnly
      : zio.aws.networkmanager.model.GetConnectAttachmentResponse.ReadOnly =
    zio.aws.networkmanager.model.GetConnectAttachmentResponse
      .wrap(buildAwsValue())
}
object GetConnectAttachmentResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.networkmanager.model.GetConnectAttachmentResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.networkmanager.model.GetConnectAttachmentResponse =
      zio.aws.networkmanager.model.GetConnectAttachmentResponse(
        connectAttachment.map(value => value.asEditable)
      )
    def connectAttachment
        : Optional[zio.aws.networkmanager.model.ConnectAttachment.ReadOnly]
    def getConnectAttachment: ZIO[
      Any,
      AwsError,
      zio.aws.networkmanager.model.ConnectAttachment.ReadOnly
    ] = AwsError.unwrapOptionField("connectAttachment", connectAttachment)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.networkmanager.model.GetConnectAttachmentResponse
  ) extends zio.aws.networkmanager.model.GetConnectAttachmentResponse.ReadOnly {
    override val connectAttachment
        : Optional[zio.aws.networkmanager.model.ConnectAttachment.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.connectAttachment())
        .map(value =>
          zio.aws.networkmanager.model.ConnectAttachment.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.networkmanager.model.GetConnectAttachmentResponse
  ): zio.aws.networkmanager.model.GetConnectAttachmentResponse.ReadOnly =
    new Wrapper(impl)
}
