package zio.aws.networkmanager.model
import scala.jdk.CollectionConverters._
sealed trait RouteAnalysisCompletionResultCode {
  def unwrap: software.amazon.awssdk.services.networkmanager.model.RouteAnalysisCompletionResultCode
}
object RouteAnalysisCompletionResultCode {
  def wrap(
      value: software.amazon.awssdk.services.networkmanager.model.RouteAnalysisCompletionResultCode
  ): zio.aws.networkmanager.model.RouteAnalysisCompletionResultCode =
    value match {
      case software.amazon.awssdk.services.networkmanager.model.RouteAnalysisCompletionResultCode.UNKNOWN_TO_SDK_VERSION =>
        val r = unknownToSdkVersion
        r
      case software.amazon.awssdk.services.networkmanager.model.RouteAnalysisCompletionResultCode.CONNECTED =>
        val r = CONNECTED
        r
      case software.amazon.awssdk.services.networkmanager.model.RouteAnalysisCompletionResultCode.NOT_CONNECTED =>
        val r = NOT_CONNECTED
        r
    }
  case object unknownToSdkVersion
      extends zio.aws.networkmanager.model.RouteAnalysisCompletionResultCode {
    override def unwrap
        : software.amazon.awssdk.services.networkmanager.model.RouteAnalysisCompletionResultCode =
      software.amazon.awssdk.services.networkmanager.model.RouteAnalysisCompletionResultCode.UNKNOWN_TO_SDK_VERSION
  }
  case object CONNECTED
      extends zio.aws.networkmanager.model.RouteAnalysisCompletionResultCode {
    override def unwrap
        : software.amazon.awssdk.services.networkmanager.model.RouteAnalysisCompletionResultCode =
      software.amazon.awssdk.services.networkmanager.model.RouteAnalysisCompletionResultCode.CONNECTED
  }
  case object NOT_CONNECTED
      extends zio.aws.networkmanager.model.RouteAnalysisCompletionResultCode {
    override def unwrap
        : software.amazon.awssdk.services.networkmanager.model.RouteAnalysisCompletionResultCode =
      software.amazon.awssdk.services.networkmanager.model.RouteAnalysisCompletionResultCode.NOT_CONNECTED
  }
}
