package zio.aws.networkmanager.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class DeleteConnectPeerResponse(
    connectPeer: Optional[zio.aws.networkmanager.model.ConnectPeer] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.networkmanager.model.DeleteConnectPeerResponse = {
    import DeleteConnectPeerResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.networkmanager.model.DeleteConnectPeerResponse
      .builder()
      .optionallyWith(connectPeer.map(value => value.buildAwsValue()))(
        _.connectPeer
      )
      .build()
  }
  def asReadOnly
      : zio.aws.networkmanager.model.DeleteConnectPeerResponse.ReadOnly =
    zio.aws.networkmanager.model.DeleteConnectPeerResponse.wrap(buildAwsValue())
}
object DeleteConnectPeerResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.networkmanager.model.DeleteConnectPeerResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.networkmanager.model.DeleteConnectPeerResponse =
      zio.aws.networkmanager.model
        .DeleteConnectPeerResponse(connectPeer.map(value => value.asEditable))
    def connectPeer: Optional[zio.aws.networkmanager.model.ConnectPeer.ReadOnly]
    def getConnectPeer: ZIO[
      Any,
      AwsError,
      zio.aws.networkmanager.model.ConnectPeer.ReadOnly
    ] = AwsError.unwrapOptionField("connectPeer", connectPeer)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.networkmanager.model.DeleteConnectPeerResponse
  ) extends zio.aws.networkmanager.model.DeleteConnectPeerResponse.ReadOnly {
    override val connectPeer
        : Optional[zio.aws.networkmanager.model.ConnectPeer.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.connectPeer())
        .map(value => zio.aws.networkmanager.model.ConnectPeer.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.networkmanager.model.DeleteConnectPeerResponse
  ): zio.aws.networkmanager.model.DeleteConnectPeerResponse.ReadOnly =
    new Wrapper(impl)
}
