package zio.aws.networkmanager
import zio.aws.networkmanager.model.GetCoreNetworkPolicyResponse.ReadOnly
import zio.aws.networkmanager.model.{
  GetNetworkResourcesRequest,
  CreateLinkRequest,
  GetTransitGatewayRegistrationsRequest,
  DeleteConnectPeerRequest,
  AcceptAttachmentRequest,
  ListAttachmentsRequest,
  DeleteCoreNetworkPolicyVersionRequest,
  DeleteGlobalNetworkRequest,
  RejectAttachmentRequest,
  DisassociateCustomerGatewayRequest,
  DeleteSiteRequest,
  DeleteLinkRequest,
  StartOrganizationServiceAccessUpdateRequest,
  GetRouteAnalysisRequest,
  CreateVpcAttachmentRequest,
  UpdateCoreNetworkRequest,
  CreateConnectPeerRequest,
  CreateConnectionRequest,
  DescribeGlobalNetworksRequest,
  StartRouteAnalysisRequest,
  AssociateCustomerGatewayRequest,
  GetNetworkResourceRelationshipsRequest,
  PutCoreNetworkPolicyRequest,
  PutResourcePolicyRequest,
  GetSitesRequest,
  GetNetworkResourceCountsRequest,
  CreateSiteToSiteVpnAttachmentRequest,
  GetSiteToSiteVpnAttachmentRequest,
  AssociateConnectPeerRequest,
  UpdateSiteRequest,
  GetNetworkTelemetryRequest,
  DeleteCoreNetworkRequest,
  ListTagsForResourceRequest,
  GetLinksRequest,
  GetCoreNetworkChangeSetRequest,
  UpdateNetworkResourceMetadataRequest,
  GetConnectAttachmentRequest,
  GetNetworkRoutesRequest,
  GetVpcAttachmentRequest,
  GetDevicesRequest,
  DisassociateConnectPeerRequest,
  ListOrganizationServiceAccessStatusRequest,
  DeleteConnectionRequest,
  UpdateVpcAttachmentRequest,
  ExecuteCoreNetworkChangeSetRequest,
  AssociateTransitGatewayConnectPeerRequest,
  GetCoreNetworkPolicyRequest,
  GetConnectPeerAssociationsRequest,
  GetTransitGatewayConnectPeerAssociationsRequest,
  ListConnectPeersRequest,
  UpdateConnectionRequest,
  UpdateGlobalNetworkRequest,
  DisassociateTransitGatewayConnectPeerRequest,
  GetLinkAssociationsRequest,
  DeleteResourcePolicyRequest,
  RestoreCoreNetworkPolicyVersionRequest,
  DeleteAttachmentRequest,
  UntagResourceRequest,
  CreateCoreNetworkRequest,
  RegisterTransitGatewayRequest,
  GetCustomerGatewayAssociationsRequest,
  ListCoreNetworksRequest,
  GetConnectPeerRequest,
  UpdateLinkRequest,
  ListCoreNetworkPolicyVersionsRequest,
  AssociateLinkRequest,
  CreateConnectAttachmentRequest,
  UpdateDeviceRequest,
  CreateDeviceRequest,
  GetResourcePolicyRequest,
  CreateGlobalNetworkRequest,
  DeregisterTransitGatewayRequest,
  DisassociateLinkRequest,
  DeleteDeviceRequest,
  CreateSiteRequest,
  GetConnectionsRequest,
  GetCoreNetworkRequest,
  TagResourceRequest
}
import zio.aws.core.config.AwsConfig
import software.amazon.awssdk.services.networkmanager.{
  NetworkManagerAsyncClientBuilder,
  NetworkManagerAsyncClient
}
import zio.aws.core.{AwsServiceBase, AwsError}
import zio.aws.core.aspects.{AwsCallAspect, AspectSupport}
import zio.{ZEnvironment, IO, ZIO, ZLayer, Scope}
import zio.stream.ZStream
import software.amazon.awssdk.services.networkmanager.model.{
  ExecuteCoreNetworkChangeSetResponse,
  NetworkResourceCount,
  ListCoreNetworksResponse,
  Link,
  CreateSiteResponse,
  ConnectPeerSummary,
  DeleteDeviceResponse,
  CustomerGatewayAssociation,
  CreateDeviceResponse,
  GetResourcePolicyResponse,
  GetConnectPeerResponse,
  DeleteConnectPeerResponse,
  DeleteConnectionResponse,
  DisassociateTransitGatewayConnectPeerResponse,
  CoreNetworkPolicyVersion,
  RejectAttachmentResponse,
  DisassociateCustomerGatewayResponse,
  PutResourcePolicyResponse,
  AcceptAttachmentResponse,
  DeregisterTransitGatewayResponse,
  GetCoreNetworkPolicyResponse,
  StartRouteAnalysisResponse,
  DescribeGlobalNetworksResponse,
  UpdateSiteResponse,
  CreateCoreNetworkResponse,
  CreateVpcAttachmentResponse,
  Site,
  DisassociateLinkResponse,
  GetRouteAnalysisResponse,
  Relationship,
  AssociateCustomerGatewayResponse,
  CoreNetworkChange,
  TransitGatewayRegistration,
  GetLinksResponse,
  ListAttachmentsResponse,
  ConnectPeerAssociation,
  Attachment,
  GetVpcAttachmentResponse,
  CreateConnectionResponse,
  GetConnectAttachmentResponse,
  GetSitesResponse,
  ListConnectPeersResponse,
  AssociateLinkResponse,
  UpdateVpcAttachmentResponse,
  UpdateNetworkResourceMetadataResponse,
  NetworkResource,
  GlobalNetwork,
  GetDevicesResponse,
  GetNetworkResourceCountsResponse,
  NetworkTelemetry,
  DeleteSiteResponse,
  UpdateCoreNetworkResponse,
  GetTransitGatewayConnectPeerAssociationsResponse,
  GetNetworkResourceRelationshipsResponse,
  CreateConnectAttachmentResponse,
  GetConnectionsResponse,
  GetNetworkResourcesResponse,
  GetSiteToSiteVpnAttachmentResponse,
  CreateLinkResponse,
  RestoreCoreNetworkPolicyVersionResponse,
  ListTagsForResourceResponse,
  ListCoreNetworkPolicyVersionsResponse,
  PutCoreNetworkPolicyResponse,
  UntagResourceResponse,
  GetCoreNetworkChangeSetResponse,
  CreateGlobalNetworkResponse,
  AssociateConnectPeerResponse,
  Connection,
  DeleteAttachmentResponse,
  DeleteLinkResponse,
  GetCustomerGatewayAssociationsResponse,
  CreateSiteToSiteVpnAttachmentResponse,
  GetLinkAssociationsResponse,
  UpdateGlobalNetworkResponse,
  Device,
  GetConnectPeerAssociationsResponse,
  DeleteCoreNetworkPolicyVersionResponse,
  GetTransitGatewayRegistrationsResponse,
  UpdateLinkResponse,
  GetCoreNetworkResponse,
  GetNetworkTelemetryResponse,
  RegisterTransitGatewayResponse,
  DeleteCoreNetworkResponse,
  UpdateDeviceResponse,
  LinkAssociation,
  CoreNetworkSummary,
  TransitGatewayConnectPeerAssociation,
  DeleteResourcePolicyResponse,
  GetNetworkRoutesResponse,
  TagResourceResponse,
  CreateConnectPeerResponse,
  StartOrganizationServiceAccessUpdateResponse,
  ListOrganizationServiceAccessStatusResponse,
  AssociateTransitGatewayConnectPeerResponse,
  UpdateConnectionResponse,
  DeleteGlobalNetworkResponse,
  DisassociateConnectPeerResponse
}
import scala.jdk.CollectionConverters._
trait NetworkManager extends AspectSupport[NetworkManager] {
  val api: NetworkManagerAsyncClient
  def getConnections(
      request: GetConnectionsRequest
  ): ZStream[Any, AwsError, zio.aws.networkmanager.model.Connection.ReadOnly]
  def getConnectionsPaginated(
      request: GetConnectionsRequest
  ): IO[AwsError, zio.aws.networkmanager.model.GetConnectionsResponse.ReadOnly]
  def listOrganizationServiceAccessStatus(
      request: ListOrganizationServiceAccessStatusRequest
  ): IO[
    AwsError,
    zio.aws.networkmanager.model.ListOrganizationServiceAccessStatusResponse.ReadOnly
  ]
  def listConnectPeers(request: ListConnectPeersRequest): ZStream[
    Any,
    AwsError,
    zio.aws.networkmanager.model.ConnectPeerSummary.ReadOnly
  ]
  def listConnectPeersPaginated(request: ListConnectPeersRequest): IO[
    AwsError,
    zio.aws.networkmanager.model.ListConnectPeersResponse.ReadOnly
  ]
  def disassociateTransitGatewayConnectPeer(
      request: DisassociateTransitGatewayConnectPeerRequest
  ): IO[
    AwsError,
    zio.aws.networkmanager.model.DisassociateTransitGatewayConnectPeerResponse.ReadOnly
  ]
  def describeGlobalNetworks(
      request: DescribeGlobalNetworksRequest
  ): ZStream[Any, AwsError, zio.aws.networkmanager.model.GlobalNetwork.ReadOnly]
  def describeGlobalNetworksPaginated(
      request: DescribeGlobalNetworksRequest
  ): IO[
    AwsError,
    zio.aws.networkmanager.model.DescribeGlobalNetworksResponse.ReadOnly
  ]
  def createCoreNetwork(request: CreateCoreNetworkRequest): IO[
    AwsError,
    zio.aws.networkmanager.model.CreateCoreNetworkResponse.ReadOnly
  ]
  def getCoreNetworkPolicy(
      request: GetCoreNetworkPolicyRequest
  ): IO[AwsError, ReadOnly]
  def createSite(
      request: CreateSiteRequest
  ): IO[AwsError, zio.aws.networkmanager.model.CreateSiteResponse.ReadOnly]
  def executeCoreNetworkChangeSet(
      request: ExecuteCoreNetworkChangeSetRequest
  ): IO[
    AwsError,
    zio.aws.networkmanager.model.ExecuteCoreNetworkChangeSetResponse.ReadOnly
  ]
  def startRouteAnalysis(request: StartRouteAnalysisRequest): IO[
    AwsError,
    zio.aws.networkmanager.model.StartRouteAnalysisResponse.ReadOnly
  ]
  def rejectAttachment(request: RejectAttachmentRequest): IO[
    AwsError,
    zio.aws.networkmanager.model.RejectAttachmentResponse.ReadOnly
  ]
  def disassociateLink(request: DisassociateLinkRequest): IO[
    AwsError,
    zio.aws.networkmanager.model.DisassociateLinkResponse.ReadOnly
  ]
  def createConnection(request: CreateConnectionRequest): IO[
    AwsError,
    zio.aws.networkmanager.model.CreateConnectionResponse.ReadOnly
  ]
  def createDevice(
      request: CreateDeviceRequest
  ): IO[AwsError, zio.aws.networkmanager.model.CreateDeviceResponse.ReadOnly]
  def deleteDevice(
      request: DeleteDeviceRequest
  ): IO[AwsError, zio.aws.networkmanager.model.DeleteDeviceResponse.ReadOnly]
  def restoreCoreNetworkPolicyVersion(
      request: RestoreCoreNetworkPolicyVersionRequest
  ): IO[
    AwsError,
    zio.aws.networkmanager.model.RestoreCoreNetworkPolicyVersionResponse.ReadOnly
  ]
  def deregisterTransitGateway(request: DeregisterTransitGatewayRequest): IO[
    AwsError,
    zio.aws.networkmanager.model.DeregisterTransitGatewayResponse.ReadOnly
  ]
  def updateVpcAttachment(request: UpdateVpcAttachmentRequest): IO[
    AwsError,
    zio.aws.networkmanager.model.UpdateVpcAttachmentResponse.ReadOnly
  ]
  def deleteCoreNetworkPolicyVersion(
      request: DeleteCoreNetworkPolicyVersionRequest
  ): IO[
    AwsError,
    zio.aws.networkmanager.model.DeleteCoreNetworkPolicyVersionResponse.ReadOnly
  ]
  def getConnectPeer(
      request: GetConnectPeerRequest
  ): IO[AwsError, zio.aws.networkmanager.model.GetConnectPeerResponse.ReadOnly]
  def updateLink(
      request: UpdateLinkRequest
  ): IO[AwsError, zio.aws.networkmanager.model.UpdateLinkResponse.ReadOnly]
  def updateConnection(request: UpdateConnectionRequest): IO[
    AwsError,
    zio.aws.networkmanager.model.UpdateConnectionResponse.ReadOnly
  ]
  def createConnectPeer(request: CreateConnectPeerRequest): IO[
    AwsError,
    zio.aws.networkmanager.model.CreateConnectPeerResponse.ReadOnly
  ]
  def getTransitGatewayRegistrations(
      request: GetTransitGatewayRegistrationsRequest
  ): ZStream[
    Any,
    AwsError,
    zio.aws.networkmanager.model.TransitGatewayRegistration.ReadOnly
  ]
  def getTransitGatewayRegistrationsPaginated(
      request: GetTransitGatewayRegistrationsRequest
  ): IO[
    AwsError,
    zio.aws.networkmanager.model.GetTransitGatewayRegistrationsResponse.ReadOnly
  ]
  def putResourcePolicy(request: PutResourcePolicyRequest): IO[
    AwsError,
    zio.aws.networkmanager.model.PutResourcePolicyResponse.ReadOnly
  ]
  def deleteGlobalNetwork(request: DeleteGlobalNetworkRequest): IO[
    AwsError,
    zio.aws.networkmanager.model.DeleteGlobalNetworkResponse.ReadOnly
  ]
  def updateCoreNetwork(request: UpdateCoreNetworkRequest): IO[
    AwsError,
    zio.aws.networkmanager.model.UpdateCoreNetworkResponse.ReadOnly
  ]
  def getTransitGatewayConnectPeerAssociations(
      request: GetTransitGatewayConnectPeerAssociationsRequest
  ): ZStream[
    Any,
    AwsError,
    zio.aws.networkmanager.model.TransitGatewayConnectPeerAssociation.ReadOnly
  ]
  def getTransitGatewayConnectPeerAssociationsPaginated(
      request: GetTransitGatewayConnectPeerAssociationsRequest
  ): IO[
    AwsError,
    zio.aws.networkmanager.model.GetTransitGatewayConnectPeerAssociationsResponse.ReadOnly
  ]
  def getSiteToSiteVpnAttachment(
      request: GetSiteToSiteVpnAttachmentRequest
  ): IO[
    AwsError,
    zio.aws.networkmanager.model.GetSiteToSiteVpnAttachmentResponse.ReadOnly
  ]
  def getLinks(
      request: GetLinksRequest
  ): ZStream[Any, AwsError, zio.aws.networkmanager.model.Link.ReadOnly]
  def getLinksPaginated(
      request: GetLinksRequest
  ): IO[AwsError, zio.aws.networkmanager.model.GetLinksResponse.ReadOnly]
  def getCustomerGatewayAssociations(
      request: GetCustomerGatewayAssociationsRequest
  ): ZStream[
    Any,
    AwsError,
    zio.aws.networkmanager.model.CustomerGatewayAssociation.ReadOnly
  ]
  def getCustomerGatewayAssociationsPaginated(
      request: GetCustomerGatewayAssociationsRequest
  ): IO[
    AwsError,
    zio.aws.networkmanager.model.GetCustomerGatewayAssociationsResponse.ReadOnly
  ]
  def deleteCoreNetwork(request: DeleteCoreNetworkRequest): IO[
    AwsError,
    zio.aws.networkmanager.model.DeleteCoreNetworkResponse.ReadOnly
  ]
  def getNetworkTelemetry(request: GetNetworkTelemetryRequest): ZStream[
    Any,
    AwsError,
    zio.aws.networkmanager.model.NetworkTelemetry.ReadOnly
  ]
  def getNetworkTelemetryPaginated(request: GetNetworkTelemetryRequest): IO[
    AwsError,
    zio.aws.networkmanager.model.GetNetworkTelemetryResponse.ReadOnly
  ]
  def getCoreNetworkChangeSet(request: GetCoreNetworkChangeSetRequest): ZStream[
    Any,
    AwsError,
    zio.aws.networkmanager.model.CoreNetworkChange.ReadOnly
  ]
  def getCoreNetworkChangeSetPaginated(
      request: GetCoreNetworkChangeSetRequest
  ): IO[
    AwsError,
    zio.aws.networkmanager.model.GetCoreNetworkChangeSetResponse.ReadOnly
  ]
  def getNetworkRoutes(request: GetNetworkRoutesRequest): IO[
    AwsError,
    zio.aws.networkmanager.model.GetNetworkRoutesResponse.ReadOnly
  ]
  def getCoreNetwork(
      request: GetCoreNetworkRequest
  ): IO[AwsError, zio.aws.networkmanager.model.GetCoreNetworkResponse.ReadOnly]
  def createGlobalNetwork(request: CreateGlobalNetworkRequest): IO[
    AwsError,
    zio.aws.networkmanager.model.CreateGlobalNetworkResponse.ReadOnly
  ]
  def deleteSite(
      request: DeleteSiteRequest
  ): IO[AwsError, zio.aws.networkmanager.model.DeleteSiteResponse.ReadOnly]
  def listCoreNetworkPolicyVersions(
      request: ListCoreNetworkPolicyVersionsRequest
  ): ZStream[
    Any,
    AwsError,
    zio.aws.networkmanager.model.CoreNetworkPolicyVersion.ReadOnly
  ]
  def listCoreNetworkPolicyVersionsPaginated(
      request: ListCoreNetworkPolicyVersionsRequest
  ): IO[
    AwsError,
    zio.aws.networkmanager.model.ListCoreNetworkPolicyVersionsResponse.ReadOnly
  ]
  def getNetworkResources(request: GetNetworkResourcesRequest): ZStream[
    Any,
    AwsError,
    zio.aws.networkmanager.model.NetworkResource.ReadOnly
  ]
  def getNetworkResourcesPaginated(request: GetNetworkResourcesRequest): IO[
    AwsError,
    zio.aws.networkmanager.model.GetNetworkResourcesResponse.ReadOnly
  ]
  def registerTransitGateway(request: RegisterTransitGatewayRequest): IO[
    AwsError,
    zio.aws.networkmanager.model.RegisterTransitGatewayResponse.ReadOnly
  ]
  def getLinkAssociations(request: GetLinkAssociationsRequest): ZStream[
    Any,
    AwsError,
    zio.aws.networkmanager.model.LinkAssociation.ReadOnly
  ]
  def getLinkAssociationsPaginated(request: GetLinkAssociationsRequest): IO[
    AwsError,
    zio.aws.networkmanager.model.GetLinkAssociationsResponse.ReadOnly
  ]
  def startOrganizationServiceAccessUpdate(
      request: StartOrganizationServiceAccessUpdateRequest
  ): IO[
    AwsError,
    zio.aws.networkmanager.model.StartOrganizationServiceAccessUpdateResponse.ReadOnly
  ]
  def untagResource(
      request: UntagResourceRequest
  ): IO[AwsError, zio.aws.networkmanager.model.UntagResourceResponse.ReadOnly]
  def getRouteAnalysis(request: GetRouteAnalysisRequest): IO[
    AwsError,
    zio.aws.networkmanager.model.GetRouteAnalysisResponse.ReadOnly
  ]
  def getSites(
      request: GetSitesRequest
  ): ZStream[Any, AwsError, zio.aws.networkmanager.model.Site.ReadOnly]
  def getSitesPaginated(
      request: GetSitesRequest
  ): IO[AwsError, zio.aws.networkmanager.model.GetSitesResponse.ReadOnly]
  def associateLink(
      request: AssociateLinkRequest
  ): IO[AwsError, zio.aws.networkmanager.model.AssociateLinkResponse.ReadOnly]
  def createConnectAttachment(request: CreateConnectAttachmentRequest): IO[
    AwsError,
    zio.aws.networkmanager.model.CreateConnectAttachmentResponse.ReadOnly
  ]
  def deleteResourcePolicy(request: DeleteResourcePolicyRequest): IO[
    AwsError,
    zio.aws.networkmanager.model.DeleteResourcePolicyResponse.ReadOnly
  ]
  def getConnectPeerAssociations(
      request: GetConnectPeerAssociationsRequest
  ): ZStream[
    Any,
    AwsError,
    zio.aws.networkmanager.model.ConnectPeerAssociation.ReadOnly
  ]
  def getConnectPeerAssociationsPaginated(
      request: GetConnectPeerAssociationsRequest
  ): IO[
    AwsError,
    zio.aws.networkmanager.model.GetConnectPeerAssociationsResponse.ReadOnly
  ]
  def getVpcAttachment(request: GetVpcAttachmentRequest): IO[
    AwsError,
    zio.aws.networkmanager.model.GetVpcAttachmentResponse.ReadOnly
  ]
  def getDevices(
      request: GetDevicesRequest
  ): ZStream[Any, AwsError, zio.aws.networkmanager.model.Device.ReadOnly]
  def getDevicesPaginated(
      request: GetDevicesRequest
  ): IO[AwsError, zio.aws.networkmanager.model.GetDevicesResponse.ReadOnly]
  def getNetworkResourceCounts(
      request: GetNetworkResourceCountsRequest
  ): ZStream[
    Any,
    AwsError,
    zio.aws.networkmanager.model.NetworkResourceCount.ReadOnly
  ]
  def getNetworkResourceCountsPaginated(
      request: GetNetworkResourceCountsRequest
  ): IO[
    AwsError,
    zio.aws.networkmanager.model.GetNetworkResourceCountsResponse.ReadOnly
  ]
  def createSiteToSiteVpnAttachment(
      request: CreateSiteToSiteVpnAttachmentRequest
  ): IO[
    AwsError,
    zio.aws.networkmanager.model.CreateSiteToSiteVpnAttachmentResponse.ReadOnly
  ]
  def updateDevice(
      request: UpdateDeviceRequest
  ): IO[AwsError, zio.aws.networkmanager.model.UpdateDeviceResponse.ReadOnly]
  def listTagsForResource(request: ListTagsForResourceRequest): IO[
    AwsError,
    zio.aws.networkmanager.model.ListTagsForResourceResponse.ReadOnly
  ]
  def listCoreNetworks(request: ListCoreNetworksRequest): ZStream[
    Any,
    AwsError,
    zio.aws.networkmanager.model.CoreNetworkSummary.ReadOnly
  ]
  def listCoreNetworksPaginated(request: ListCoreNetworksRequest): IO[
    AwsError,
    zio.aws.networkmanager.model.ListCoreNetworksResponse.ReadOnly
  ]
  def deleteConnection(request: DeleteConnectionRequest): IO[
    AwsError,
    zio.aws.networkmanager.model.DeleteConnectionResponse.ReadOnly
  ]
  def tagResource(
      request: TagResourceRequest
  ): IO[AwsError, zio.aws.networkmanager.model.TagResourceResponse.ReadOnly]
  def listAttachments(
      request: ListAttachmentsRequest
  ): ZStream[Any, AwsError, zio.aws.networkmanager.model.Attachment.ReadOnly]
  def listAttachmentsPaginated(
      request: ListAttachmentsRequest
  ): IO[AwsError, zio.aws.networkmanager.model.ListAttachmentsResponse.ReadOnly]
  def acceptAttachment(request: AcceptAttachmentRequest): IO[
    AwsError,
    zio.aws.networkmanager.model.AcceptAttachmentResponse.ReadOnly
  ]
  def updateSite(
      request: UpdateSiteRequest
  ): IO[AwsError, zio.aws.networkmanager.model.UpdateSiteResponse.ReadOnly]
  def updateNetworkResourceMetadata(
      request: UpdateNetworkResourceMetadataRequest
  ): IO[
    AwsError,
    zio.aws.networkmanager.model.UpdateNetworkResourceMetadataResponse.ReadOnly
  ]
  def associateCustomerGateway(request: AssociateCustomerGatewayRequest): IO[
    AwsError,
    zio.aws.networkmanager.model.AssociateCustomerGatewayResponse.ReadOnly
  ]
  def disassociateCustomerGateway(
      request: DisassociateCustomerGatewayRequest
  ): IO[
    AwsError,
    zio.aws.networkmanager.model.DisassociateCustomerGatewayResponse.ReadOnly
  ]
  def updateGlobalNetwork(request: UpdateGlobalNetworkRequest): IO[
    AwsError,
    zio.aws.networkmanager.model.UpdateGlobalNetworkResponse.ReadOnly
  ]
  def getResourcePolicy(request: GetResourcePolicyRequest): IO[
    AwsError,
    zio.aws.networkmanager.model.GetResourcePolicyResponse.ReadOnly
  ]
  def associateConnectPeer(request: AssociateConnectPeerRequest): IO[
    AwsError,
    zio.aws.networkmanager.model.AssociateConnectPeerResponse.ReadOnly
  ]
  def associateTransitGatewayConnectPeer(
      request: AssociateTransitGatewayConnectPeerRequest
  ): IO[
    AwsError,
    zio.aws.networkmanager.model.AssociateTransitGatewayConnectPeerResponse.ReadOnly
  ]
  def disassociateConnectPeer(request: DisassociateConnectPeerRequest): IO[
    AwsError,
    zio.aws.networkmanager.model.DisassociateConnectPeerResponse.ReadOnly
  ]
  def deleteLink(
      request: DeleteLinkRequest
  ): IO[AwsError, zio.aws.networkmanager.model.DeleteLinkResponse.ReadOnly]
  def deleteAttachment(request: DeleteAttachmentRequest): IO[
    AwsError,
    zio.aws.networkmanager.model.DeleteAttachmentResponse.ReadOnly
  ]
  def getNetworkResourceRelationships(
      request: GetNetworkResourceRelationshipsRequest
  ): ZStream[Any, AwsError, zio.aws.networkmanager.model.Relationship.ReadOnly]
  def getNetworkResourceRelationshipsPaginated(
      request: GetNetworkResourceRelationshipsRequest
  ): IO[
    AwsError,
    zio.aws.networkmanager.model.GetNetworkResourceRelationshipsResponse.ReadOnly
  ]
  def createLink(
      request: CreateLinkRequest
  ): IO[AwsError, zio.aws.networkmanager.model.CreateLinkResponse.ReadOnly]
  def createVpcAttachment(request: CreateVpcAttachmentRequest): IO[
    AwsError,
    zio.aws.networkmanager.model.CreateVpcAttachmentResponse.ReadOnly
  ]
  def putCoreNetworkPolicy(request: PutCoreNetworkPolicyRequest): IO[
    AwsError,
    zio.aws.networkmanager.model.PutCoreNetworkPolicyResponse.ReadOnly
  ]
  def deleteConnectPeer(request: DeleteConnectPeerRequest): IO[
    AwsError,
    zio.aws.networkmanager.model.DeleteConnectPeerResponse.ReadOnly
  ]
  def getConnectAttachment(request: GetConnectAttachmentRequest): IO[
    AwsError,
    zio.aws.networkmanager.model.GetConnectAttachmentResponse.ReadOnly
  ]
}
object NetworkManager {
  val live: ZLayer[AwsConfig, java.lang.Throwable, NetworkManager] = customized(
    identity
  )
  def customized(
      customization: NetworkManagerAsyncClientBuilder => NetworkManagerAsyncClientBuilder
  ): ZLayer[AwsConfig, java.lang.Throwable, NetworkManager] =
    ZLayer.scoped(scoped(customization))
  def scoped(
      customization: NetworkManagerAsyncClientBuilder => NetworkManagerAsyncClientBuilder
  ): ZIO[AwsConfig with Scope, java.lang.Throwable, NetworkManager] = for (
    awsConfig <- ZIO.service[AwsConfig]; executor <- ZIO.executor;
    builder = NetworkManagerAsyncClient
      .builder()
      .asyncConfiguration(
        software.amazon.awssdk.core.client.config.ClientAsyncConfiguration
          .builder()
          .advancedOption(
            software.amazon.awssdk.core.client.config.SdkAdvancedAsyncClientOption.FUTURE_COMPLETION_EXECUTOR,
            executor.asJava
          )
          .build()
      );
    b0 <- awsConfig
      .configure[NetworkManagerAsyncClient, NetworkManagerAsyncClientBuilder](
        builder
      );
    b1 <- awsConfig.configureHttpClient[
      NetworkManagerAsyncClient,
      NetworkManagerAsyncClientBuilder
    ](
      b0,
      zio.aws.core.httpclient.ServiceHttpCapabilities(supportsHttp2 = false)
    ); client <- ZIO.attempt(customization(b1).build())
  )
    yield new NetworkManagerImpl(
      client,
      AwsCallAspect.identity,
      ZEnvironment.empty
    )
  private class NetworkManagerImpl[R](
      override val api: NetworkManagerAsyncClient,
      override val aspect: AwsCallAspect[R],
      r: ZEnvironment[R]
  ) extends NetworkManager
      with AwsServiceBase[R] {
    override val serviceName: String = "NetworkManager"
    override def withAspect[R1](
        newAspect: AwsCallAspect[R1],
        r: ZEnvironment[R1]
    ): NetworkManagerImpl[R1] = new NetworkManagerImpl(api, newAspect, r)
    def getConnections(request: GetConnectionsRequest): ZStream[
      Any,
      AwsError,
      zio.aws.networkmanager.model.Connection.ReadOnly
    ] = asyncSimplePaginatedRequest[
      software.amazon.awssdk.services.networkmanager.model.GetConnectionsRequest,
      GetConnectionsResponse,
      Connection
    ](
      "getConnections",
      api.getConnections,
      (r, token) => r.toBuilder().nextToken(token).build(),
      r => scala.Option(r.nextToken()),
      r => zio.Chunk.fromIterable(r.connections().asScala)
    )(request.buildAwsValue())
      .map(item => zio.aws.networkmanager.model.Connection.wrap(item))
      .provideEnvironment(r)
    def getConnectionsPaginated(request: GetConnectionsRequest): IO[
      AwsError,
      zio.aws.networkmanager.model.GetConnectionsResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.networkmanager.model.GetConnectionsRequest,
      GetConnectionsResponse
    ]("getConnections", api.getConnections)(request.buildAwsValue())
      .map(zio.aws.networkmanager.model.GetConnectionsResponse.wrap)
      .provideEnvironment(r)
    def listOrganizationServiceAccessStatus(
        request: ListOrganizationServiceAccessStatusRequest
    ): IO[
      AwsError,
      zio.aws.networkmanager.model.ListOrganizationServiceAccessStatusResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.networkmanager.model.ListOrganizationServiceAccessStatusRequest,
      ListOrganizationServiceAccessStatusResponse
    ](
      "listOrganizationServiceAccessStatus",
      api.listOrganizationServiceAccessStatus
    )(request.buildAwsValue())
      .map(
        zio.aws.networkmanager.model.ListOrganizationServiceAccessStatusResponse.wrap
      )
      .provideEnvironment(r)
    def listConnectPeers(request: ListConnectPeersRequest): ZStream[
      Any,
      AwsError,
      zio.aws.networkmanager.model.ConnectPeerSummary.ReadOnly
    ] = asyncSimplePaginatedRequest[
      software.amazon.awssdk.services.networkmanager.model.ListConnectPeersRequest,
      ListConnectPeersResponse,
      ConnectPeerSummary
    ](
      "listConnectPeers",
      api.listConnectPeers,
      (r, token) => r.toBuilder().nextToken(token).build(),
      r => scala.Option(r.nextToken()),
      r => zio.Chunk.fromIterable(r.connectPeers().asScala)
    )(request.buildAwsValue())
      .map(item => zio.aws.networkmanager.model.ConnectPeerSummary.wrap(item))
      .provideEnvironment(r)
    def listConnectPeersPaginated(request: ListConnectPeersRequest): IO[
      AwsError,
      zio.aws.networkmanager.model.ListConnectPeersResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.networkmanager.model.ListConnectPeersRequest,
      ListConnectPeersResponse
    ]("listConnectPeers", api.listConnectPeers)(request.buildAwsValue())
      .map(zio.aws.networkmanager.model.ListConnectPeersResponse.wrap)
      .provideEnvironment(r)
    def disassociateTransitGatewayConnectPeer(
        request: DisassociateTransitGatewayConnectPeerRequest
    ): IO[
      AwsError,
      zio.aws.networkmanager.model.DisassociateTransitGatewayConnectPeerResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.networkmanager.model.DisassociateTransitGatewayConnectPeerRequest,
      DisassociateTransitGatewayConnectPeerResponse
    ](
      "disassociateTransitGatewayConnectPeer",
      api.disassociateTransitGatewayConnectPeer
    )(request.buildAwsValue())
      .map(
        zio.aws.networkmanager.model.DisassociateTransitGatewayConnectPeerResponse.wrap
      )
      .provideEnvironment(r)
    def describeGlobalNetworks(request: DescribeGlobalNetworksRequest): ZStream[
      Any,
      AwsError,
      zio.aws.networkmanager.model.GlobalNetwork.ReadOnly
    ] = asyncSimplePaginatedRequest[
      software.amazon.awssdk.services.networkmanager.model.DescribeGlobalNetworksRequest,
      DescribeGlobalNetworksResponse,
      GlobalNetwork
    ](
      "describeGlobalNetworks",
      api.describeGlobalNetworks,
      (r, token) => r.toBuilder().nextToken(token).build(),
      r => scala.Option(r.nextToken()),
      r => zio.Chunk.fromIterable(r.globalNetworks().asScala)
    )(request.buildAwsValue())
      .map(item => zio.aws.networkmanager.model.GlobalNetwork.wrap(item))
      .provideEnvironment(r)
    def describeGlobalNetworksPaginated(
        request: DescribeGlobalNetworksRequest
    ): IO[
      AwsError,
      zio.aws.networkmanager.model.DescribeGlobalNetworksResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.networkmanager.model.DescribeGlobalNetworksRequest,
      DescribeGlobalNetworksResponse
    ]("describeGlobalNetworks", api.describeGlobalNetworks)(
      request.buildAwsValue()
    ).map(zio.aws.networkmanager.model.DescribeGlobalNetworksResponse.wrap)
      .provideEnvironment(r)
    def createCoreNetwork(request: CreateCoreNetworkRequest): IO[
      AwsError,
      zio.aws.networkmanager.model.CreateCoreNetworkResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.networkmanager.model.CreateCoreNetworkRequest,
      CreateCoreNetworkResponse
    ]("createCoreNetwork", api.createCoreNetwork)(request.buildAwsValue())
      .map(zio.aws.networkmanager.model.CreateCoreNetworkResponse.wrap)
      .provideEnvironment(r)
    def getCoreNetworkPolicy(
        request: GetCoreNetworkPolicyRequest
    ): IO[AwsError, ReadOnly] = asyncRequestResponse[
      software.amazon.awssdk.services.networkmanager.model.GetCoreNetworkPolicyRequest,
      GetCoreNetworkPolicyResponse
    ]("getCoreNetworkPolicy", api.getCoreNetworkPolicy)(request.buildAwsValue())
      .map(zio.aws.networkmanager.model.GetCoreNetworkPolicyResponse.wrap)
      .provideEnvironment(r)
    def createSite(
        request: CreateSiteRequest
    ): IO[AwsError, zio.aws.networkmanager.model.CreateSiteResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.networkmanager.model.CreateSiteRequest,
        CreateSiteResponse
      ]("createSite", api.createSite)(request.buildAwsValue())
        .map(zio.aws.networkmanager.model.CreateSiteResponse.wrap)
        .provideEnvironment(r)
    def executeCoreNetworkChangeSet(
        request: ExecuteCoreNetworkChangeSetRequest
    ): IO[
      AwsError,
      zio.aws.networkmanager.model.ExecuteCoreNetworkChangeSetResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.networkmanager.model.ExecuteCoreNetworkChangeSetRequest,
      ExecuteCoreNetworkChangeSetResponse
    ]("executeCoreNetworkChangeSet", api.executeCoreNetworkChangeSet)(
      request.buildAwsValue()
    ).map(zio.aws.networkmanager.model.ExecuteCoreNetworkChangeSetResponse.wrap)
      .provideEnvironment(r)
    def startRouteAnalysis(request: StartRouteAnalysisRequest): IO[
      AwsError,
      zio.aws.networkmanager.model.StartRouteAnalysisResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.networkmanager.model.StartRouteAnalysisRequest,
      StartRouteAnalysisResponse
    ]("startRouteAnalysis", api.startRouteAnalysis)(request.buildAwsValue())
      .map(zio.aws.networkmanager.model.StartRouteAnalysisResponse.wrap)
      .provideEnvironment(r)
    def rejectAttachment(request: RejectAttachmentRequest): IO[
      AwsError,
      zio.aws.networkmanager.model.RejectAttachmentResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.networkmanager.model.RejectAttachmentRequest,
      RejectAttachmentResponse
    ]("rejectAttachment", api.rejectAttachment)(request.buildAwsValue())
      .map(zio.aws.networkmanager.model.RejectAttachmentResponse.wrap)
      .provideEnvironment(r)
    def disassociateLink(request: DisassociateLinkRequest): IO[
      AwsError,
      zio.aws.networkmanager.model.DisassociateLinkResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.networkmanager.model.DisassociateLinkRequest,
      DisassociateLinkResponse
    ]("disassociateLink", api.disassociateLink)(request.buildAwsValue())
      .map(zio.aws.networkmanager.model.DisassociateLinkResponse.wrap)
      .provideEnvironment(r)
    def createConnection(request: CreateConnectionRequest): IO[
      AwsError,
      zio.aws.networkmanager.model.CreateConnectionResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.networkmanager.model.CreateConnectionRequest,
      CreateConnectionResponse
    ]("createConnection", api.createConnection)(request.buildAwsValue())
      .map(zio.aws.networkmanager.model.CreateConnectionResponse.wrap)
      .provideEnvironment(r)
    def createDevice(request: CreateDeviceRequest): IO[
      AwsError,
      zio.aws.networkmanager.model.CreateDeviceResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.networkmanager.model.CreateDeviceRequest,
      CreateDeviceResponse
    ]("createDevice", api.createDevice)(request.buildAwsValue())
      .map(zio.aws.networkmanager.model.CreateDeviceResponse.wrap)
      .provideEnvironment(r)
    def deleteDevice(request: DeleteDeviceRequest): IO[
      AwsError,
      zio.aws.networkmanager.model.DeleteDeviceResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.networkmanager.model.DeleteDeviceRequest,
      DeleteDeviceResponse
    ]("deleteDevice", api.deleteDevice)(request.buildAwsValue())
      .map(zio.aws.networkmanager.model.DeleteDeviceResponse.wrap)
      .provideEnvironment(r)
    def restoreCoreNetworkPolicyVersion(
        request: RestoreCoreNetworkPolicyVersionRequest
    ): IO[
      AwsError,
      zio.aws.networkmanager.model.RestoreCoreNetworkPolicyVersionResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.networkmanager.model.RestoreCoreNetworkPolicyVersionRequest,
      RestoreCoreNetworkPolicyVersionResponse
    ]("restoreCoreNetworkPolicyVersion", api.restoreCoreNetworkPolicyVersion)(
      request.buildAwsValue()
    ).map(
      zio.aws.networkmanager.model.RestoreCoreNetworkPolicyVersionResponse.wrap
    ).provideEnvironment(r)
    def deregisterTransitGateway(request: DeregisterTransitGatewayRequest): IO[
      AwsError,
      zio.aws.networkmanager.model.DeregisterTransitGatewayResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.networkmanager.model.DeregisterTransitGatewayRequest,
      DeregisterTransitGatewayResponse
    ]("deregisterTransitGateway", api.deregisterTransitGateway)(
      request.buildAwsValue()
    ).map(zio.aws.networkmanager.model.DeregisterTransitGatewayResponse.wrap)
      .provideEnvironment(r)
    def updateVpcAttachment(request: UpdateVpcAttachmentRequest): IO[
      AwsError,
      zio.aws.networkmanager.model.UpdateVpcAttachmentResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.networkmanager.model.UpdateVpcAttachmentRequest,
      UpdateVpcAttachmentResponse
    ]("updateVpcAttachment", api.updateVpcAttachment)(request.buildAwsValue())
      .map(zio.aws.networkmanager.model.UpdateVpcAttachmentResponse.wrap)
      .provideEnvironment(r)
    def deleteCoreNetworkPolicyVersion(
        request: DeleteCoreNetworkPolicyVersionRequest
    ): IO[
      AwsError,
      zio.aws.networkmanager.model.DeleteCoreNetworkPolicyVersionResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.networkmanager.model.DeleteCoreNetworkPolicyVersionRequest,
      DeleteCoreNetworkPolicyVersionResponse
    ]("deleteCoreNetworkPolicyVersion", api.deleteCoreNetworkPolicyVersion)(
      request.buildAwsValue()
    ).map(
      zio.aws.networkmanager.model.DeleteCoreNetworkPolicyVersionResponse.wrap
    ).provideEnvironment(r)
    def getConnectPeer(request: GetConnectPeerRequest): IO[
      AwsError,
      zio.aws.networkmanager.model.GetConnectPeerResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.networkmanager.model.GetConnectPeerRequest,
      GetConnectPeerResponse
    ]("getConnectPeer", api.getConnectPeer)(request.buildAwsValue())
      .map(zio.aws.networkmanager.model.GetConnectPeerResponse.wrap)
      .provideEnvironment(r)
    def updateLink(
        request: UpdateLinkRequest
    ): IO[AwsError, zio.aws.networkmanager.model.UpdateLinkResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.networkmanager.model.UpdateLinkRequest,
        UpdateLinkResponse
      ]("updateLink", api.updateLink)(request.buildAwsValue())
        .map(zio.aws.networkmanager.model.UpdateLinkResponse.wrap)
        .provideEnvironment(r)
    def updateConnection(request: UpdateConnectionRequest): IO[
      AwsError,
      zio.aws.networkmanager.model.UpdateConnectionResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.networkmanager.model.UpdateConnectionRequest,
      UpdateConnectionResponse
    ]("updateConnection", api.updateConnection)(request.buildAwsValue())
      .map(zio.aws.networkmanager.model.UpdateConnectionResponse.wrap)
      .provideEnvironment(r)
    def createConnectPeer(request: CreateConnectPeerRequest): IO[
      AwsError,
      zio.aws.networkmanager.model.CreateConnectPeerResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.networkmanager.model.CreateConnectPeerRequest,
      CreateConnectPeerResponse
    ]("createConnectPeer", api.createConnectPeer)(request.buildAwsValue())
      .map(zio.aws.networkmanager.model.CreateConnectPeerResponse.wrap)
      .provideEnvironment(r)
    def getTransitGatewayRegistrations(
        request: GetTransitGatewayRegistrationsRequest
    ): ZStream[
      Any,
      AwsError,
      zio.aws.networkmanager.model.TransitGatewayRegistration.ReadOnly
    ] = asyncSimplePaginatedRequest[
      software.amazon.awssdk.services.networkmanager.model.GetTransitGatewayRegistrationsRequest,
      GetTransitGatewayRegistrationsResponse,
      TransitGatewayRegistration
    ](
      "getTransitGatewayRegistrations",
      api.getTransitGatewayRegistrations,
      (r, token) => r.toBuilder().nextToken(token).build(),
      r => scala.Option(r.nextToken()),
      r => zio.Chunk.fromIterable(r.transitGatewayRegistrations().asScala)
    )(request.buildAwsValue())
      .map(item =>
        zio.aws.networkmanager.model.TransitGatewayRegistration.wrap(item)
      )
      .provideEnvironment(r)
    def getTransitGatewayRegistrationsPaginated(
        request: GetTransitGatewayRegistrationsRequest
    ): IO[
      AwsError,
      zio.aws.networkmanager.model.GetTransitGatewayRegistrationsResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.networkmanager.model.GetTransitGatewayRegistrationsRequest,
      GetTransitGatewayRegistrationsResponse
    ]("getTransitGatewayRegistrations", api.getTransitGatewayRegistrations)(
      request.buildAwsValue()
    ).map(
      zio.aws.networkmanager.model.GetTransitGatewayRegistrationsResponse.wrap
    ).provideEnvironment(r)
    def putResourcePolicy(request: PutResourcePolicyRequest): IO[
      AwsError,
      zio.aws.networkmanager.model.PutResourcePolicyResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.networkmanager.model.PutResourcePolicyRequest,
      PutResourcePolicyResponse
    ]("putResourcePolicy", api.putResourcePolicy)(request.buildAwsValue())
      .map(zio.aws.networkmanager.model.PutResourcePolicyResponse.wrap)
      .provideEnvironment(r)
    def deleteGlobalNetwork(request: DeleteGlobalNetworkRequest): IO[
      AwsError,
      zio.aws.networkmanager.model.DeleteGlobalNetworkResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.networkmanager.model.DeleteGlobalNetworkRequest,
      DeleteGlobalNetworkResponse
    ]("deleteGlobalNetwork", api.deleteGlobalNetwork)(request.buildAwsValue())
      .map(zio.aws.networkmanager.model.DeleteGlobalNetworkResponse.wrap)
      .provideEnvironment(r)
    def updateCoreNetwork(request: UpdateCoreNetworkRequest): IO[
      AwsError,
      zio.aws.networkmanager.model.UpdateCoreNetworkResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.networkmanager.model.UpdateCoreNetworkRequest,
      UpdateCoreNetworkResponse
    ]("updateCoreNetwork", api.updateCoreNetwork)(request.buildAwsValue())
      .map(zio.aws.networkmanager.model.UpdateCoreNetworkResponse.wrap)
      .provideEnvironment(r)
    def getTransitGatewayConnectPeerAssociations(
        request: GetTransitGatewayConnectPeerAssociationsRequest
    ): ZStream[
      Any,
      AwsError,
      zio.aws.networkmanager.model.TransitGatewayConnectPeerAssociation.ReadOnly
    ] = asyncSimplePaginatedRequest[
      software.amazon.awssdk.services.networkmanager.model.GetTransitGatewayConnectPeerAssociationsRequest,
      GetTransitGatewayConnectPeerAssociationsResponse,
      TransitGatewayConnectPeerAssociation
    ](
      "getTransitGatewayConnectPeerAssociations",
      api.getTransitGatewayConnectPeerAssociations,
      (r, token) => r.toBuilder().nextToken(token).build(),
      r => scala.Option(r.nextToken()),
      r =>
        zio.Chunk.fromIterable(
          r.transitGatewayConnectPeerAssociations().asScala
        )
    )(request.buildAwsValue())
      .map(item =>
        zio.aws.networkmanager.model.TransitGatewayConnectPeerAssociation
          .wrap(item)
      )
      .provideEnvironment(r)
    def getTransitGatewayConnectPeerAssociationsPaginated(
        request: GetTransitGatewayConnectPeerAssociationsRequest
    ): IO[
      AwsError,
      zio.aws.networkmanager.model.GetTransitGatewayConnectPeerAssociationsResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.networkmanager.model.GetTransitGatewayConnectPeerAssociationsRequest,
      GetTransitGatewayConnectPeerAssociationsResponse
    ](
      "getTransitGatewayConnectPeerAssociations",
      api.getTransitGatewayConnectPeerAssociations
    )(request.buildAwsValue())
      .map(
        zio.aws.networkmanager.model.GetTransitGatewayConnectPeerAssociationsResponse.wrap
      )
      .provideEnvironment(r)
    def getSiteToSiteVpnAttachment(
        request: GetSiteToSiteVpnAttachmentRequest
    ): IO[
      AwsError,
      zio.aws.networkmanager.model.GetSiteToSiteVpnAttachmentResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.networkmanager.model.GetSiteToSiteVpnAttachmentRequest,
      GetSiteToSiteVpnAttachmentResponse
    ]("getSiteToSiteVpnAttachment", api.getSiteToSiteVpnAttachment)(
      request.buildAwsValue()
    ).map(zio.aws.networkmanager.model.GetSiteToSiteVpnAttachmentResponse.wrap)
      .provideEnvironment(r)
    def getLinks(
        request: GetLinksRequest
    ): ZStream[Any, AwsError, zio.aws.networkmanager.model.Link.ReadOnly] =
      asyncSimplePaginatedRequest[
        software.amazon.awssdk.services.networkmanager.model.GetLinksRequest,
        GetLinksResponse,
        Link
      ](
        "getLinks",
        api.getLinks,
        (r, token) => r.toBuilder().nextToken(token).build(),
        r => scala.Option(r.nextToken()),
        r => zio.Chunk.fromIterable(r.links().asScala)
      )(request.buildAwsValue())
        .map(item => zio.aws.networkmanager.model.Link.wrap(item))
        .provideEnvironment(r)
    def getLinksPaginated(
        request: GetLinksRequest
    ): IO[AwsError, zio.aws.networkmanager.model.GetLinksResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.networkmanager.model.GetLinksRequest,
        GetLinksResponse
      ]("getLinks", api.getLinks)(request.buildAwsValue())
        .map(zio.aws.networkmanager.model.GetLinksResponse.wrap)
        .provideEnvironment(r)
    def getCustomerGatewayAssociations(
        request: GetCustomerGatewayAssociationsRequest
    ): ZStream[
      Any,
      AwsError,
      zio.aws.networkmanager.model.CustomerGatewayAssociation.ReadOnly
    ] = asyncSimplePaginatedRequest[
      software.amazon.awssdk.services.networkmanager.model.GetCustomerGatewayAssociationsRequest,
      GetCustomerGatewayAssociationsResponse,
      CustomerGatewayAssociation
    ](
      "getCustomerGatewayAssociations",
      api.getCustomerGatewayAssociations,
      (r, token) => r.toBuilder().nextToken(token).build(),
      r => scala.Option(r.nextToken()),
      r => zio.Chunk.fromIterable(r.customerGatewayAssociations().asScala)
    )(request.buildAwsValue())
      .map(item =>
        zio.aws.networkmanager.model.CustomerGatewayAssociation.wrap(item)
      )
      .provideEnvironment(r)
    def getCustomerGatewayAssociationsPaginated(
        request: GetCustomerGatewayAssociationsRequest
    ): IO[
      AwsError,
      zio.aws.networkmanager.model.GetCustomerGatewayAssociationsResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.networkmanager.model.GetCustomerGatewayAssociationsRequest,
      GetCustomerGatewayAssociationsResponse
    ]("getCustomerGatewayAssociations", api.getCustomerGatewayAssociations)(
      request.buildAwsValue()
    ).map(
      zio.aws.networkmanager.model.GetCustomerGatewayAssociationsResponse.wrap
    ).provideEnvironment(r)
    def deleteCoreNetwork(request: DeleteCoreNetworkRequest): IO[
      AwsError,
      zio.aws.networkmanager.model.DeleteCoreNetworkResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.networkmanager.model.DeleteCoreNetworkRequest,
      DeleteCoreNetworkResponse
    ]("deleteCoreNetwork", api.deleteCoreNetwork)(request.buildAwsValue())
      .map(zio.aws.networkmanager.model.DeleteCoreNetworkResponse.wrap)
      .provideEnvironment(r)
    def getNetworkTelemetry(request: GetNetworkTelemetryRequest): ZStream[
      Any,
      AwsError,
      zio.aws.networkmanager.model.NetworkTelemetry.ReadOnly
    ] = asyncSimplePaginatedRequest[
      software.amazon.awssdk.services.networkmanager.model.GetNetworkTelemetryRequest,
      GetNetworkTelemetryResponse,
      NetworkTelemetry
    ](
      "getNetworkTelemetry",
      api.getNetworkTelemetry,
      (r, token) => r.toBuilder().nextToken(token).build(),
      r => scala.Option(r.nextToken()),
      r => zio.Chunk.fromIterable(r.networkTelemetry().asScala)
    )(request.buildAwsValue())
      .map(item => zio.aws.networkmanager.model.NetworkTelemetry.wrap(item))
      .provideEnvironment(r)
    def getNetworkTelemetryPaginated(request: GetNetworkTelemetryRequest): IO[
      AwsError,
      zio.aws.networkmanager.model.GetNetworkTelemetryResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.networkmanager.model.GetNetworkTelemetryRequest,
      GetNetworkTelemetryResponse
    ]("getNetworkTelemetry", api.getNetworkTelemetry)(request.buildAwsValue())
      .map(zio.aws.networkmanager.model.GetNetworkTelemetryResponse.wrap)
      .provideEnvironment(r)
    def getCoreNetworkChangeSet(
        request: GetCoreNetworkChangeSetRequest
    ): ZStream[
      Any,
      AwsError,
      zio.aws.networkmanager.model.CoreNetworkChange.ReadOnly
    ] = asyncSimplePaginatedRequest[
      software.amazon.awssdk.services.networkmanager.model.GetCoreNetworkChangeSetRequest,
      GetCoreNetworkChangeSetResponse,
      CoreNetworkChange
    ](
      "getCoreNetworkChangeSet",
      api.getCoreNetworkChangeSet,
      (r, token) => r.toBuilder().nextToken(token).build(),
      r => scala.Option(r.nextToken()),
      r => zio.Chunk.fromIterable(r.coreNetworkChanges().asScala)
    )(request.buildAwsValue())
      .map(item => zio.aws.networkmanager.model.CoreNetworkChange.wrap(item))
      .provideEnvironment(r)
    def getCoreNetworkChangeSetPaginated(
        request: GetCoreNetworkChangeSetRequest
    ): IO[
      AwsError,
      zio.aws.networkmanager.model.GetCoreNetworkChangeSetResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.networkmanager.model.GetCoreNetworkChangeSetRequest,
      GetCoreNetworkChangeSetResponse
    ]("getCoreNetworkChangeSet", api.getCoreNetworkChangeSet)(
      request.buildAwsValue()
    ).map(zio.aws.networkmanager.model.GetCoreNetworkChangeSetResponse.wrap)
      .provideEnvironment(r)
    def getNetworkRoutes(request: GetNetworkRoutesRequest): IO[
      AwsError,
      zio.aws.networkmanager.model.GetNetworkRoutesResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.networkmanager.model.GetNetworkRoutesRequest,
      GetNetworkRoutesResponse
    ]("getNetworkRoutes", api.getNetworkRoutes)(request.buildAwsValue())
      .map(zio.aws.networkmanager.model.GetNetworkRoutesResponse.wrap)
      .provideEnvironment(r)
    def getCoreNetwork(request: GetCoreNetworkRequest): IO[
      AwsError,
      zio.aws.networkmanager.model.GetCoreNetworkResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.networkmanager.model.GetCoreNetworkRequest,
      GetCoreNetworkResponse
    ]("getCoreNetwork", api.getCoreNetwork)(request.buildAwsValue())
      .map(zio.aws.networkmanager.model.GetCoreNetworkResponse.wrap)
      .provideEnvironment(r)
    def createGlobalNetwork(request: CreateGlobalNetworkRequest): IO[
      AwsError,
      zio.aws.networkmanager.model.CreateGlobalNetworkResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.networkmanager.model.CreateGlobalNetworkRequest,
      CreateGlobalNetworkResponse
    ]("createGlobalNetwork", api.createGlobalNetwork)(request.buildAwsValue())
      .map(zio.aws.networkmanager.model.CreateGlobalNetworkResponse.wrap)
      .provideEnvironment(r)
    def deleteSite(
        request: DeleteSiteRequest
    ): IO[AwsError, zio.aws.networkmanager.model.DeleteSiteResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.networkmanager.model.DeleteSiteRequest,
        DeleteSiteResponse
      ]("deleteSite", api.deleteSite)(request.buildAwsValue())
        .map(zio.aws.networkmanager.model.DeleteSiteResponse.wrap)
        .provideEnvironment(r)
    def listCoreNetworkPolicyVersions(
        request: ListCoreNetworkPolicyVersionsRequest
    ): ZStream[
      Any,
      AwsError,
      zio.aws.networkmanager.model.CoreNetworkPolicyVersion.ReadOnly
    ] = asyncSimplePaginatedRequest[
      software.amazon.awssdk.services.networkmanager.model.ListCoreNetworkPolicyVersionsRequest,
      ListCoreNetworkPolicyVersionsResponse,
      CoreNetworkPolicyVersion
    ](
      "listCoreNetworkPolicyVersions",
      api.listCoreNetworkPolicyVersions,
      (r, token) => r.toBuilder().nextToken(token).build(),
      r => scala.Option(r.nextToken()),
      r => zio.Chunk.fromIterable(r.coreNetworkPolicyVersions().asScala)
    )(request.buildAwsValue())
      .map(item =>
        zio.aws.networkmanager.model.CoreNetworkPolicyVersion.wrap(item)
      )
      .provideEnvironment(r)
    def listCoreNetworkPolicyVersionsPaginated(
        request: ListCoreNetworkPolicyVersionsRequest
    ): IO[
      AwsError,
      zio.aws.networkmanager.model.ListCoreNetworkPolicyVersionsResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.networkmanager.model.ListCoreNetworkPolicyVersionsRequest,
      ListCoreNetworkPolicyVersionsResponse
    ]("listCoreNetworkPolicyVersions", api.listCoreNetworkPolicyVersions)(
      request.buildAwsValue()
    ).map(
      zio.aws.networkmanager.model.ListCoreNetworkPolicyVersionsResponse.wrap
    ).provideEnvironment(r)
    def getNetworkResources(request: GetNetworkResourcesRequest): ZStream[
      Any,
      AwsError,
      zio.aws.networkmanager.model.NetworkResource.ReadOnly
    ] = asyncSimplePaginatedRequest[
      software.amazon.awssdk.services.networkmanager.model.GetNetworkResourcesRequest,
      GetNetworkResourcesResponse,
      NetworkResource
    ](
      "getNetworkResources",
      api.getNetworkResources,
      (r, token) => r.toBuilder().nextToken(token).build(),
      r => scala.Option(r.nextToken()),
      r => zio.Chunk.fromIterable(r.networkResources().asScala)
    )(request.buildAwsValue())
      .map(item => zio.aws.networkmanager.model.NetworkResource.wrap(item))
      .provideEnvironment(r)
    def getNetworkResourcesPaginated(request: GetNetworkResourcesRequest): IO[
      AwsError,
      zio.aws.networkmanager.model.GetNetworkResourcesResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.networkmanager.model.GetNetworkResourcesRequest,
      GetNetworkResourcesResponse
    ]("getNetworkResources", api.getNetworkResources)(request.buildAwsValue())
      .map(zio.aws.networkmanager.model.GetNetworkResourcesResponse.wrap)
      .provideEnvironment(r)
    def registerTransitGateway(request: RegisterTransitGatewayRequest): IO[
      AwsError,
      zio.aws.networkmanager.model.RegisterTransitGatewayResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.networkmanager.model.RegisterTransitGatewayRequest,
      RegisterTransitGatewayResponse
    ]("registerTransitGateway", api.registerTransitGateway)(
      request.buildAwsValue()
    ).map(zio.aws.networkmanager.model.RegisterTransitGatewayResponse.wrap)
      .provideEnvironment(r)
    def getLinkAssociations(request: GetLinkAssociationsRequest): ZStream[
      Any,
      AwsError,
      zio.aws.networkmanager.model.LinkAssociation.ReadOnly
    ] = asyncSimplePaginatedRequest[
      software.amazon.awssdk.services.networkmanager.model.GetLinkAssociationsRequest,
      GetLinkAssociationsResponse,
      LinkAssociation
    ](
      "getLinkAssociations",
      api.getLinkAssociations,
      (r, token) => r.toBuilder().nextToken(token).build(),
      r => scala.Option(r.nextToken()),
      r => zio.Chunk.fromIterable(r.linkAssociations().asScala)
    )(request.buildAwsValue())
      .map(item => zio.aws.networkmanager.model.LinkAssociation.wrap(item))
      .provideEnvironment(r)
    def getLinkAssociationsPaginated(request: GetLinkAssociationsRequest): IO[
      AwsError,
      zio.aws.networkmanager.model.GetLinkAssociationsResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.networkmanager.model.GetLinkAssociationsRequest,
      GetLinkAssociationsResponse
    ]("getLinkAssociations", api.getLinkAssociations)(request.buildAwsValue())
      .map(zio.aws.networkmanager.model.GetLinkAssociationsResponse.wrap)
      .provideEnvironment(r)
    def startOrganizationServiceAccessUpdate(
        request: StartOrganizationServiceAccessUpdateRequest
    ): IO[
      AwsError,
      zio.aws.networkmanager.model.StartOrganizationServiceAccessUpdateResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.networkmanager.model.StartOrganizationServiceAccessUpdateRequest,
      StartOrganizationServiceAccessUpdateResponse
    ](
      "startOrganizationServiceAccessUpdate",
      api.startOrganizationServiceAccessUpdate
    )(request.buildAwsValue())
      .map(
        zio.aws.networkmanager.model.StartOrganizationServiceAccessUpdateResponse.wrap
      )
      .provideEnvironment(r)
    def untagResource(request: UntagResourceRequest): IO[
      AwsError,
      zio.aws.networkmanager.model.UntagResourceResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.networkmanager.model.UntagResourceRequest,
      UntagResourceResponse
    ]("untagResource", api.untagResource)(request.buildAwsValue())
      .map(zio.aws.networkmanager.model.UntagResourceResponse.wrap)
      .provideEnvironment(r)
    def getRouteAnalysis(request: GetRouteAnalysisRequest): IO[
      AwsError,
      zio.aws.networkmanager.model.GetRouteAnalysisResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.networkmanager.model.GetRouteAnalysisRequest,
      GetRouteAnalysisResponse
    ]("getRouteAnalysis", api.getRouteAnalysis)(request.buildAwsValue())
      .map(zio.aws.networkmanager.model.GetRouteAnalysisResponse.wrap)
      .provideEnvironment(r)
    def getSites(
        request: GetSitesRequest
    ): ZStream[Any, AwsError, zio.aws.networkmanager.model.Site.ReadOnly] =
      asyncSimplePaginatedRequest[
        software.amazon.awssdk.services.networkmanager.model.GetSitesRequest,
        GetSitesResponse,
        Site
      ](
        "getSites",
        api.getSites,
        (r, token) => r.toBuilder().nextToken(token).build(),
        r => scala.Option(r.nextToken()),
        r => zio.Chunk.fromIterable(r.sites().asScala)
      )(request.buildAwsValue())
        .map(item => zio.aws.networkmanager.model.Site.wrap(item))
        .provideEnvironment(r)
    def getSitesPaginated(
        request: GetSitesRequest
    ): IO[AwsError, zio.aws.networkmanager.model.GetSitesResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.networkmanager.model.GetSitesRequest,
        GetSitesResponse
      ]("getSites", api.getSites)(request.buildAwsValue())
        .map(zio.aws.networkmanager.model.GetSitesResponse.wrap)
        .provideEnvironment(r)
    def associateLink(request: AssociateLinkRequest): IO[
      AwsError,
      zio.aws.networkmanager.model.AssociateLinkResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.networkmanager.model.AssociateLinkRequest,
      AssociateLinkResponse
    ]("associateLink", api.associateLink)(request.buildAwsValue())
      .map(zio.aws.networkmanager.model.AssociateLinkResponse.wrap)
      .provideEnvironment(r)
    def createConnectAttachment(request: CreateConnectAttachmentRequest): IO[
      AwsError,
      zio.aws.networkmanager.model.CreateConnectAttachmentResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.networkmanager.model.CreateConnectAttachmentRequest,
      CreateConnectAttachmentResponse
    ]("createConnectAttachment", api.createConnectAttachment)(
      request.buildAwsValue()
    ).map(zio.aws.networkmanager.model.CreateConnectAttachmentResponse.wrap)
      .provideEnvironment(r)
    def deleteResourcePolicy(request: DeleteResourcePolicyRequest): IO[
      AwsError,
      zio.aws.networkmanager.model.DeleteResourcePolicyResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.networkmanager.model.DeleteResourcePolicyRequest,
      DeleteResourcePolicyResponse
    ]("deleteResourcePolicy", api.deleteResourcePolicy)(request.buildAwsValue())
      .map(zio.aws.networkmanager.model.DeleteResourcePolicyResponse.wrap)
      .provideEnvironment(r)
    def getConnectPeerAssociations(
        request: GetConnectPeerAssociationsRequest
    ): ZStream[
      Any,
      AwsError,
      zio.aws.networkmanager.model.ConnectPeerAssociation.ReadOnly
    ] = asyncSimplePaginatedRequest[
      software.amazon.awssdk.services.networkmanager.model.GetConnectPeerAssociationsRequest,
      GetConnectPeerAssociationsResponse,
      ConnectPeerAssociation
    ](
      "getConnectPeerAssociations",
      api.getConnectPeerAssociations,
      (r, token) => r.toBuilder().nextToken(token).build(),
      r => scala.Option(r.nextToken()),
      r => zio.Chunk.fromIterable(r.connectPeerAssociations().asScala)
    )(request.buildAwsValue())
      .map(item =>
        zio.aws.networkmanager.model.ConnectPeerAssociation.wrap(item)
      )
      .provideEnvironment(r)
    def getConnectPeerAssociationsPaginated(
        request: GetConnectPeerAssociationsRequest
    ): IO[
      AwsError,
      zio.aws.networkmanager.model.GetConnectPeerAssociationsResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.networkmanager.model.GetConnectPeerAssociationsRequest,
      GetConnectPeerAssociationsResponse
    ]("getConnectPeerAssociations", api.getConnectPeerAssociations)(
      request.buildAwsValue()
    ).map(zio.aws.networkmanager.model.GetConnectPeerAssociationsResponse.wrap)
      .provideEnvironment(r)
    def getVpcAttachment(request: GetVpcAttachmentRequest): IO[
      AwsError,
      zio.aws.networkmanager.model.GetVpcAttachmentResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.networkmanager.model.GetVpcAttachmentRequest,
      GetVpcAttachmentResponse
    ]("getVpcAttachment", api.getVpcAttachment)(request.buildAwsValue())
      .map(zio.aws.networkmanager.model.GetVpcAttachmentResponse.wrap)
      .provideEnvironment(r)
    def getDevices(
        request: GetDevicesRequest
    ): ZStream[Any, AwsError, zio.aws.networkmanager.model.Device.ReadOnly] =
      asyncSimplePaginatedRequest[
        software.amazon.awssdk.services.networkmanager.model.GetDevicesRequest,
        GetDevicesResponse,
        Device
      ](
        "getDevices",
        api.getDevices,
        (r, token) => r.toBuilder().nextToken(token).build(),
        r => scala.Option(r.nextToken()),
        r => zio.Chunk.fromIterable(r.devices().asScala)
      )(request.buildAwsValue())
        .map(item => zio.aws.networkmanager.model.Device.wrap(item))
        .provideEnvironment(r)
    def getDevicesPaginated(
        request: GetDevicesRequest
    ): IO[AwsError, zio.aws.networkmanager.model.GetDevicesResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.networkmanager.model.GetDevicesRequest,
        GetDevicesResponse
      ]("getDevices", api.getDevices)(request.buildAwsValue())
        .map(zio.aws.networkmanager.model.GetDevicesResponse.wrap)
        .provideEnvironment(r)
    def getNetworkResourceCounts(
        request: GetNetworkResourceCountsRequest
    ): ZStream[
      Any,
      AwsError,
      zio.aws.networkmanager.model.NetworkResourceCount.ReadOnly
    ] = asyncSimplePaginatedRequest[
      software.amazon.awssdk.services.networkmanager.model.GetNetworkResourceCountsRequest,
      GetNetworkResourceCountsResponse,
      NetworkResourceCount
    ](
      "getNetworkResourceCounts",
      api.getNetworkResourceCounts,
      (r, token) => r.toBuilder().nextToken(token).build(),
      r => scala.Option(r.nextToken()),
      r => zio.Chunk.fromIterable(r.networkResourceCounts().asScala)
    )(request.buildAwsValue())
      .map(item => zio.aws.networkmanager.model.NetworkResourceCount.wrap(item))
      .provideEnvironment(r)
    def getNetworkResourceCountsPaginated(
        request: GetNetworkResourceCountsRequest
    ): IO[
      AwsError,
      zio.aws.networkmanager.model.GetNetworkResourceCountsResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.networkmanager.model.GetNetworkResourceCountsRequest,
      GetNetworkResourceCountsResponse
    ]("getNetworkResourceCounts", api.getNetworkResourceCounts)(
      request.buildAwsValue()
    ).map(zio.aws.networkmanager.model.GetNetworkResourceCountsResponse.wrap)
      .provideEnvironment(r)
    def createSiteToSiteVpnAttachment(
        request: CreateSiteToSiteVpnAttachmentRequest
    ): IO[
      AwsError,
      zio.aws.networkmanager.model.CreateSiteToSiteVpnAttachmentResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.networkmanager.model.CreateSiteToSiteVpnAttachmentRequest,
      CreateSiteToSiteVpnAttachmentResponse
    ]("createSiteToSiteVpnAttachment", api.createSiteToSiteVpnAttachment)(
      request.buildAwsValue()
    ).map(
      zio.aws.networkmanager.model.CreateSiteToSiteVpnAttachmentResponse.wrap
    ).provideEnvironment(r)
    def updateDevice(request: UpdateDeviceRequest): IO[
      AwsError,
      zio.aws.networkmanager.model.UpdateDeviceResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.networkmanager.model.UpdateDeviceRequest,
      UpdateDeviceResponse
    ]("updateDevice", api.updateDevice)(request.buildAwsValue())
      .map(zio.aws.networkmanager.model.UpdateDeviceResponse.wrap)
      .provideEnvironment(r)
    def listTagsForResource(request: ListTagsForResourceRequest): IO[
      AwsError,
      zio.aws.networkmanager.model.ListTagsForResourceResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.networkmanager.model.ListTagsForResourceRequest,
      ListTagsForResourceResponse
    ]("listTagsForResource", api.listTagsForResource)(request.buildAwsValue())
      .map(zio.aws.networkmanager.model.ListTagsForResourceResponse.wrap)
      .provideEnvironment(r)
    def listCoreNetworks(request: ListCoreNetworksRequest): ZStream[
      Any,
      AwsError,
      zio.aws.networkmanager.model.CoreNetworkSummary.ReadOnly
    ] = asyncSimplePaginatedRequest[
      software.amazon.awssdk.services.networkmanager.model.ListCoreNetworksRequest,
      ListCoreNetworksResponse,
      CoreNetworkSummary
    ](
      "listCoreNetworks",
      api.listCoreNetworks,
      (r, token) => r.toBuilder().nextToken(token).build(),
      r => scala.Option(r.nextToken()),
      r => zio.Chunk.fromIterable(r.coreNetworks().asScala)
    )(request.buildAwsValue())
      .map(item => zio.aws.networkmanager.model.CoreNetworkSummary.wrap(item))
      .provideEnvironment(r)
    def listCoreNetworksPaginated(request: ListCoreNetworksRequest): IO[
      AwsError,
      zio.aws.networkmanager.model.ListCoreNetworksResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.networkmanager.model.ListCoreNetworksRequest,
      ListCoreNetworksResponse
    ]("listCoreNetworks", api.listCoreNetworks)(request.buildAwsValue())
      .map(zio.aws.networkmanager.model.ListCoreNetworksResponse.wrap)
      .provideEnvironment(r)
    def deleteConnection(request: DeleteConnectionRequest): IO[
      AwsError,
      zio.aws.networkmanager.model.DeleteConnectionResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.networkmanager.model.DeleteConnectionRequest,
      DeleteConnectionResponse
    ]("deleteConnection", api.deleteConnection)(request.buildAwsValue())
      .map(zio.aws.networkmanager.model.DeleteConnectionResponse.wrap)
      .provideEnvironment(r)
    def tagResource(
        request: TagResourceRequest
    ): IO[AwsError, zio.aws.networkmanager.model.TagResourceResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.networkmanager.model.TagResourceRequest,
        TagResourceResponse
      ]("tagResource", api.tagResource)(request.buildAwsValue())
        .map(zio.aws.networkmanager.model.TagResourceResponse.wrap)
        .provideEnvironment(r)
    def listAttachments(request: ListAttachmentsRequest): ZStream[
      Any,
      AwsError,
      zio.aws.networkmanager.model.Attachment.ReadOnly
    ] = asyncSimplePaginatedRequest[
      software.amazon.awssdk.services.networkmanager.model.ListAttachmentsRequest,
      ListAttachmentsResponse,
      Attachment
    ](
      "listAttachments",
      api.listAttachments,
      (r, token) => r.toBuilder().nextToken(token).build(),
      r => scala.Option(r.nextToken()),
      r => zio.Chunk.fromIterable(r.attachments().asScala)
    )(request.buildAwsValue())
      .map(item => zio.aws.networkmanager.model.Attachment.wrap(item))
      .provideEnvironment(r)
    def listAttachmentsPaginated(request: ListAttachmentsRequest): IO[
      AwsError,
      zio.aws.networkmanager.model.ListAttachmentsResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.networkmanager.model.ListAttachmentsRequest,
      ListAttachmentsResponse
    ]("listAttachments", api.listAttachments)(request.buildAwsValue())
      .map(zio.aws.networkmanager.model.ListAttachmentsResponse.wrap)
      .provideEnvironment(r)
    def acceptAttachment(request: AcceptAttachmentRequest): IO[
      AwsError,
      zio.aws.networkmanager.model.AcceptAttachmentResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.networkmanager.model.AcceptAttachmentRequest,
      AcceptAttachmentResponse
    ]("acceptAttachment", api.acceptAttachment)(request.buildAwsValue())
      .map(zio.aws.networkmanager.model.AcceptAttachmentResponse.wrap)
      .provideEnvironment(r)
    def updateSite(
        request: UpdateSiteRequest
    ): IO[AwsError, zio.aws.networkmanager.model.UpdateSiteResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.networkmanager.model.UpdateSiteRequest,
        UpdateSiteResponse
      ]("updateSite", api.updateSite)(request.buildAwsValue())
        .map(zio.aws.networkmanager.model.UpdateSiteResponse.wrap)
        .provideEnvironment(r)
    def updateNetworkResourceMetadata(
        request: UpdateNetworkResourceMetadataRequest
    ): IO[
      AwsError,
      zio.aws.networkmanager.model.UpdateNetworkResourceMetadataResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.networkmanager.model.UpdateNetworkResourceMetadataRequest,
      UpdateNetworkResourceMetadataResponse
    ]("updateNetworkResourceMetadata", api.updateNetworkResourceMetadata)(
      request.buildAwsValue()
    ).map(
      zio.aws.networkmanager.model.UpdateNetworkResourceMetadataResponse.wrap
    ).provideEnvironment(r)
    def associateCustomerGateway(request: AssociateCustomerGatewayRequest): IO[
      AwsError,
      zio.aws.networkmanager.model.AssociateCustomerGatewayResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.networkmanager.model.AssociateCustomerGatewayRequest,
      AssociateCustomerGatewayResponse
    ]("associateCustomerGateway", api.associateCustomerGateway)(
      request.buildAwsValue()
    ).map(zio.aws.networkmanager.model.AssociateCustomerGatewayResponse.wrap)
      .provideEnvironment(r)
    def disassociateCustomerGateway(
        request: DisassociateCustomerGatewayRequest
    ): IO[
      AwsError,
      zio.aws.networkmanager.model.DisassociateCustomerGatewayResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.networkmanager.model.DisassociateCustomerGatewayRequest,
      DisassociateCustomerGatewayResponse
    ]("disassociateCustomerGateway", api.disassociateCustomerGateway)(
      request.buildAwsValue()
    ).map(zio.aws.networkmanager.model.DisassociateCustomerGatewayResponse.wrap)
      .provideEnvironment(r)
    def updateGlobalNetwork(request: UpdateGlobalNetworkRequest): IO[
      AwsError,
      zio.aws.networkmanager.model.UpdateGlobalNetworkResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.networkmanager.model.UpdateGlobalNetworkRequest,
      UpdateGlobalNetworkResponse
    ]("updateGlobalNetwork", api.updateGlobalNetwork)(request.buildAwsValue())
      .map(zio.aws.networkmanager.model.UpdateGlobalNetworkResponse.wrap)
      .provideEnvironment(r)
    def getResourcePolicy(request: GetResourcePolicyRequest): IO[
      AwsError,
      zio.aws.networkmanager.model.GetResourcePolicyResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.networkmanager.model.GetResourcePolicyRequest,
      GetResourcePolicyResponse
    ]("getResourcePolicy", api.getResourcePolicy)(request.buildAwsValue())
      .map(zio.aws.networkmanager.model.GetResourcePolicyResponse.wrap)
      .provideEnvironment(r)
    def associateConnectPeer(request: AssociateConnectPeerRequest): IO[
      AwsError,
      zio.aws.networkmanager.model.AssociateConnectPeerResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.networkmanager.model.AssociateConnectPeerRequest,
      AssociateConnectPeerResponse
    ]("associateConnectPeer", api.associateConnectPeer)(request.buildAwsValue())
      .map(zio.aws.networkmanager.model.AssociateConnectPeerResponse.wrap)
      .provideEnvironment(r)
    def associateTransitGatewayConnectPeer(
        request: AssociateTransitGatewayConnectPeerRequest
    ): IO[
      AwsError,
      zio.aws.networkmanager.model.AssociateTransitGatewayConnectPeerResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.networkmanager.model.AssociateTransitGatewayConnectPeerRequest,
      AssociateTransitGatewayConnectPeerResponse
    ](
      "associateTransitGatewayConnectPeer",
      api.associateTransitGatewayConnectPeer
    )(request.buildAwsValue())
      .map(
        zio.aws.networkmanager.model.AssociateTransitGatewayConnectPeerResponse.wrap
      )
      .provideEnvironment(r)
    def disassociateConnectPeer(request: DisassociateConnectPeerRequest): IO[
      AwsError,
      zio.aws.networkmanager.model.DisassociateConnectPeerResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.networkmanager.model.DisassociateConnectPeerRequest,
      DisassociateConnectPeerResponse
    ]("disassociateConnectPeer", api.disassociateConnectPeer)(
      request.buildAwsValue()
    ).map(zio.aws.networkmanager.model.DisassociateConnectPeerResponse.wrap)
      .provideEnvironment(r)
    def deleteLink(
        request: DeleteLinkRequest
    ): IO[AwsError, zio.aws.networkmanager.model.DeleteLinkResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.networkmanager.model.DeleteLinkRequest,
        DeleteLinkResponse
      ]("deleteLink", api.deleteLink)(request.buildAwsValue())
        .map(zio.aws.networkmanager.model.DeleteLinkResponse.wrap)
        .provideEnvironment(r)
    def deleteAttachment(request: DeleteAttachmentRequest): IO[
      AwsError,
      zio.aws.networkmanager.model.DeleteAttachmentResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.networkmanager.model.DeleteAttachmentRequest,
      DeleteAttachmentResponse
    ]("deleteAttachment", api.deleteAttachment)(request.buildAwsValue())
      .map(zio.aws.networkmanager.model.DeleteAttachmentResponse.wrap)
      .provideEnvironment(r)
    def getNetworkResourceRelationships(
        request: GetNetworkResourceRelationshipsRequest
    ): ZStream[
      Any,
      AwsError,
      zio.aws.networkmanager.model.Relationship.ReadOnly
    ] = asyncSimplePaginatedRequest[
      software.amazon.awssdk.services.networkmanager.model.GetNetworkResourceRelationshipsRequest,
      GetNetworkResourceRelationshipsResponse,
      Relationship
    ](
      "getNetworkResourceRelationships",
      api.getNetworkResourceRelationships,
      (r, token) => r.toBuilder().nextToken(token).build(),
      r => scala.Option(r.nextToken()),
      r => zio.Chunk.fromIterable(r.relationships().asScala)
    )(request.buildAwsValue())
      .map(item => zio.aws.networkmanager.model.Relationship.wrap(item))
      .provideEnvironment(r)
    def getNetworkResourceRelationshipsPaginated(
        request: GetNetworkResourceRelationshipsRequest
    ): IO[
      AwsError,
      zio.aws.networkmanager.model.GetNetworkResourceRelationshipsResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.networkmanager.model.GetNetworkResourceRelationshipsRequest,
      GetNetworkResourceRelationshipsResponse
    ]("getNetworkResourceRelationships", api.getNetworkResourceRelationships)(
      request.buildAwsValue()
    ).map(
      zio.aws.networkmanager.model.GetNetworkResourceRelationshipsResponse.wrap
    ).provideEnvironment(r)
    def createLink(
        request: CreateLinkRequest
    ): IO[AwsError, zio.aws.networkmanager.model.CreateLinkResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.networkmanager.model.CreateLinkRequest,
        CreateLinkResponse
      ]("createLink", api.createLink)(request.buildAwsValue())
        .map(zio.aws.networkmanager.model.CreateLinkResponse.wrap)
        .provideEnvironment(r)
    def createVpcAttachment(request: CreateVpcAttachmentRequest): IO[
      AwsError,
      zio.aws.networkmanager.model.CreateVpcAttachmentResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.networkmanager.model.CreateVpcAttachmentRequest,
      CreateVpcAttachmentResponse
    ]("createVpcAttachment", api.createVpcAttachment)(request.buildAwsValue())
      .map(zio.aws.networkmanager.model.CreateVpcAttachmentResponse.wrap)
      .provideEnvironment(r)
    def putCoreNetworkPolicy(request: PutCoreNetworkPolicyRequest): IO[
      AwsError,
      zio.aws.networkmanager.model.PutCoreNetworkPolicyResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.networkmanager.model.PutCoreNetworkPolicyRequest,
      PutCoreNetworkPolicyResponse
    ]("putCoreNetworkPolicy", api.putCoreNetworkPolicy)(request.buildAwsValue())
      .map(zio.aws.networkmanager.model.PutCoreNetworkPolicyResponse.wrap)
      .provideEnvironment(r)
    def deleteConnectPeer(request: DeleteConnectPeerRequest): IO[
      AwsError,
      zio.aws.networkmanager.model.DeleteConnectPeerResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.networkmanager.model.DeleteConnectPeerRequest,
      DeleteConnectPeerResponse
    ]("deleteConnectPeer", api.deleteConnectPeer)(request.buildAwsValue())
      .map(zio.aws.networkmanager.model.DeleteConnectPeerResponse.wrap)
      .provideEnvironment(r)
    def getConnectAttachment(request: GetConnectAttachmentRequest): IO[
      AwsError,
      zio.aws.networkmanager.model.GetConnectAttachmentResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.networkmanager.model.GetConnectAttachmentRequest,
      GetConnectAttachmentResponse
    ]("getConnectAttachment", api.getConnectAttachment)(request.buildAwsValue())
      .map(zio.aws.networkmanager.model.GetConnectAttachmentResponse.wrap)
      .provideEnvironment(r)
  }
  def getConnections(request: GetConnectionsRequest): ZStream[
    zio.aws.networkmanager.NetworkManager,
    AwsError,
    zio.aws.networkmanager.model.Connection.ReadOnly
  ] = ZStream.serviceWithStream(_.getConnections(request))
  def getConnectionsPaginated(request: GetConnectionsRequest): ZIO[
    zio.aws.networkmanager.NetworkManager,
    AwsError,
    zio.aws.networkmanager.model.GetConnectionsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getConnectionsPaginated(request))
  def listOrganizationServiceAccessStatus(
      request: ListOrganizationServiceAccessStatusRequest
  ): ZIO[
    zio.aws.networkmanager.NetworkManager,
    AwsError,
    zio.aws.networkmanager.model.ListOrganizationServiceAccessStatusResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listOrganizationServiceAccessStatus(request))
  def listConnectPeers(request: ListConnectPeersRequest): ZStream[
    zio.aws.networkmanager.NetworkManager,
    AwsError,
    zio.aws.networkmanager.model.ConnectPeerSummary.ReadOnly
  ] = ZStream.serviceWithStream(_.listConnectPeers(request))
  def listConnectPeersPaginated(request: ListConnectPeersRequest): ZIO[
    zio.aws.networkmanager.NetworkManager,
    AwsError,
    zio.aws.networkmanager.model.ListConnectPeersResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listConnectPeersPaginated(request))
  def disassociateTransitGatewayConnectPeer(
      request: DisassociateTransitGatewayConnectPeerRequest
  ): ZIO[
    zio.aws.networkmanager.NetworkManager,
    AwsError,
    zio.aws.networkmanager.model.DisassociateTransitGatewayConnectPeerResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.disassociateTransitGatewayConnectPeer(request))
  def describeGlobalNetworks(request: DescribeGlobalNetworksRequest): ZStream[
    zio.aws.networkmanager.NetworkManager,
    AwsError,
    zio.aws.networkmanager.model.GlobalNetwork.ReadOnly
  ] = ZStream.serviceWithStream(_.describeGlobalNetworks(request))
  def describeGlobalNetworksPaginated(
      request: DescribeGlobalNetworksRequest
  ): ZIO[
    zio.aws.networkmanager.NetworkManager,
    AwsError,
    zio.aws.networkmanager.model.DescribeGlobalNetworksResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeGlobalNetworksPaginated(request))
  def createCoreNetwork(request: CreateCoreNetworkRequest): ZIO[
    zio.aws.networkmanager.NetworkManager,
    AwsError,
    zio.aws.networkmanager.model.CreateCoreNetworkResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createCoreNetwork(request))
  def getCoreNetworkPolicy(
      request: GetCoreNetworkPolicyRequest
  ): ZIO[zio.aws.networkmanager.NetworkManager, AwsError, ReadOnly] =
    ZIO.serviceWithZIO(_.getCoreNetworkPolicy(request))
  def createSite(request: CreateSiteRequest): ZIO[
    zio.aws.networkmanager.NetworkManager,
    AwsError,
    zio.aws.networkmanager.model.CreateSiteResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createSite(request))
  def executeCoreNetworkChangeSet(
      request: ExecuteCoreNetworkChangeSetRequest
  ): ZIO[
    zio.aws.networkmanager.NetworkManager,
    AwsError,
    zio.aws.networkmanager.model.ExecuteCoreNetworkChangeSetResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.executeCoreNetworkChangeSet(request))
  def startRouteAnalysis(request: StartRouteAnalysisRequest): ZIO[
    zio.aws.networkmanager.NetworkManager,
    AwsError,
    zio.aws.networkmanager.model.StartRouteAnalysisResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.startRouteAnalysis(request))
  def rejectAttachment(request: RejectAttachmentRequest): ZIO[
    zio.aws.networkmanager.NetworkManager,
    AwsError,
    zio.aws.networkmanager.model.RejectAttachmentResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.rejectAttachment(request))
  def disassociateLink(request: DisassociateLinkRequest): ZIO[
    zio.aws.networkmanager.NetworkManager,
    AwsError,
    zio.aws.networkmanager.model.DisassociateLinkResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.disassociateLink(request))
  def createConnection(request: CreateConnectionRequest): ZIO[
    zio.aws.networkmanager.NetworkManager,
    AwsError,
    zio.aws.networkmanager.model.CreateConnectionResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createConnection(request))
  def createDevice(request: CreateDeviceRequest): ZIO[
    zio.aws.networkmanager.NetworkManager,
    AwsError,
    zio.aws.networkmanager.model.CreateDeviceResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createDevice(request))
  def deleteDevice(request: DeleteDeviceRequest): ZIO[
    zio.aws.networkmanager.NetworkManager,
    AwsError,
    zio.aws.networkmanager.model.DeleteDeviceResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.deleteDevice(request))
  def restoreCoreNetworkPolicyVersion(
      request: RestoreCoreNetworkPolicyVersionRequest
  ): ZIO[
    zio.aws.networkmanager.NetworkManager,
    AwsError,
    zio.aws.networkmanager.model.RestoreCoreNetworkPolicyVersionResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.restoreCoreNetworkPolicyVersion(request))
  def deregisterTransitGateway(request: DeregisterTransitGatewayRequest): ZIO[
    zio.aws.networkmanager.NetworkManager,
    AwsError,
    zio.aws.networkmanager.model.DeregisterTransitGatewayResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.deregisterTransitGateway(request))
  def updateVpcAttachment(request: UpdateVpcAttachmentRequest): ZIO[
    zio.aws.networkmanager.NetworkManager,
    AwsError,
    zio.aws.networkmanager.model.UpdateVpcAttachmentResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.updateVpcAttachment(request))
  def deleteCoreNetworkPolicyVersion(
      request: DeleteCoreNetworkPolicyVersionRequest
  ): ZIO[
    zio.aws.networkmanager.NetworkManager,
    AwsError,
    zio.aws.networkmanager.model.DeleteCoreNetworkPolicyVersionResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.deleteCoreNetworkPolicyVersion(request))
  def getConnectPeer(request: GetConnectPeerRequest): ZIO[
    zio.aws.networkmanager.NetworkManager,
    AwsError,
    zio.aws.networkmanager.model.GetConnectPeerResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getConnectPeer(request))
  def updateLink(request: UpdateLinkRequest): ZIO[
    zio.aws.networkmanager.NetworkManager,
    AwsError,
    zio.aws.networkmanager.model.UpdateLinkResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.updateLink(request))
  def updateConnection(request: UpdateConnectionRequest): ZIO[
    zio.aws.networkmanager.NetworkManager,
    AwsError,
    zio.aws.networkmanager.model.UpdateConnectionResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.updateConnection(request))
  def createConnectPeer(request: CreateConnectPeerRequest): ZIO[
    zio.aws.networkmanager.NetworkManager,
    AwsError,
    zio.aws.networkmanager.model.CreateConnectPeerResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createConnectPeer(request))
  def getTransitGatewayRegistrations(
      request: GetTransitGatewayRegistrationsRequest
  ): ZStream[
    zio.aws.networkmanager.NetworkManager,
    AwsError,
    zio.aws.networkmanager.model.TransitGatewayRegistration.ReadOnly
  ] = ZStream.serviceWithStream(_.getTransitGatewayRegistrations(request))
  def getTransitGatewayRegistrationsPaginated(
      request: GetTransitGatewayRegistrationsRequest
  ): ZIO[
    zio.aws.networkmanager.NetworkManager,
    AwsError,
    zio.aws.networkmanager.model.GetTransitGatewayRegistrationsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getTransitGatewayRegistrationsPaginated(request))
  def putResourcePolicy(request: PutResourcePolicyRequest): ZIO[
    zio.aws.networkmanager.NetworkManager,
    AwsError,
    zio.aws.networkmanager.model.PutResourcePolicyResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.putResourcePolicy(request))
  def deleteGlobalNetwork(request: DeleteGlobalNetworkRequest): ZIO[
    zio.aws.networkmanager.NetworkManager,
    AwsError,
    zio.aws.networkmanager.model.DeleteGlobalNetworkResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.deleteGlobalNetwork(request))
  def updateCoreNetwork(request: UpdateCoreNetworkRequest): ZIO[
    zio.aws.networkmanager.NetworkManager,
    AwsError,
    zio.aws.networkmanager.model.UpdateCoreNetworkResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.updateCoreNetwork(request))
  def getTransitGatewayConnectPeerAssociations(
      request: GetTransitGatewayConnectPeerAssociationsRequest
  ): ZStream[
    zio.aws.networkmanager.NetworkManager,
    AwsError,
    zio.aws.networkmanager.model.TransitGatewayConnectPeerAssociation.ReadOnly
  ] = ZStream.serviceWithStream(
    _.getTransitGatewayConnectPeerAssociations(request)
  )
  def getTransitGatewayConnectPeerAssociationsPaginated(
      request: GetTransitGatewayConnectPeerAssociationsRequest
  ): ZIO[
    zio.aws.networkmanager.NetworkManager,
    AwsError,
    zio.aws.networkmanager.model.GetTransitGatewayConnectPeerAssociationsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(
    _.getTransitGatewayConnectPeerAssociationsPaginated(request)
  )
  def getSiteToSiteVpnAttachment(
      request: GetSiteToSiteVpnAttachmentRequest
  ): ZIO[
    zio.aws.networkmanager.NetworkManager,
    AwsError,
    zio.aws.networkmanager.model.GetSiteToSiteVpnAttachmentResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getSiteToSiteVpnAttachment(request))
  def getLinks(request: GetLinksRequest): ZStream[
    zio.aws.networkmanager.NetworkManager,
    AwsError,
    zio.aws.networkmanager.model.Link.ReadOnly
  ] = ZStream.serviceWithStream(_.getLinks(request))
  def getLinksPaginated(request: GetLinksRequest): ZIO[
    zio.aws.networkmanager.NetworkManager,
    AwsError,
    zio.aws.networkmanager.model.GetLinksResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getLinksPaginated(request))
  def getCustomerGatewayAssociations(
      request: GetCustomerGatewayAssociationsRequest
  ): ZStream[
    zio.aws.networkmanager.NetworkManager,
    AwsError,
    zio.aws.networkmanager.model.CustomerGatewayAssociation.ReadOnly
  ] = ZStream.serviceWithStream(_.getCustomerGatewayAssociations(request))
  def getCustomerGatewayAssociationsPaginated(
      request: GetCustomerGatewayAssociationsRequest
  ): ZIO[
    zio.aws.networkmanager.NetworkManager,
    AwsError,
    zio.aws.networkmanager.model.GetCustomerGatewayAssociationsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getCustomerGatewayAssociationsPaginated(request))
  def deleteCoreNetwork(request: DeleteCoreNetworkRequest): ZIO[
    zio.aws.networkmanager.NetworkManager,
    AwsError,
    zio.aws.networkmanager.model.DeleteCoreNetworkResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.deleteCoreNetwork(request))
  def getNetworkTelemetry(request: GetNetworkTelemetryRequest): ZStream[
    zio.aws.networkmanager.NetworkManager,
    AwsError,
    zio.aws.networkmanager.model.NetworkTelemetry.ReadOnly
  ] = ZStream.serviceWithStream(_.getNetworkTelemetry(request))
  def getNetworkTelemetryPaginated(request: GetNetworkTelemetryRequest): ZIO[
    zio.aws.networkmanager.NetworkManager,
    AwsError,
    zio.aws.networkmanager.model.GetNetworkTelemetryResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getNetworkTelemetryPaginated(request))
  def getCoreNetworkChangeSet(request: GetCoreNetworkChangeSetRequest): ZStream[
    zio.aws.networkmanager.NetworkManager,
    AwsError,
    zio.aws.networkmanager.model.CoreNetworkChange.ReadOnly
  ] = ZStream.serviceWithStream(_.getCoreNetworkChangeSet(request))
  def getCoreNetworkChangeSetPaginated(
      request: GetCoreNetworkChangeSetRequest
  ): ZIO[
    zio.aws.networkmanager.NetworkManager,
    AwsError,
    zio.aws.networkmanager.model.GetCoreNetworkChangeSetResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getCoreNetworkChangeSetPaginated(request))
  def getNetworkRoutes(request: GetNetworkRoutesRequest): ZIO[
    zio.aws.networkmanager.NetworkManager,
    AwsError,
    zio.aws.networkmanager.model.GetNetworkRoutesResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getNetworkRoutes(request))
  def getCoreNetwork(request: GetCoreNetworkRequest): ZIO[
    zio.aws.networkmanager.NetworkManager,
    AwsError,
    zio.aws.networkmanager.model.GetCoreNetworkResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getCoreNetwork(request))
  def createGlobalNetwork(request: CreateGlobalNetworkRequest): ZIO[
    zio.aws.networkmanager.NetworkManager,
    AwsError,
    zio.aws.networkmanager.model.CreateGlobalNetworkResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createGlobalNetwork(request))
  def deleteSite(request: DeleteSiteRequest): ZIO[
    zio.aws.networkmanager.NetworkManager,
    AwsError,
    zio.aws.networkmanager.model.DeleteSiteResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.deleteSite(request))
  def listCoreNetworkPolicyVersions(
      request: ListCoreNetworkPolicyVersionsRequest
  ): ZStream[
    zio.aws.networkmanager.NetworkManager,
    AwsError,
    zio.aws.networkmanager.model.CoreNetworkPolicyVersion.ReadOnly
  ] = ZStream.serviceWithStream(_.listCoreNetworkPolicyVersions(request))
  def listCoreNetworkPolicyVersionsPaginated(
      request: ListCoreNetworkPolicyVersionsRequest
  ): ZIO[
    zio.aws.networkmanager.NetworkManager,
    AwsError,
    zio.aws.networkmanager.model.ListCoreNetworkPolicyVersionsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listCoreNetworkPolicyVersionsPaginated(request))
  def getNetworkResources(request: GetNetworkResourcesRequest): ZStream[
    zio.aws.networkmanager.NetworkManager,
    AwsError,
    zio.aws.networkmanager.model.NetworkResource.ReadOnly
  ] = ZStream.serviceWithStream(_.getNetworkResources(request))
  def getNetworkResourcesPaginated(request: GetNetworkResourcesRequest): ZIO[
    zio.aws.networkmanager.NetworkManager,
    AwsError,
    zio.aws.networkmanager.model.GetNetworkResourcesResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getNetworkResourcesPaginated(request))
  def registerTransitGateway(request: RegisterTransitGatewayRequest): ZIO[
    zio.aws.networkmanager.NetworkManager,
    AwsError,
    zio.aws.networkmanager.model.RegisterTransitGatewayResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.registerTransitGateway(request))
  def getLinkAssociations(request: GetLinkAssociationsRequest): ZStream[
    zio.aws.networkmanager.NetworkManager,
    AwsError,
    zio.aws.networkmanager.model.LinkAssociation.ReadOnly
  ] = ZStream.serviceWithStream(_.getLinkAssociations(request))
  def getLinkAssociationsPaginated(request: GetLinkAssociationsRequest): ZIO[
    zio.aws.networkmanager.NetworkManager,
    AwsError,
    zio.aws.networkmanager.model.GetLinkAssociationsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getLinkAssociationsPaginated(request))
  def startOrganizationServiceAccessUpdate(
      request: StartOrganizationServiceAccessUpdateRequest
  ): ZIO[
    zio.aws.networkmanager.NetworkManager,
    AwsError,
    zio.aws.networkmanager.model.StartOrganizationServiceAccessUpdateResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.startOrganizationServiceAccessUpdate(request))
  def untagResource(request: UntagResourceRequest): ZIO[
    zio.aws.networkmanager.NetworkManager,
    AwsError,
    zio.aws.networkmanager.model.UntagResourceResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.untagResource(request))
  def getRouteAnalysis(request: GetRouteAnalysisRequest): ZIO[
    zio.aws.networkmanager.NetworkManager,
    AwsError,
    zio.aws.networkmanager.model.GetRouteAnalysisResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getRouteAnalysis(request))
  def getSites(request: GetSitesRequest): ZStream[
    zio.aws.networkmanager.NetworkManager,
    AwsError,
    zio.aws.networkmanager.model.Site.ReadOnly
  ] = ZStream.serviceWithStream(_.getSites(request))
  def getSitesPaginated(request: GetSitesRequest): ZIO[
    zio.aws.networkmanager.NetworkManager,
    AwsError,
    zio.aws.networkmanager.model.GetSitesResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getSitesPaginated(request))
  def associateLink(request: AssociateLinkRequest): ZIO[
    zio.aws.networkmanager.NetworkManager,
    AwsError,
    zio.aws.networkmanager.model.AssociateLinkResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.associateLink(request))
  def createConnectAttachment(request: CreateConnectAttachmentRequest): ZIO[
    zio.aws.networkmanager.NetworkManager,
    AwsError,
    zio.aws.networkmanager.model.CreateConnectAttachmentResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createConnectAttachment(request))
  def deleteResourcePolicy(request: DeleteResourcePolicyRequest): ZIO[
    zio.aws.networkmanager.NetworkManager,
    AwsError,
    zio.aws.networkmanager.model.DeleteResourcePolicyResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.deleteResourcePolicy(request))
  def getConnectPeerAssociations(
      request: GetConnectPeerAssociationsRequest
  ): ZStream[
    zio.aws.networkmanager.NetworkManager,
    AwsError,
    zio.aws.networkmanager.model.ConnectPeerAssociation.ReadOnly
  ] = ZStream.serviceWithStream(_.getConnectPeerAssociations(request))
  def getConnectPeerAssociationsPaginated(
      request: GetConnectPeerAssociationsRequest
  ): ZIO[
    zio.aws.networkmanager.NetworkManager,
    AwsError,
    zio.aws.networkmanager.model.GetConnectPeerAssociationsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getConnectPeerAssociationsPaginated(request))
  def getVpcAttachment(request: GetVpcAttachmentRequest): ZIO[
    zio.aws.networkmanager.NetworkManager,
    AwsError,
    zio.aws.networkmanager.model.GetVpcAttachmentResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getVpcAttachment(request))
  def getDevices(request: GetDevicesRequest): ZStream[
    zio.aws.networkmanager.NetworkManager,
    AwsError,
    zio.aws.networkmanager.model.Device.ReadOnly
  ] = ZStream.serviceWithStream(_.getDevices(request))
  def getDevicesPaginated(request: GetDevicesRequest): ZIO[
    zio.aws.networkmanager.NetworkManager,
    AwsError,
    zio.aws.networkmanager.model.GetDevicesResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getDevicesPaginated(request))
  def getNetworkResourceCounts(
      request: GetNetworkResourceCountsRequest
  ): ZStream[
    zio.aws.networkmanager.NetworkManager,
    AwsError,
    zio.aws.networkmanager.model.NetworkResourceCount.ReadOnly
  ] = ZStream.serviceWithStream(_.getNetworkResourceCounts(request))
  def getNetworkResourceCountsPaginated(
      request: GetNetworkResourceCountsRequest
  ): ZIO[
    zio.aws.networkmanager.NetworkManager,
    AwsError,
    zio.aws.networkmanager.model.GetNetworkResourceCountsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getNetworkResourceCountsPaginated(request))
  def createSiteToSiteVpnAttachment(
      request: CreateSiteToSiteVpnAttachmentRequest
  ): ZIO[
    zio.aws.networkmanager.NetworkManager,
    AwsError,
    zio.aws.networkmanager.model.CreateSiteToSiteVpnAttachmentResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createSiteToSiteVpnAttachment(request))
  def updateDevice(request: UpdateDeviceRequest): ZIO[
    zio.aws.networkmanager.NetworkManager,
    AwsError,
    zio.aws.networkmanager.model.UpdateDeviceResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.updateDevice(request))
  def listTagsForResource(request: ListTagsForResourceRequest): ZIO[
    zio.aws.networkmanager.NetworkManager,
    AwsError,
    zio.aws.networkmanager.model.ListTagsForResourceResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listTagsForResource(request))
  def listCoreNetworks(request: ListCoreNetworksRequest): ZStream[
    zio.aws.networkmanager.NetworkManager,
    AwsError,
    zio.aws.networkmanager.model.CoreNetworkSummary.ReadOnly
  ] = ZStream.serviceWithStream(_.listCoreNetworks(request))
  def listCoreNetworksPaginated(request: ListCoreNetworksRequest): ZIO[
    zio.aws.networkmanager.NetworkManager,
    AwsError,
    zio.aws.networkmanager.model.ListCoreNetworksResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listCoreNetworksPaginated(request))
  def deleteConnection(request: DeleteConnectionRequest): ZIO[
    zio.aws.networkmanager.NetworkManager,
    AwsError,
    zio.aws.networkmanager.model.DeleteConnectionResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.deleteConnection(request))
  def tagResource(request: TagResourceRequest): ZIO[
    zio.aws.networkmanager.NetworkManager,
    AwsError,
    zio.aws.networkmanager.model.TagResourceResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.tagResource(request))
  def listAttachments(request: ListAttachmentsRequest): ZStream[
    zio.aws.networkmanager.NetworkManager,
    AwsError,
    zio.aws.networkmanager.model.Attachment.ReadOnly
  ] = ZStream.serviceWithStream(_.listAttachments(request))
  def listAttachmentsPaginated(request: ListAttachmentsRequest): ZIO[
    zio.aws.networkmanager.NetworkManager,
    AwsError,
    zio.aws.networkmanager.model.ListAttachmentsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listAttachmentsPaginated(request))
  def acceptAttachment(request: AcceptAttachmentRequest): ZIO[
    zio.aws.networkmanager.NetworkManager,
    AwsError,
    zio.aws.networkmanager.model.AcceptAttachmentResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.acceptAttachment(request))
  def updateSite(request: UpdateSiteRequest): ZIO[
    zio.aws.networkmanager.NetworkManager,
    AwsError,
    zio.aws.networkmanager.model.UpdateSiteResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.updateSite(request))
  def updateNetworkResourceMetadata(
      request: UpdateNetworkResourceMetadataRequest
  ): ZIO[
    zio.aws.networkmanager.NetworkManager,
    AwsError,
    zio.aws.networkmanager.model.UpdateNetworkResourceMetadataResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.updateNetworkResourceMetadata(request))
  def associateCustomerGateway(request: AssociateCustomerGatewayRequest): ZIO[
    zio.aws.networkmanager.NetworkManager,
    AwsError,
    zio.aws.networkmanager.model.AssociateCustomerGatewayResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.associateCustomerGateway(request))
  def disassociateCustomerGateway(
      request: DisassociateCustomerGatewayRequest
  ): ZIO[
    zio.aws.networkmanager.NetworkManager,
    AwsError,
    zio.aws.networkmanager.model.DisassociateCustomerGatewayResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.disassociateCustomerGateway(request))
  def updateGlobalNetwork(request: UpdateGlobalNetworkRequest): ZIO[
    zio.aws.networkmanager.NetworkManager,
    AwsError,
    zio.aws.networkmanager.model.UpdateGlobalNetworkResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.updateGlobalNetwork(request))
  def getResourcePolicy(request: GetResourcePolicyRequest): ZIO[
    zio.aws.networkmanager.NetworkManager,
    AwsError,
    zio.aws.networkmanager.model.GetResourcePolicyResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getResourcePolicy(request))
  def associateConnectPeer(request: AssociateConnectPeerRequest): ZIO[
    zio.aws.networkmanager.NetworkManager,
    AwsError,
    zio.aws.networkmanager.model.AssociateConnectPeerResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.associateConnectPeer(request))
  def associateTransitGatewayConnectPeer(
      request: AssociateTransitGatewayConnectPeerRequest
  ): ZIO[
    zio.aws.networkmanager.NetworkManager,
    AwsError,
    zio.aws.networkmanager.model.AssociateTransitGatewayConnectPeerResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.associateTransitGatewayConnectPeer(request))
  def disassociateConnectPeer(request: DisassociateConnectPeerRequest): ZIO[
    zio.aws.networkmanager.NetworkManager,
    AwsError,
    zio.aws.networkmanager.model.DisassociateConnectPeerResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.disassociateConnectPeer(request))
  def deleteLink(request: DeleteLinkRequest): ZIO[
    zio.aws.networkmanager.NetworkManager,
    AwsError,
    zio.aws.networkmanager.model.DeleteLinkResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.deleteLink(request))
  def deleteAttachment(request: DeleteAttachmentRequest): ZIO[
    zio.aws.networkmanager.NetworkManager,
    AwsError,
    zio.aws.networkmanager.model.DeleteAttachmentResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.deleteAttachment(request))
  def getNetworkResourceRelationships(
      request: GetNetworkResourceRelationshipsRequest
  ): ZStream[
    zio.aws.networkmanager.NetworkManager,
    AwsError,
    zio.aws.networkmanager.model.Relationship.ReadOnly
  ] = ZStream.serviceWithStream(_.getNetworkResourceRelationships(request))
  def getNetworkResourceRelationshipsPaginated(
      request: GetNetworkResourceRelationshipsRequest
  ): ZIO[
    zio.aws.networkmanager.NetworkManager,
    AwsError,
    zio.aws.networkmanager.model.GetNetworkResourceRelationshipsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getNetworkResourceRelationshipsPaginated(request))
  def createLink(request: CreateLinkRequest): ZIO[
    zio.aws.networkmanager.NetworkManager,
    AwsError,
    zio.aws.networkmanager.model.CreateLinkResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createLink(request))
  def createVpcAttachment(request: CreateVpcAttachmentRequest): ZIO[
    zio.aws.networkmanager.NetworkManager,
    AwsError,
    zio.aws.networkmanager.model.CreateVpcAttachmentResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createVpcAttachment(request))
  def putCoreNetworkPolicy(request: PutCoreNetworkPolicyRequest): ZIO[
    zio.aws.networkmanager.NetworkManager,
    AwsError,
    zio.aws.networkmanager.model.PutCoreNetworkPolicyResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.putCoreNetworkPolicy(request))
  def deleteConnectPeer(request: DeleteConnectPeerRequest): ZIO[
    zio.aws.networkmanager.NetworkManager,
    AwsError,
    zio.aws.networkmanager.model.DeleteConnectPeerResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.deleteConnectPeer(request))
  def getConnectAttachment(request: GetConnectAttachmentRequest): ZIO[
    zio.aws.networkmanager.NetworkManager,
    AwsError,
    zio.aws.networkmanager.model.GetConnectAttachmentResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getConnectAttachment(request))
}
