package zio.aws.networkmanager.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class CreateSiteResponse(
    site: Optional[zio.aws.networkmanager.model.Site] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.networkmanager.model.CreateSiteResponse = {
    import CreateSiteResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.networkmanager.model.CreateSiteResponse
      .builder()
      .optionallyWith(site.map(value => value.buildAwsValue()))(_.site)
      .build()
  }
  def asReadOnly: zio.aws.networkmanager.model.CreateSiteResponse.ReadOnly =
    zio.aws.networkmanager.model.CreateSiteResponse.wrap(buildAwsValue())
}
object CreateSiteResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.networkmanager.model.CreateSiteResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.networkmanager.model.CreateSiteResponse =
      zio.aws.networkmanager.model
        .CreateSiteResponse(site.map(value => value.asEditable))
    def site: Optional[zio.aws.networkmanager.model.Site.ReadOnly]
    def getSite
        : ZIO[Any, AwsError, zio.aws.networkmanager.model.Site.ReadOnly] =
      AwsError.unwrapOptionField("site", site)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.networkmanager.model.CreateSiteResponse
  ) extends zio.aws.networkmanager.model.CreateSiteResponse.ReadOnly {
    override val site: Optional[zio.aws.networkmanager.model.Site.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.site())
        .map(value => zio.aws.networkmanager.model.Site.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.networkmanager.model.CreateSiteResponse
  ): zio.aws.networkmanager.model.CreateSiteResponse.ReadOnly = new Wrapper(
    impl
  )
}
