package zio.aws.networkmanager.model
import scala.jdk.CollectionConverters._
sealed trait AttachmentState {
  def unwrap
      : software.amazon.awssdk.services.networkmanager.model.AttachmentState
}
object AttachmentState {
  def wrap(
      value: software.amazon.awssdk.services.networkmanager.model.AttachmentState
  ): zio.aws.networkmanager.model.AttachmentState = value match {
    case software.amazon.awssdk.services.networkmanager.model.AttachmentState.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.networkmanager.model.AttachmentState.REJECTED =>
      val r = REJECTED
      r
    case software.amazon.awssdk.services.networkmanager.model.AttachmentState.PENDING_ATTACHMENT_ACCEPTANCE =>
      val r = PENDING_ATTACHMENT_ACCEPTANCE
      r
    case software.amazon.awssdk.services.networkmanager.model.AttachmentState.CREATING =>
      val r = CREATING
      r
    case software.amazon.awssdk.services.networkmanager.model.AttachmentState.FAILED =>
      val r = FAILED
      r
    case software.amazon.awssdk.services.networkmanager.model.AttachmentState.AVAILABLE =>
      val r = AVAILABLE
      r
    case software.amazon.awssdk.services.networkmanager.model.AttachmentState.UPDATING =>
      val r = UPDATING
      r
    case software.amazon.awssdk.services.networkmanager.model.AttachmentState.PENDING_NETWORK_UPDATE =>
      val r = PENDING_NETWORK_UPDATE
      r
    case software.amazon.awssdk.services.networkmanager.model.AttachmentState.PENDING_TAG_ACCEPTANCE =>
      val r = PENDING_TAG_ACCEPTANCE
      r
    case software.amazon.awssdk.services.networkmanager.model.AttachmentState.DELETING =>
      val r = DELETING
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.networkmanager.model.AttachmentState {
    override def unwrap
        : software.amazon.awssdk.services.networkmanager.model.AttachmentState =
      software.amazon.awssdk.services.networkmanager.model.AttachmentState.UNKNOWN_TO_SDK_VERSION
  }
  case object REJECTED extends zio.aws.networkmanager.model.AttachmentState {
    override def unwrap
        : software.amazon.awssdk.services.networkmanager.model.AttachmentState =
      software.amazon.awssdk.services.networkmanager.model.AttachmentState.REJECTED
  }
  case object PENDING_ATTACHMENT_ACCEPTANCE
      extends zio.aws.networkmanager.model.AttachmentState {
    override def unwrap
        : software.amazon.awssdk.services.networkmanager.model.AttachmentState =
      software.amazon.awssdk.services.networkmanager.model.AttachmentState.PENDING_ATTACHMENT_ACCEPTANCE
  }
  case object CREATING extends zio.aws.networkmanager.model.AttachmentState {
    override def unwrap
        : software.amazon.awssdk.services.networkmanager.model.AttachmentState =
      software.amazon.awssdk.services.networkmanager.model.AttachmentState.CREATING
  }
  case object FAILED extends zio.aws.networkmanager.model.AttachmentState {
    override def unwrap
        : software.amazon.awssdk.services.networkmanager.model.AttachmentState =
      software.amazon.awssdk.services.networkmanager.model.AttachmentState.FAILED
  }
  case object AVAILABLE extends zio.aws.networkmanager.model.AttachmentState {
    override def unwrap
        : software.amazon.awssdk.services.networkmanager.model.AttachmentState =
      software.amazon.awssdk.services.networkmanager.model.AttachmentState.AVAILABLE
  }
  case object UPDATING extends zio.aws.networkmanager.model.AttachmentState {
    override def unwrap
        : software.amazon.awssdk.services.networkmanager.model.AttachmentState =
      software.amazon.awssdk.services.networkmanager.model.AttachmentState.UPDATING
  }
  case object PENDING_NETWORK_UPDATE
      extends zio.aws.networkmanager.model.AttachmentState {
    override def unwrap
        : software.amazon.awssdk.services.networkmanager.model.AttachmentState =
      software.amazon.awssdk.services.networkmanager.model.AttachmentState.PENDING_NETWORK_UPDATE
  }
  case object PENDING_TAG_ACCEPTANCE
      extends zio.aws.networkmanager.model.AttachmentState {
    override def unwrap
        : software.amazon.awssdk.services.networkmanager.model.AttachmentState =
      software.amazon.awssdk.services.networkmanager.model.AttachmentState.PENDING_TAG_ACCEPTANCE
  }
  case object DELETING extends zio.aws.networkmanager.model.AttachmentState {
    override def unwrap
        : software.amazon.awssdk.services.networkmanager.model.AttachmentState =
      software.amazon.awssdk.services.networkmanager.model.AttachmentState.DELETING
  }
}
