package zio.aws.networkmanager
import zio.aws.networkmanager.model.GetCoreNetworkPolicyResponse.ReadOnly
import zio.aws.networkmanager.model.{
  GetNetworkResourcesRequest,
  CreateLinkRequest,
  GetTransitGatewayRegistrationsRequest,
  DeleteConnectPeerRequest,
  AcceptAttachmentRequest,
  ListAttachmentsRequest,
  DeleteCoreNetworkPolicyVersionRequest,
  DeleteGlobalNetworkRequest,
  RejectAttachmentRequest,
  DisassociateCustomerGatewayRequest,
  DeleteSiteRequest,
  DeleteLinkRequest,
  StartOrganizationServiceAccessUpdateRequest,
  GetRouteAnalysisRequest,
  CreateVpcAttachmentRequest,
  UpdateCoreNetworkRequest,
  CreateConnectPeerRequest,
  CreateConnectionRequest,
  DescribeGlobalNetworksRequest,
  StartRouteAnalysisRequest,
  AssociateCustomerGatewayRequest,
  GetNetworkResourceRelationshipsRequest,
  PutCoreNetworkPolicyRequest,
  PutResourcePolicyRequest,
  GetSitesRequest,
  GetNetworkResourceCountsRequest,
  CreateSiteToSiteVpnAttachmentRequest,
  GetSiteToSiteVpnAttachmentRequest,
  AssociateConnectPeerRequest,
  UpdateSiteRequest,
  GetNetworkTelemetryRequest,
  DeleteCoreNetworkRequest,
  ListTagsForResourceRequest,
  GetLinksRequest,
  GetCoreNetworkChangeSetRequest,
  UpdateNetworkResourceMetadataRequest,
  GetConnectAttachmentRequest,
  GetNetworkRoutesRequest,
  GetVpcAttachmentRequest,
  GetDevicesRequest,
  DisassociateConnectPeerRequest,
  ListOrganizationServiceAccessStatusRequest,
  DeleteConnectionRequest,
  UpdateVpcAttachmentRequest,
  ExecuteCoreNetworkChangeSetRequest,
  AssociateTransitGatewayConnectPeerRequest,
  GetCoreNetworkPolicyRequest,
  GetConnectPeerAssociationsRequest,
  GetTransitGatewayConnectPeerAssociationsRequest,
  ListConnectPeersRequest,
  UpdateConnectionRequest,
  UpdateGlobalNetworkRequest,
  DisassociateTransitGatewayConnectPeerRequest,
  GetLinkAssociationsRequest,
  DeleteResourcePolicyRequest,
  RestoreCoreNetworkPolicyVersionRequest,
  DeleteAttachmentRequest,
  UntagResourceRequest,
  CreateCoreNetworkRequest,
  RegisterTransitGatewayRequest,
  GetCustomerGatewayAssociationsRequest,
  ListCoreNetworksRequest,
  GetConnectPeerRequest,
  UpdateLinkRequest,
  ListCoreNetworkPolicyVersionsRequest,
  AssociateLinkRequest,
  CreateConnectAttachmentRequest,
  UpdateDeviceRequest,
  CreateDeviceRequest,
  GetResourcePolicyRequest,
  CreateGlobalNetworkRequest,
  DeregisterTransitGatewayRequest,
  DisassociateLinkRequest,
  DeleteDeviceRequest,
  CreateSiteRequest,
  GetConnectionsRequest,
  GetCoreNetworkRequest,
  TagResourceRequest
}
import zio.mock.{Proxy, Mock}
import software.amazon.awssdk.services.networkmanager.NetworkManagerAsyncClient
import zio.aws.core.AwsError
import zio.aws.core.aspects.AwsCallAspect
import zio.{IO, ZEnvironment, URLayer}
import zio.stream.ZStream
object NetworkManagerMock extends Mock[NetworkManager] {
  object GetConnections
      extends Stream[
        GetConnectionsRequest,
        AwsError,
        zio.aws.networkmanager.model.Connection.ReadOnly
      ]
  object GetConnectionsPaginated
      extends Effect[
        GetConnectionsRequest,
        AwsError,
        zio.aws.networkmanager.model.GetConnectionsResponse.ReadOnly
      ]
  object ListOrganizationServiceAccessStatus
      extends Effect[
        ListOrganizationServiceAccessStatusRequest,
        AwsError,
        zio.aws.networkmanager.model.ListOrganizationServiceAccessStatusResponse.ReadOnly
      ]
  object ListConnectPeers
      extends Stream[
        ListConnectPeersRequest,
        AwsError,
        zio.aws.networkmanager.model.ConnectPeerSummary.ReadOnly
      ]
  object ListConnectPeersPaginated
      extends Effect[
        ListConnectPeersRequest,
        AwsError,
        zio.aws.networkmanager.model.ListConnectPeersResponse.ReadOnly
      ]
  object DisassociateTransitGatewayConnectPeer
      extends Effect[
        DisassociateTransitGatewayConnectPeerRequest,
        AwsError,
        zio.aws.networkmanager.model.DisassociateTransitGatewayConnectPeerResponse.ReadOnly
      ]
  object DescribeGlobalNetworks
      extends Stream[
        DescribeGlobalNetworksRequest,
        AwsError,
        zio.aws.networkmanager.model.GlobalNetwork.ReadOnly
      ]
  object DescribeGlobalNetworksPaginated
      extends Effect[
        DescribeGlobalNetworksRequest,
        AwsError,
        zio.aws.networkmanager.model.DescribeGlobalNetworksResponse.ReadOnly
      ]
  object CreateCoreNetwork
      extends Effect[
        CreateCoreNetworkRequest,
        AwsError,
        zio.aws.networkmanager.model.CreateCoreNetworkResponse.ReadOnly
      ]
  object GetCoreNetworkPolicy
      extends Effect[GetCoreNetworkPolicyRequest, AwsError, ReadOnly]
  object CreateSite
      extends Effect[
        CreateSiteRequest,
        AwsError,
        zio.aws.networkmanager.model.CreateSiteResponse.ReadOnly
      ]
  object ExecuteCoreNetworkChangeSet
      extends Effect[
        ExecuteCoreNetworkChangeSetRequest,
        AwsError,
        zio.aws.networkmanager.model.ExecuteCoreNetworkChangeSetResponse.ReadOnly
      ]
  object StartRouteAnalysis
      extends Effect[
        StartRouteAnalysisRequest,
        AwsError,
        zio.aws.networkmanager.model.StartRouteAnalysisResponse.ReadOnly
      ]
  object RejectAttachment
      extends Effect[
        RejectAttachmentRequest,
        AwsError,
        zio.aws.networkmanager.model.RejectAttachmentResponse.ReadOnly
      ]
  object DisassociateLink
      extends Effect[
        DisassociateLinkRequest,
        AwsError,
        zio.aws.networkmanager.model.DisassociateLinkResponse.ReadOnly
      ]
  object CreateConnection
      extends Effect[
        CreateConnectionRequest,
        AwsError,
        zio.aws.networkmanager.model.CreateConnectionResponse.ReadOnly
      ]
  object CreateDevice
      extends Effect[
        CreateDeviceRequest,
        AwsError,
        zio.aws.networkmanager.model.CreateDeviceResponse.ReadOnly
      ]
  object DeleteDevice
      extends Effect[
        DeleteDeviceRequest,
        AwsError,
        zio.aws.networkmanager.model.DeleteDeviceResponse.ReadOnly
      ]
  object RestoreCoreNetworkPolicyVersion
      extends Effect[
        RestoreCoreNetworkPolicyVersionRequest,
        AwsError,
        zio.aws.networkmanager.model.RestoreCoreNetworkPolicyVersionResponse.ReadOnly
      ]
  object DeregisterTransitGateway
      extends Effect[
        DeregisterTransitGatewayRequest,
        AwsError,
        zio.aws.networkmanager.model.DeregisterTransitGatewayResponse.ReadOnly
      ]
  object UpdateVpcAttachment
      extends Effect[
        UpdateVpcAttachmentRequest,
        AwsError,
        zio.aws.networkmanager.model.UpdateVpcAttachmentResponse.ReadOnly
      ]
  object DeleteCoreNetworkPolicyVersion
      extends Effect[
        DeleteCoreNetworkPolicyVersionRequest,
        AwsError,
        zio.aws.networkmanager.model.DeleteCoreNetworkPolicyVersionResponse.ReadOnly
      ]
  object GetConnectPeer
      extends Effect[
        GetConnectPeerRequest,
        AwsError,
        zio.aws.networkmanager.model.GetConnectPeerResponse.ReadOnly
      ]
  object UpdateLink
      extends Effect[
        UpdateLinkRequest,
        AwsError,
        zio.aws.networkmanager.model.UpdateLinkResponse.ReadOnly
      ]
  object UpdateConnection
      extends Effect[
        UpdateConnectionRequest,
        AwsError,
        zio.aws.networkmanager.model.UpdateConnectionResponse.ReadOnly
      ]
  object CreateConnectPeer
      extends Effect[
        CreateConnectPeerRequest,
        AwsError,
        zio.aws.networkmanager.model.CreateConnectPeerResponse.ReadOnly
      ]
  object GetTransitGatewayRegistrations
      extends Stream[
        GetTransitGatewayRegistrationsRequest,
        AwsError,
        zio.aws.networkmanager.model.TransitGatewayRegistration.ReadOnly
      ]
  object GetTransitGatewayRegistrationsPaginated
      extends Effect[
        GetTransitGatewayRegistrationsRequest,
        AwsError,
        zio.aws.networkmanager.model.GetTransitGatewayRegistrationsResponse.ReadOnly
      ]
  object PutResourcePolicy
      extends Effect[
        PutResourcePolicyRequest,
        AwsError,
        zio.aws.networkmanager.model.PutResourcePolicyResponse.ReadOnly
      ]
  object DeleteGlobalNetwork
      extends Effect[
        DeleteGlobalNetworkRequest,
        AwsError,
        zio.aws.networkmanager.model.DeleteGlobalNetworkResponse.ReadOnly
      ]
  object UpdateCoreNetwork
      extends Effect[
        UpdateCoreNetworkRequest,
        AwsError,
        zio.aws.networkmanager.model.UpdateCoreNetworkResponse.ReadOnly
      ]
  object GetTransitGatewayConnectPeerAssociations
      extends Stream[
        GetTransitGatewayConnectPeerAssociationsRequest,
        AwsError,
        zio.aws.networkmanager.model.TransitGatewayConnectPeerAssociation.ReadOnly
      ]
  object GetTransitGatewayConnectPeerAssociationsPaginated
      extends Effect[
        GetTransitGatewayConnectPeerAssociationsRequest,
        AwsError,
        zio.aws.networkmanager.model.GetTransitGatewayConnectPeerAssociationsResponse.ReadOnly
      ]
  object GetSiteToSiteVpnAttachment
      extends Effect[
        GetSiteToSiteVpnAttachmentRequest,
        AwsError,
        zio.aws.networkmanager.model.GetSiteToSiteVpnAttachmentResponse.ReadOnly
      ]
  object GetLinks
      extends Stream[
        GetLinksRequest,
        AwsError,
        zio.aws.networkmanager.model.Link.ReadOnly
      ]
  object GetLinksPaginated
      extends Effect[
        GetLinksRequest,
        AwsError,
        zio.aws.networkmanager.model.GetLinksResponse.ReadOnly
      ]
  object GetCustomerGatewayAssociations
      extends Stream[
        GetCustomerGatewayAssociationsRequest,
        AwsError,
        zio.aws.networkmanager.model.CustomerGatewayAssociation.ReadOnly
      ]
  object GetCustomerGatewayAssociationsPaginated
      extends Effect[
        GetCustomerGatewayAssociationsRequest,
        AwsError,
        zio.aws.networkmanager.model.GetCustomerGatewayAssociationsResponse.ReadOnly
      ]
  object DeleteCoreNetwork
      extends Effect[
        DeleteCoreNetworkRequest,
        AwsError,
        zio.aws.networkmanager.model.DeleteCoreNetworkResponse.ReadOnly
      ]
  object GetNetworkTelemetry
      extends Stream[
        GetNetworkTelemetryRequest,
        AwsError,
        zio.aws.networkmanager.model.NetworkTelemetry.ReadOnly
      ]
  object GetNetworkTelemetryPaginated
      extends Effect[
        GetNetworkTelemetryRequest,
        AwsError,
        zio.aws.networkmanager.model.GetNetworkTelemetryResponse.ReadOnly
      ]
  object GetCoreNetworkChangeSet
      extends Stream[
        GetCoreNetworkChangeSetRequest,
        AwsError,
        zio.aws.networkmanager.model.CoreNetworkChange.ReadOnly
      ]
  object GetCoreNetworkChangeSetPaginated
      extends Effect[
        GetCoreNetworkChangeSetRequest,
        AwsError,
        zio.aws.networkmanager.model.GetCoreNetworkChangeSetResponse.ReadOnly
      ]
  object GetNetworkRoutes
      extends Effect[
        GetNetworkRoutesRequest,
        AwsError,
        zio.aws.networkmanager.model.GetNetworkRoutesResponse.ReadOnly
      ]
  object GetCoreNetwork
      extends Effect[
        GetCoreNetworkRequest,
        AwsError,
        zio.aws.networkmanager.model.GetCoreNetworkResponse.ReadOnly
      ]
  object CreateGlobalNetwork
      extends Effect[
        CreateGlobalNetworkRequest,
        AwsError,
        zio.aws.networkmanager.model.CreateGlobalNetworkResponse.ReadOnly
      ]
  object DeleteSite
      extends Effect[
        DeleteSiteRequest,
        AwsError,
        zio.aws.networkmanager.model.DeleteSiteResponse.ReadOnly
      ]
  object ListCoreNetworkPolicyVersions
      extends Stream[
        ListCoreNetworkPolicyVersionsRequest,
        AwsError,
        zio.aws.networkmanager.model.CoreNetworkPolicyVersion.ReadOnly
      ]
  object ListCoreNetworkPolicyVersionsPaginated
      extends Effect[
        ListCoreNetworkPolicyVersionsRequest,
        AwsError,
        zio.aws.networkmanager.model.ListCoreNetworkPolicyVersionsResponse.ReadOnly
      ]
  object GetNetworkResources
      extends Stream[
        GetNetworkResourcesRequest,
        AwsError,
        zio.aws.networkmanager.model.NetworkResource.ReadOnly
      ]
  object GetNetworkResourcesPaginated
      extends Effect[
        GetNetworkResourcesRequest,
        AwsError,
        zio.aws.networkmanager.model.GetNetworkResourcesResponse.ReadOnly
      ]
  object RegisterTransitGateway
      extends Effect[
        RegisterTransitGatewayRequest,
        AwsError,
        zio.aws.networkmanager.model.RegisterTransitGatewayResponse.ReadOnly
      ]
  object GetLinkAssociations
      extends Stream[
        GetLinkAssociationsRequest,
        AwsError,
        zio.aws.networkmanager.model.LinkAssociation.ReadOnly
      ]
  object GetLinkAssociationsPaginated
      extends Effect[
        GetLinkAssociationsRequest,
        AwsError,
        zio.aws.networkmanager.model.GetLinkAssociationsResponse.ReadOnly
      ]
  object StartOrganizationServiceAccessUpdate
      extends Effect[
        StartOrganizationServiceAccessUpdateRequest,
        AwsError,
        zio.aws.networkmanager.model.StartOrganizationServiceAccessUpdateResponse.ReadOnly
      ]
  object UntagResource
      extends Effect[
        UntagResourceRequest,
        AwsError,
        zio.aws.networkmanager.model.UntagResourceResponse.ReadOnly
      ]
  object GetRouteAnalysis
      extends Effect[
        GetRouteAnalysisRequest,
        AwsError,
        zio.aws.networkmanager.model.GetRouteAnalysisResponse.ReadOnly
      ]
  object GetSites
      extends Stream[
        GetSitesRequest,
        AwsError,
        zio.aws.networkmanager.model.Site.ReadOnly
      ]
  object GetSitesPaginated
      extends Effect[
        GetSitesRequest,
        AwsError,
        zio.aws.networkmanager.model.GetSitesResponse.ReadOnly
      ]
  object AssociateLink
      extends Effect[
        AssociateLinkRequest,
        AwsError,
        zio.aws.networkmanager.model.AssociateLinkResponse.ReadOnly
      ]
  object CreateConnectAttachment
      extends Effect[
        CreateConnectAttachmentRequest,
        AwsError,
        zio.aws.networkmanager.model.CreateConnectAttachmentResponse.ReadOnly
      ]
  object DeleteResourcePolicy
      extends Effect[
        DeleteResourcePolicyRequest,
        AwsError,
        zio.aws.networkmanager.model.DeleteResourcePolicyResponse.ReadOnly
      ]
  object GetConnectPeerAssociations
      extends Stream[
        GetConnectPeerAssociationsRequest,
        AwsError,
        zio.aws.networkmanager.model.ConnectPeerAssociation.ReadOnly
      ]
  object GetConnectPeerAssociationsPaginated
      extends Effect[
        GetConnectPeerAssociationsRequest,
        AwsError,
        zio.aws.networkmanager.model.GetConnectPeerAssociationsResponse.ReadOnly
      ]
  object GetVpcAttachment
      extends Effect[
        GetVpcAttachmentRequest,
        AwsError,
        zio.aws.networkmanager.model.GetVpcAttachmentResponse.ReadOnly
      ]
  object GetDevices
      extends Stream[
        GetDevicesRequest,
        AwsError,
        zio.aws.networkmanager.model.Device.ReadOnly
      ]
  object GetDevicesPaginated
      extends Effect[
        GetDevicesRequest,
        AwsError,
        zio.aws.networkmanager.model.GetDevicesResponse.ReadOnly
      ]
  object GetNetworkResourceCounts
      extends Stream[
        GetNetworkResourceCountsRequest,
        AwsError,
        zio.aws.networkmanager.model.NetworkResourceCount.ReadOnly
      ]
  object GetNetworkResourceCountsPaginated
      extends Effect[
        GetNetworkResourceCountsRequest,
        AwsError,
        zio.aws.networkmanager.model.GetNetworkResourceCountsResponse.ReadOnly
      ]
  object CreateSiteToSiteVpnAttachment
      extends Effect[
        CreateSiteToSiteVpnAttachmentRequest,
        AwsError,
        zio.aws.networkmanager.model.CreateSiteToSiteVpnAttachmentResponse.ReadOnly
      ]
  object UpdateDevice
      extends Effect[
        UpdateDeviceRequest,
        AwsError,
        zio.aws.networkmanager.model.UpdateDeviceResponse.ReadOnly
      ]
  object ListTagsForResource
      extends Effect[
        ListTagsForResourceRequest,
        AwsError,
        zio.aws.networkmanager.model.ListTagsForResourceResponse.ReadOnly
      ]
  object ListCoreNetworks
      extends Stream[
        ListCoreNetworksRequest,
        AwsError,
        zio.aws.networkmanager.model.CoreNetworkSummary.ReadOnly
      ]
  object ListCoreNetworksPaginated
      extends Effect[
        ListCoreNetworksRequest,
        AwsError,
        zio.aws.networkmanager.model.ListCoreNetworksResponse.ReadOnly
      ]
  object DeleteConnection
      extends Effect[
        DeleteConnectionRequest,
        AwsError,
        zio.aws.networkmanager.model.DeleteConnectionResponse.ReadOnly
      ]
  object TagResource
      extends Effect[
        TagResourceRequest,
        AwsError,
        zio.aws.networkmanager.model.TagResourceResponse.ReadOnly
      ]
  object ListAttachments
      extends Stream[
        ListAttachmentsRequest,
        AwsError,
        zio.aws.networkmanager.model.Attachment.ReadOnly
      ]
  object ListAttachmentsPaginated
      extends Effect[
        ListAttachmentsRequest,
        AwsError,
        zio.aws.networkmanager.model.ListAttachmentsResponse.ReadOnly
      ]
  object AcceptAttachment
      extends Effect[
        AcceptAttachmentRequest,
        AwsError,
        zio.aws.networkmanager.model.AcceptAttachmentResponse.ReadOnly
      ]
  object UpdateSite
      extends Effect[
        UpdateSiteRequest,
        AwsError,
        zio.aws.networkmanager.model.UpdateSiteResponse.ReadOnly
      ]
  object UpdateNetworkResourceMetadata
      extends Effect[
        UpdateNetworkResourceMetadataRequest,
        AwsError,
        zio.aws.networkmanager.model.UpdateNetworkResourceMetadataResponse.ReadOnly
      ]
  object AssociateCustomerGateway
      extends Effect[
        AssociateCustomerGatewayRequest,
        AwsError,
        zio.aws.networkmanager.model.AssociateCustomerGatewayResponse.ReadOnly
      ]
  object DisassociateCustomerGateway
      extends Effect[
        DisassociateCustomerGatewayRequest,
        AwsError,
        zio.aws.networkmanager.model.DisassociateCustomerGatewayResponse.ReadOnly
      ]
  object UpdateGlobalNetwork
      extends Effect[
        UpdateGlobalNetworkRequest,
        AwsError,
        zio.aws.networkmanager.model.UpdateGlobalNetworkResponse.ReadOnly
      ]
  object GetResourcePolicy
      extends Effect[
        GetResourcePolicyRequest,
        AwsError,
        zio.aws.networkmanager.model.GetResourcePolicyResponse.ReadOnly
      ]
  object AssociateConnectPeer
      extends Effect[
        AssociateConnectPeerRequest,
        AwsError,
        zio.aws.networkmanager.model.AssociateConnectPeerResponse.ReadOnly
      ]
  object AssociateTransitGatewayConnectPeer
      extends Effect[
        AssociateTransitGatewayConnectPeerRequest,
        AwsError,
        zio.aws.networkmanager.model.AssociateTransitGatewayConnectPeerResponse.ReadOnly
      ]
  object DisassociateConnectPeer
      extends Effect[
        DisassociateConnectPeerRequest,
        AwsError,
        zio.aws.networkmanager.model.DisassociateConnectPeerResponse.ReadOnly
      ]
  object DeleteLink
      extends Effect[
        DeleteLinkRequest,
        AwsError,
        zio.aws.networkmanager.model.DeleteLinkResponse.ReadOnly
      ]
  object DeleteAttachment
      extends Effect[
        DeleteAttachmentRequest,
        AwsError,
        zio.aws.networkmanager.model.DeleteAttachmentResponse.ReadOnly
      ]
  object GetNetworkResourceRelationships
      extends Stream[
        GetNetworkResourceRelationshipsRequest,
        AwsError,
        zio.aws.networkmanager.model.Relationship.ReadOnly
      ]
  object GetNetworkResourceRelationshipsPaginated
      extends Effect[
        GetNetworkResourceRelationshipsRequest,
        AwsError,
        zio.aws.networkmanager.model.GetNetworkResourceRelationshipsResponse.ReadOnly
      ]
  object CreateLink
      extends Effect[
        CreateLinkRequest,
        AwsError,
        zio.aws.networkmanager.model.CreateLinkResponse.ReadOnly
      ]
  object CreateVpcAttachment
      extends Effect[
        CreateVpcAttachmentRequest,
        AwsError,
        zio.aws.networkmanager.model.CreateVpcAttachmentResponse.ReadOnly
      ]
  object PutCoreNetworkPolicy
      extends Effect[
        PutCoreNetworkPolicyRequest,
        AwsError,
        zio.aws.networkmanager.model.PutCoreNetworkPolicyResponse.ReadOnly
      ]
  object DeleteConnectPeer
      extends Effect[
        DeleteConnectPeerRequest,
        AwsError,
        zio.aws.networkmanager.model.DeleteConnectPeerResponse.ReadOnly
      ]
  object GetConnectAttachment
      extends Effect[
        GetConnectAttachmentRequest,
        AwsError,
        zio.aws.networkmanager.model.GetConnectAttachmentResponse.ReadOnly
      ]
  val compose: URLayer[Proxy, NetworkManager] = zio.ZLayer {
    zio.ZIO.service[Proxy].flatMap { proxy =>
      withRuntime[Proxy, NetworkManager] { rts =>
        zio.ZIO.succeed {
          new NetworkManager {
            val api: NetworkManagerAsyncClient = null
            def withAspect[R1](
                newAspect: AwsCallAspect[R1],
                r: ZEnvironment[R1]
            ): NetworkManager = this
            def getConnections(request: GetConnectionsRequest): ZStream[
              Any,
              AwsError,
              zio.aws.networkmanager.model.Connection.ReadOnly
            ] = rts.unsafeRun(proxy(GetConnections, request))
            def getConnectionsPaginated(request: GetConnectionsRequest): IO[
              AwsError,
              zio.aws.networkmanager.model.GetConnectionsResponse.ReadOnly
            ] = proxy(GetConnectionsPaginated, request)
            def listOrganizationServiceAccessStatus(
                request: ListOrganizationServiceAccessStatusRequest
            ): IO[
              AwsError,
              zio.aws.networkmanager.model.ListOrganizationServiceAccessStatusResponse.ReadOnly
            ] = proxy(ListOrganizationServiceAccessStatus, request)
            def listConnectPeers(request: ListConnectPeersRequest): ZStream[
              Any,
              AwsError,
              zio.aws.networkmanager.model.ConnectPeerSummary.ReadOnly
            ] = rts.unsafeRun(proxy(ListConnectPeers, request))
            def listConnectPeersPaginated(request: ListConnectPeersRequest): IO[
              AwsError,
              zio.aws.networkmanager.model.ListConnectPeersResponse.ReadOnly
            ] = proxy(ListConnectPeersPaginated, request)
            def disassociateTransitGatewayConnectPeer(
                request: DisassociateTransitGatewayConnectPeerRequest
            ): IO[
              AwsError,
              zio.aws.networkmanager.model.DisassociateTransitGatewayConnectPeerResponse.ReadOnly
            ] = proxy(DisassociateTransitGatewayConnectPeer, request)
            def describeGlobalNetworks(
                request: DescribeGlobalNetworksRequest
            ): ZStream[
              Any,
              AwsError,
              zio.aws.networkmanager.model.GlobalNetwork.ReadOnly
            ] = rts.unsafeRun(proxy(DescribeGlobalNetworks, request))
            def describeGlobalNetworksPaginated(
                request: DescribeGlobalNetworksRequest
            ): IO[
              AwsError,
              zio.aws.networkmanager.model.DescribeGlobalNetworksResponse.ReadOnly
            ] = proxy(DescribeGlobalNetworksPaginated, request)
            def createCoreNetwork(request: CreateCoreNetworkRequest): IO[
              AwsError,
              zio.aws.networkmanager.model.CreateCoreNetworkResponse.ReadOnly
            ] = proxy(CreateCoreNetwork, request)
            def getCoreNetworkPolicy(
                request: GetCoreNetworkPolicyRequest
            ): IO[AwsError, ReadOnly] = proxy(GetCoreNetworkPolicy, request)
            def createSite(request: CreateSiteRequest): IO[
              AwsError,
              zio.aws.networkmanager.model.CreateSiteResponse.ReadOnly
            ] = proxy(CreateSite, request)
            def executeCoreNetworkChangeSet(
                request: ExecuteCoreNetworkChangeSetRequest
            ): IO[
              AwsError,
              zio.aws.networkmanager.model.ExecuteCoreNetworkChangeSetResponse.ReadOnly
            ] = proxy(ExecuteCoreNetworkChangeSet, request)
            def startRouteAnalysis(request: StartRouteAnalysisRequest): IO[
              AwsError,
              zio.aws.networkmanager.model.StartRouteAnalysisResponse.ReadOnly
            ] = proxy(StartRouteAnalysis, request)
            def rejectAttachment(request: RejectAttachmentRequest): IO[
              AwsError,
              zio.aws.networkmanager.model.RejectAttachmentResponse.ReadOnly
            ] = proxy(RejectAttachment, request)
            def disassociateLink(request: DisassociateLinkRequest): IO[
              AwsError,
              zio.aws.networkmanager.model.DisassociateLinkResponse.ReadOnly
            ] = proxy(DisassociateLink, request)
            def createConnection(request: CreateConnectionRequest): IO[
              AwsError,
              zio.aws.networkmanager.model.CreateConnectionResponse.ReadOnly
            ] = proxy(CreateConnection, request)
            def createDevice(request: CreateDeviceRequest): IO[
              AwsError,
              zio.aws.networkmanager.model.CreateDeviceResponse.ReadOnly
            ] = proxy(CreateDevice, request)
            def deleteDevice(request: DeleteDeviceRequest): IO[
              AwsError,
              zio.aws.networkmanager.model.DeleteDeviceResponse.ReadOnly
            ] = proxy(DeleteDevice, request)
            def restoreCoreNetworkPolicyVersion(
                request: RestoreCoreNetworkPolicyVersionRequest
            ): IO[
              AwsError,
              zio.aws.networkmanager.model.RestoreCoreNetworkPolicyVersionResponse.ReadOnly
            ] = proxy(RestoreCoreNetworkPolicyVersion, request)
            def deregisterTransitGateway(
                request: DeregisterTransitGatewayRequest
            ): IO[
              AwsError,
              zio.aws.networkmanager.model.DeregisterTransitGatewayResponse.ReadOnly
            ] = proxy(DeregisterTransitGateway, request)
            def updateVpcAttachment(request: UpdateVpcAttachmentRequest): IO[
              AwsError,
              zio.aws.networkmanager.model.UpdateVpcAttachmentResponse.ReadOnly
            ] = proxy(UpdateVpcAttachment, request)
            def deleteCoreNetworkPolicyVersion(
                request: DeleteCoreNetworkPolicyVersionRequest
            ): IO[
              AwsError,
              zio.aws.networkmanager.model.DeleteCoreNetworkPolicyVersionResponse.ReadOnly
            ] = proxy(DeleteCoreNetworkPolicyVersion, request)
            def getConnectPeer(request: GetConnectPeerRequest): IO[
              AwsError,
              zio.aws.networkmanager.model.GetConnectPeerResponse.ReadOnly
            ] = proxy(GetConnectPeer, request)
            def updateLink(request: UpdateLinkRequest): IO[
              AwsError,
              zio.aws.networkmanager.model.UpdateLinkResponse.ReadOnly
            ] = proxy(UpdateLink, request)
            def updateConnection(request: UpdateConnectionRequest): IO[
              AwsError,
              zio.aws.networkmanager.model.UpdateConnectionResponse.ReadOnly
            ] = proxy(UpdateConnection, request)
            def createConnectPeer(request: CreateConnectPeerRequest): IO[
              AwsError,
              zio.aws.networkmanager.model.CreateConnectPeerResponse.ReadOnly
            ] = proxy(CreateConnectPeer, request)
            def getTransitGatewayRegistrations(
                request: GetTransitGatewayRegistrationsRequest
            ): ZStream[
              Any,
              AwsError,
              zio.aws.networkmanager.model.TransitGatewayRegistration.ReadOnly
            ] = rts.unsafeRun(proxy(GetTransitGatewayRegistrations, request))
            def getTransitGatewayRegistrationsPaginated(
                request: GetTransitGatewayRegistrationsRequest
            ): IO[
              AwsError,
              zio.aws.networkmanager.model.GetTransitGatewayRegistrationsResponse.ReadOnly
            ] = proxy(GetTransitGatewayRegistrationsPaginated, request)
            def putResourcePolicy(request: PutResourcePolicyRequest): IO[
              AwsError,
              zio.aws.networkmanager.model.PutResourcePolicyResponse.ReadOnly
            ] = proxy(PutResourcePolicy, request)
            def deleteGlobalNetwork(request: DeleteGlobalNetworkRequest): IO[
              AwsError,
              zio.aws.networkmanager.model.DeleteGlobalNetworkResponse.ReadOnly
            ] = proxy(DeleteGlobalNetwork, request)
            def updateCoreNetwork(request: UpdateCoreNetworkRequest): IO[
              AwsError,
              zio.aws.networkmanager.model.UpdateCoreNetworkResponse.ReadOnly
            ] = proxy(UpdateCoreNetwork, request)
            def getTransitGatewayConnectPeerAssociations(
                request: GetTransitGatewayConnectPeerAssociationsRequest
            ): ZStream[
              Any,
              AwsError,
              zio.aws.networkmanager.model.TransitGatewayConnectPeerAssociation.ReadOnly
            ] = rts.unsafeRun(
              proxy(GetTransitGatewayConnectPeerAssociations, request)
            )
            def getTransitGatewayConnectPeerAssociationsPaginated(
                request: GetTransitGatewayConnectPeerAssociationsRequest
            ): IO[
              AwsError,
              zio.aws.networkmanager.model.GetTransitGatewayConnectPeerAssociationsResponse.ReadOnly
            ] =
              proxy(GetTransitGatewayConnectPeerAssociationsPaginated, request)
            def getSiteToSiteVpnAttachment(
                request: GetSiteToSiteVpnAttachmentRequest
            ): IO[
              AwsError,
              zio.aws.networkmanager.model.GetSiteToSiteVpnAttachmentResponse.ReadOnly
            ] = proxy(GetSiteToSiteVpnAttachment, request)
            def getLinks(request: GetLinksRequest): ZStream[
              Any,
              AwsError,
              zio.aws.networkmanager.model.Link.ReadOnly
            ] = rts.unsafeRun(proxy(GetLinks, request))
            def getLinksPaginated(request: GetLinksRequest): IO[
              AwsError,
              zio.aws.networkmanager.model.GetLinksResponse.ReadOnly
            ] = proxy(GetLinksPaginated, request)
            def getCustomerGatewayAssociations(
                request: GetCustomerGatewayAssociationsRequest
            ): ZStream[
              Any,
              AwsError,
              zio.aws.networkmanager.model.CustomerGatewayAssociation.ReadOnly
            ] = rts.unsafeRun(proxy(GetCustomerGatewayAssociations, request))
            def getCustomerGatewayAssociationsPaginated(
                request: GetCustomerGatewayAssociationsRequest
            ): IO[
              AwsError,
              zio.aws.networkmanager.model.GetCustomerGatewayAssociationsResponse.ReadOnly
            ] = proxy(GetCustomerGatewayAssociationsPaginated, request)
            def deleteCoreNetwork(request: DeleteCoreNetworkRequest): IO[
              AwsError,
              zio.aws.networkmanager.model.DeleteCoreNetworkResponse.ReadOnly
            ] = proxy(DeleteCoreNetwork, request)
            def getNetworkTelemetry(
                request: GetNetworkTelemetryRequest
            ): ZStream[
              Any,
              AwsError,
              zio.aws.networkmanager.model.NetworkTelemetry.ReadOnly
            ] = rts.unsafeRun(proxy(GetNetworkTelemetry, request))
            def getNetworkTelemetryPaginated(
                request: GetNetworkTelemetryRequest
            ): IO[
              AwsError,
              zio.aws.networkmanager.model.GetNetworkTelemetryResponse.ReadOnly
            ] = proxy(GetNetworkTelemetryPaginated, request)
            def getCoreNetworkChangeSet(
                request: GetCoreNetworkChangeSetRequest
            ): ZStream[
              Any,
              AwsError,
              zio.aws.networkmanager.model.CoreNetworkChange.ReadOnly
            ] = rts.unsafeRun(proxy(GetCoreNetworkChangeSet, request))
            def getCoreNetworkChangeSetPaginated(
                request: GetCoreNetworkChangeSetRequest
            ): IO[
              AwsError,
              zio.aws.networkmanager.model.GetCoreNetworkChangeSetResponse.ReadOnly
            ] = proxy(GetCoreNetworkChangeSetPaginated, request)
            def getNetworkRoutes(request: GetNetworkRoutesRequest): IO[
              AwsError,
              zio.aws.networkmanager.model.GetNetworkRoutesResponse.ReadOnly
            ] = proxy(GetNetworkRoutes, request)
            def getCoreNetwork(request: GetCoreNetworkRequest): IO[
              AwsError,
              zio.aws.networkmanager.model.GetCoreNetworkResponse.ReadOnly
            ] = proxy(GetCoreNetwork, request)
            def createGlobalNetwork(request: CreateGlobalNetworkRequest): IO[
              AwsError,
              zio.aws.networkmanager.model.CreateGlobalNetworkResponse.ReadOnly
            ] = proxy(CreateGlobalNetwork, request)
            def deleteSite(request: DeleteSiteRequest): IO[
              AwsError,
              zio.aws.networkmanager.model.DeleteSiteResponse.ReadOnly
            ] = proxy(DeleteSite, request)
            def listCoreNetworkPolicyVersions(
                request: ListCoreNetworkPolicyVersionsRequest
            ): ZStream[
              Any,
              AwsError,
              zio.aws.networkmanager.model.CoreNetworkPolicyVersion.ReadOnly
            ] = rts.unsafeRun(proxy(ListCoreNetworkPolicyVersions, request))
            def listCoreNetworkPolicyVersionsPaginated(
                request: ListCoreNetworkPolicyVersionsRequest
            ): IO[
              AwsError,
              zio.aws.networkmanager.model.ListCoreNetworkPolicyVersionsResponse.ReadOnly
            ] = proxy(ListCoreNetworkPolicyVersionsPaginated, request)
            def getNetworkResources(
                request: GetNetworkResourcesRequest
            ): ZStream[
              Any,
              AwsError,
              zio.aws.networkmanager.model.NetworkResource.ReadOnly
            ] = rts.unsafeRun(proxy(GetNetworkResources, request))
            def getNetworkResourcesPaginated(
                request: GetNetworkResourcesRequest
            ): IO[
              AwsError,
              zio.aws.networkmanager.model.GetNetworkResourcesResponse.ReadOnly
            ] = proxy(GetNetworkResourcesPaginated, request)
            def registerTransitGateway(
                request: RegisterTransitGatewayRequest
            ): IO[
              AwsError,
              zio.aws.networkmanager.model.RegisterTransitGatewayResponse.ReadOnly
            ] = proxy(RegisterTransitGateway, request)
            def getLinkAssociations(
                request: GetLinkAssociationsRequest
            ): ZStream[
              Any,
              AwsError,
              zio.aws.networkmanager.model.LinkAssociation.ReadOnly
            ] = rts.unsafeRun(proxy(GetLinkAssociations, request))
            def getLinkAssociationsPaginated(
                request: GetLinkAssociationsRequest
            ): IO[
              AwsError,
              zio.aws.networkmanager.model.GetLinkAssociationsResponse.ReadOnly
            ] = proxy(GetLinkAssociationsPaginated, request)
            def startOrganizationServiceAccessUpdate(
                request: StartOrganizationServiceAccessUpdateRequest
            ): IO[
              AwsError,
              zio.aws.networkmanager.model.StartOrganizationServiceAccessUpdateResponse.ReadOnly
            ] = proxy(StartOrganizationServiceAccessUpdate, request)
            def untagResource(request: UntagResourceRequest): IO[
              AwsError,
              zio.aws.networkmanager.model.UntagResourceResponse.ReadOnly
            ] = proxy(UntagResource, request)
            def getRouteAnalysis(request: GetRouteAnalysisRequest): IO[
              AwsError,
              zio.aws.networkmanager.model.GetRouteAnalysisResponse.ReadOnly
            ] = proxy(GetRouteAnalysis, request)
            def getSites(request: GetSitesRequest): ZStream[
              Any,
              AwsError,
              zio.aws.networkmanager.model.Site.ReadOnly
            ] = rts.unsafeRun(proxy(GetSites, request))
            def getSitesPaginated(request: GetSitesRequest): IO[
              AwsError,
              zio.aws.networkmanager.model.GetSitesResponse.ReadOnly
            ] = proxy(GetSitesPaginated, request)
            def associateLink(request: AssociateLinkRequest): IO[
              AwsError,
              zio.aws.networkmanager.model.AssociateLinkResponse.ReadOnly
            ] = proxy(AssociateLink, request)
            def createConnectAttachment(
                request: CreateConnectAttachmentRequest
            ): IO[
              AwsError,
              zio.aws.networkmanager.model.CreateConnectAttachmentResponse.ReadOnly
            ] = proxy(CreateConnectAttachment, request)
            def deleteResourcePolicy(request: DeleteResourcePolicyRequest): IO[
              AwsError,
              zio.aws.networkmanager.model.DeleteResourcePolicyResponse.ReadOnly
            ] = proxy(DeleteResourcePolicy, request)
            def getConnectPeerAssociations(
                request: GetConnectPeerAssociationsRequest
            ): ZStream[
              Any,
              AwsError,
              zio.aws.networkmanager.model.ConnectPeerAssociation.ReadOnly
            ] = rts.unsafeRun(proxy(GetConnectPeerAssociations, request))
            def getConnectPeerAssociationsPaginated(
                request: GetConnectPeerAssociationsRequest
            ): IO[
              AwsError,
              zio.aws.networkmanager.model.GetConnectPeerAssociationsResponse.ReadOnly
            ] = proxy(GetConnectPeerAssociationsPaginated, request)
            def getVpcAttachment(request: GetVpcAttachmentRequest): IO[
              AwsError,
              zio.aws.networkmanager.model.GetVpcAttachmentResponse.ReadOnly
            ] = proxy(GetVpcAttachment, request)
            def getDevices(request: GetDevicesRequest): ZStream[
              Any,
              AwsError,
              zio.aws.networkmanager.model.Device.ReadOnly
            ] = rts.unsafeRun(proxy(GetDevices, request))
            def getDevicesPaginated(request: GetDevicesRequest): IO[
              AwsError,
              zio.aws.networkmanager.model.GetDevicesResponse.ReadOnly
            ] = proxy(GetDevicesPaginated, request)
            def getNetworkResourceCounts(
                request: GetNetworkResourceCountsRequest
            ): ZStream[
              Any,
              AwsError,
              zio.aws.networkmanager.model.NetworkResourceCount.ReadOnly
            ] = rts.unsafeRun(proxy(GetNetworkResourceCounts, request))
            def getNetworkResourceCountsPaginated(
                request: GetNetworkResourceCountsRequest
            ): IO[
              AwsError,
              zio.aws.networkmanager.model.GetNetworkResourceCountsResponse.ReadOnly
            ] = proxy(GetNetworkResourceCountsPaginated, request)
            def createSiteToSiteVpnAttachment(
                request: CreateSiteToSiteVpnAttachmentRequest
            ): IO[
              AwsError,
              zio.aws.networkmanager.model.CreateSiteToSiteVpnAttachmentResponse.ReadOnly
            ] = proxy(CreateSiteToSiteVpnAttachment, request)
            def updateDevice(request: UpdateDeviceRequest): IO[
              AwsError,
              zio.aws.networkmanager.model.UpdateDeviceResponse.ReadOnly
            ] = proxy(UpdateDevice, request)
            def listTagsForResource(request: ListTagsForResourceRequest): IO[
              AwsError,
              zio.aws.networkmanager.model.ListTagsForResourceResponse.ReadOnly
            ] = proxy(ListTagsForResource, request)
            def listCoreNetworks(request: ListCoreNetworksRequest): ZStream[
              Any,
              AwsError,
              zio.aws.networkmanager.model.CoreNetworkSummary.ReadOnly
            ] = rts.unsafeRun(proxy(ListCoreNetworks, request))
            def listCoreNetworksPaginated(request: ListCoreNetworksRequest): IO[
              AwsError,
              zio.aws.networkmanager.model.ListCoreNetworksResponse.ReadOnly
            ] = proxy(ListCoreNetworksPaginated, request)
            def deleteConnection(request: DeleteConnectionRequest): IO[
              AwsError,
              zio.aws.networkmanager.model.DeleteConnectionResponse.ReadOnly
            ] = proxy(DeleteConnection, request)
            def tagResource(request: TagResourceRequest): IO[
              AwsError,
              zio.aws.networkmanager.model.TagResourceResponse.ReadOnly
            ] = proxy(TagResource, request)
            def listAttachments(request: ListAttachmentsRequest): ZStream[
              Any,
              AwsError,
              zio.aws.networkmanager.model.Attachment.ReadOnly
            ] = rts.unsafeRun(proxy(ListAttachments, request))
            def listAttachmentsPaginated(request: ListAttachmentsRequest): IO[
              AwsError,
              zio.aws.networkmanager.model.ListAttachmentsResponse.ReadOnly
            ] = proxy(ListAttachmentsPaginated, request)
            def acceptAttachment(request: AcceptAttachmentRequest): IO[
              AwsError,
              zio.aws.networkmanager.model.AcceptAttachmentResponse.ReadOnly
            ] = proxy(AcceptAttachment, request)
            def updateSite(request: UpdateSiteRequest): IO[
              AwsError,
              zio.aws.networkmanager.model.UpdateSiteResponse.ReadOnly
            ] = proxy(UpdateSite, request)
            def updateNetworkResourceMetadata(
                request: UpdateNetworkResourceMetadataRequest
            ): IO[
              AwsError,
              zio.aws.networkmanager.model.UpdateNetworkResourceMetadataResponse.ReadOnly
            ] = proxy(UpdateNetworkResourceMetadata, request)
            def associateCustomerGateway(
                request: AssociateCustomerGatewayRequest
            ): IO[
              AwsError,
              zio.aws.networkmanager.model.AssociateCustomerGatewayResponse.ReadOnly
            ] = proxy(AssociateCustomerGateway, request)
            def disassociateCustomerGateway(
                request: DisassociateCustomerGatewayRequest
            ): IO[
              AwsError,
              zio.aws.networkmanager.model.DisassociateCustomerGatewayResponse.ReadOnly
            ] = proxy(DisassociateCustomerGateway, request)
            def updateGlobalNetwork(request: UpdateGlobalNetworkRequest): IO[
              AwsError,
              zio.aws.networkmanager.model.UpdateGlobalNetworkResponse.ReadOnly
            ] = proxy(UpdateGlobalNetwork, request)
            def getResourcePolicy(request: GetResourcePolicyRequest): IO[
              AwsError,
              zio.aws.networkmanager.model.GetResourcePolicyResponse.ReadOnly
            ] = proxy(GetResourcePolicy, request)
            def associateConnectPeer(request: AssociateConnectPeerRequest): IO[
              AwsError,
              zio.aws.networkmanager.model.AssociateConnectPeerResponse.ReadOnly
            ] = proxy(AssociateConnectPeer, request)
            def associateTransitGatewayConnectPeer(
                request: AssociateTransitGatewayConnectPeerRequest
            ): IO[
              AwsError,
              zio.aws.networkmanager.model.AssociateTransitGatewayConnectPeerResponse.ReadOnly
            ] = proxy(AssociateTransitGatewayConnectPeer, request)
            def disassociateConnectPeer(
                request: DisassociateConnectPeerRequest
            ): IO[
              AwsError,
              zio.aws.networkmanager.model.DisassociateConnectPeerResponse.ReadOnly
            ] = proxy(DisassociateConnectPeer, request)
            def deleteLink(request: DeleteLinkRequest): IO[
              AwsError,
              zio.aws.networkmanager.model.DeleteLinkResponse.ReadOnly
            ] = proxy(DeleteLink, request)
            def deleteAttachment(request: DeleteAttachmentRequest): IO[
              AwsError,
              zio.aws.networkmanager.model.DeleteAttachmentResponse.ReadOnly
            ] = proxy(DeleteAttachment, request)
            def getNetworkResourceRelationships(
                request: GetNetworkResourceRelationshipsRequest
            ): ZStream[
              Any,
              AwsError,
              zio.aws.networkmanager.model.Relationship.ReadOnly
            ] = rts.unsafeRun(proxy(GetNetworkResourceRelationships, request))
            def getNetworkResourceRelationshipsPaginated(
                request: GetNetworkResourceRelationshipsRequest
            ): IO[
              AwsError,
              zio.aws.networkmanager.model.GetNetworkResourceRelationshipsResponse.ReadOnly
            ] = proxy(GetNetworkResourceRelationshipsPaginated, request)
            def createLink(request: CreateLinkRequest): IO[
              AwsError,
              zio.aws.networkmanager.model.CreateLinkResponse.ReadOnly
            ] = proxy(CreateLink, request)
            def createVpcAttachment(request: CreateVpcAttachmentRequest): IO[
              AwsError,
              zio.aws.networkmanager.model.CreateVpcAttachmentResponse.ReadOnly
            ] = proxy(CreateVpcAttachment, request)
            def putCoreNetworkPolicy(request: PutCoreNetworkPolicyRequest): IO[
              AwsError,
              zio.aws.networkmanager.model.PutCoreNetworkPolicyResponse.ReadOnly
            ] = proxy(PutCoreNetworkPolicy, request)
            def deleteConnectPeer(request: DeleteConnectPeerRequest): IO[
              AwsError,
              zio.aws.networkmanager.model.DeleteConnectPeerResponse.ReadOnly
            ] = proxy(DeleteConnectPeer, request)
            def getConnectAttachment(request: GetConnectAttachmentRequest): IO[
              AwsError,
              zio.aws.networkmanager.model.GetConnectAttachmentResponse.ReadOnly
            ] = proxy(GetConnectAttachment, request)
          }
        }
      }
    }
  }
}
