package zio.aws.networkmanager.model
import zio.ZIO
import zio.aws.networkmanager.model.primitives.{
  ConstrainedString,
  LinkId,
  ConnectionId,
  GlobalNetworkId
}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class UpdateConnectionRequest(
    globalNetworkId: GlobalNetworkId,
    connectionId: ConnectionId,
    linkId: Optional[LinkId] = Optional.Absent,
    connectedLinkId: Optional[LinkId] = Optional.Absent,
    description: Optional[ConstrainedString] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.networkmanager.model.UpdateConnectionRequest = {
    import UpdateConnectionRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.networkmanager.model.UpdateConnectionRequest
      .builder()
      .globalNetworkId(
        GlobalNetworkId.unwrap(globalNetworkId): java.lang.String
      )
      .connectionId(ConnectionId.unwrap(connectionId): java.lang.String)
      .optionallyWith(
        linkId.map(value => LinkId.unwrap(value): java.lang.String)
      )(_.linkId)
      .optionallyWith(
        connectedLinkId.map(value => LinkId.unwrap(value): java.lang.String)
      )(_.connectedLinkId)
      .optionallyWith(
        description.map(value =>
          ConstrainedString.unwrap(value): java.lang.String
        )
      )(_.description)
      .build()
  }
  def asReadOnly
      : zio.aws.networkmanager.model.UpdateConnectionRequest.ReadOnly =
    zio.aws.networkmanager.model.UpdateConnectionRequest.wrap(buildAwsValue())
}
object UpdateConnectionRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.networkmanager.model.UpdateConnectionRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.networkmanager.model.UpdateConnectionRequest =
      zio.aws.networkmanager.model.UpdateConnectionRequest(
        globalNetworkId,
        connectionId,
        linkId.map(value => value),
        connectedLinkId.map(value => value),
        description.map(value => value)
      )
    def globalNetworkId: GlobalNetworkId
    def connectionId: ConnectionId
    def linkId: Optional[LinkId]
    def connectedLinkId: Optional[LinkId]
    def description: Optional[ConstrainedString]
    def getGlobalNetworkId: ZIO[Any, Nothing, GlobalNetworkId] =
      ZIO.succeed(globalNetworkId)
    def getConnectionId: ZIO[Any, Nothing, ConnectionId] =
      ZIO.succeed(connectionId)
    def getLinkId: ZIO[Any, AwsError, LinkId] =
      AwsError.unwrapOptionField("linkId", linkId)
    def getConnectedLinkId: ZIO[Any, AwsError, LinkId] =
      AwsError.unwrapOptionField("connectedLinkId", connectedLinkId)
    def getDescription: ZIO[Any, AwsError, ConstrainedString] =
      AwsError.unwrapOptionField("description", description)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.networkmanager.model.UpdateConnectionRequest
  ) extends zio.aws.networkmanager.model.UpdateConnectionRequest.ReadOnly {
    override val globalNetworkId: GlobalNetworkId =
      zio.aws.networkmanager.model.primitives
        .GlobalNetworkId(impl.globalNetworkId())
    override val connectionId: ConnectionId =
      zio.aws.networkmanager.model.primitives.ConnectionId(impl.connectionId())
    override val linkId: Optional[LinkId] = zio.aws.core.internal
      .optionalFromNullable(impl.linkId())
      .map(value => zio.aws.networkmanager.model.primitives.LinkId(value))
    override val connectedLinkId: Optional[LinkId] = zio.aws.core.internal
      .optionalFromNullable(impl.connectedLinkId())
      .map(value => zio.aws.networkmanager.model.primitives.LinkId(value))
    override val description: Optional[ConstrainedString] =
      zio.aws.core.internal
        .optionalFromNullable(impl.description())
        .map(value =>
          zio.aws.networkmanager.model.primitives.ConstrainedString(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.networkmanager.model.UpdateConnectionRequest
  ): zio.aws.networkmanager.model.UpdateConnectionRequest.ReadOnly =
    new Wrapper(impl)
}
