package zio.aws.networkmanager.model
import zio.ZIO
import zio.aws.networkmanager.model.primitives.{
  ClientToken,
  SubnetArn,
  VpcArn,
  CoreNetworkId
}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class CreateVpcAttachmentRequest(
    coreNetworkId: CoreNetworkId,
    vpcArn: VpcArn,
    subnetArns: Iterable[SubnetArn],
    options: Optional[zio.aws.networkmanager.model.VpcOptions] =
      Optional.Absent,
    tags: Optional[Iterable[zio.aws.networkmanager.model.Tag]] =
      Optional.Absent,
    clientToken: Optional[ClientToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.networkmanager.model.CreateVpcAttachmentRequest = {
    import CreateVpcAttachmentRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.networkmanager.model.CreateVpcAttachmentRequest
      .builder()
      .coreNetworkId(CoreNetworkId.unwrap(coreNetworkId): java.lang.String)
      .vpcArn(VpcArn.unwrap(vpcArn): java.lang.String)
      .subnetArns(subnetArns.map { item =>
        SubnetArn.unwrap(item): java.lang.String
      }.asJavaCollection)
      .optionallyWith(options.map(value => value.buildAwsValue()))(_.options)
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .optionallyWith(
        clientToken.map(value => ClientToken.unwrap(value): java.lang.String)
      )(_.clientToken)
      .build()
  }
  def asReadOnly
      : zio.aws.networkmanager.model.CreateVpcAttachmentRequest.ReadOnly =
    zio.aws.networkmanager.model.CreateVpcAttachmentRequest
      .wrap(buildAwsValue())
}
object CreateVpcAttachmentRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.networkmanager.model.CreateVpcAttachmentRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.networkmanager.model.CreateVpcAttachmentRequest =
      zio.aws.networkmanager.model.CreateVpcAttachmentRequest(
        coreNetworkId,
        vpcArn,
        subnetArns,
        options.map(value => value.asEditable),
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        clientToken.map(value => value)
      )
    def coreNetworkId: CoreNetworkId
    def vpcArn: VpcArn
    def subnetArns: List[SubnetArn]
    def options: Optional[zio.aws.networkmanager.model.VpcOptions.ReadOnly]
    def tags: Optional[List[zio.aws.networkmanager.model.Tag.ReadOnly]]
    def clientToken: Optional[ClientToken]
    def getCoreNetworkId: ZIO[Any, Nothing, CoreNetworkId] =
      ZIO.succeed(coreNetworkId)
    def getVpcArn: ZIO[Any, Nothing, VpcArn] = ZIO.succeed(vpcArn)
    def getSubnetArns: ZIO[Any, Nothing, List[SubnetArn]] =
      ZIO.succeed(subnetArns)
    def getOptions
        : ZIO[Any, AwsError, zio.aws.networkmanager.model.VpcOptions.ReadOnly] =
      AwsError.unwrapOptionField("options", options)
    def getTags
        : ZIO[Any, AwsError, List[zio.aws.networkmanager.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("tags", tags)
    def getClientToken: ZIO[Any, AwsError, ClientToken] =
      AwsError.unwrapOptionField("clientToken", clientToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.networkmanager.model.CreateVpcAttachmentRequest
  ) extends zio.aws.networkmanager.model.CreateVpcAttachmentRequest.ReadOnly {
    override val coreNetworkId: CoreNetworkId =
      zio.aws.networkmanager.model.primitives
        .CoreNetworkId(impl.coreNetworkId())
    override val vpcArn: VpcArn =
      zio.aws.networkmanager.model.primitives.VpcArn(impl.vpcArn())
    override val subnetArns: List[SubnetArn] = impl
      .subnetArns()
      .asScala
      .map { item =>
        zio.aws.networkmanager.model.primitives.SubnetArn(item)
      }
      .toList
    override val options
        : Optional[zio.aws.networkmanager.model.VpcOptions.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.options())
        .map(value => zio.aws.networkmanager.model.VpcOptions.wrap(value))
    override val tags
        : Optional[List[zio.aws.networkmanager.model.Tag.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.tags())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.networkmanager.model.Tag.wrap(item)
          }.toList
        )
    override val clientToken: Optional[ClientToken] = zio.aws.core.internal
      .optionalFromNullable(impl.clientToken())
      .map(value => zio.aws.networkmanager.model.primitives.ClientToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.networkmanager.model.CreateVpcAttachmentRequest
  ): zio.aws.networkmanager.model.CreateVpcAttachmentRequest.ReadOnly =
    new Wrapper(impl)
}
