package zio.aws.networkmanager.model
import zio.ZIO
import zio.aws.networkmanager.model.primitives.{
  ReasonContextValue,
  ReasonContextKey
}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class RouteAnalysisCompletion(
    resultCode: Optional[
      zio.aws.networkmanager.model.RouteAnalysisCompletionResultCode
    ] = Optional.Absent,
    reasonCode: Optional[
      zio.aws.networkmanager.model.RouteAnalysisCompletionReasonCode
    ] = Optional.Absent,
    reasonContext: Optional[Map[ReasonContextKey, ReasonContextValue]] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.networkmanager.model.RouteAnalysisCompletion = {
    import RouteAnalysisCompletion.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.networkmanager.model.RouteAnalysisCompletion
      .builder()
      .optionallyWith(resultCode.map(value => value.unwrap))(_.resultCode)
      .optionallyWith(reasonCode.map(value => value.unwrap))(_.reasonCode)
      .optionallyWith(
        reasonContext.map(value =>
          value
            .map({ case (key, value) =>
              (ReasonContextKey
                .unwrap(key): java.lang.String) -> (ReasonContextValue
                .unwrap(value): java.lang.String)
            })
            .asJava
        )
      )(_.reasonContext)
      .build()
  }
  def asReadOnly
      : zio.aws.networkmanager.model.RouteAnalysisCompletion.ReadOnly =
    zio.aws.networkmanager.model.RouteAnalysisCompletion.wrap(buildAwsValue())
}
object RouteAnalysisCompletion {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.networkmanager.model.RouteAnalysisCompletion
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.networkmanager.model.RouteAnalysisCompletion =
      zio.aws.networkmanager.model.RouteAnalysisCompletion(
        resultCode.map(value => value),
        reasonCode.map(value => value),
        reasonContext.map(value => value)
      )
    def resultCode: Optional[
      zio.aws.networkmanager.model.RouteAnalysisCompletionResultCode
    ]
    def reasonCode: Optional[
      zio.aws.networkmanager.model.RouteAnalysisCompletionReasonCode
    ]
    def reasonContext: Optional[Map[ReasonContextKey, ReasonContextValue]]
    def getResultCode: ZIO[
      Any,
      AwsError,
      zio.aws.networkmanager.model.RouteAnalysisCompletionResultCode
    ] = AwsError.unwrapOptionField("resultCode", resultCode)
    def getReasonCode: ZIO[
      Any,
      AwsError,
      zio.aws.networkmanager.model.RouteAnalysisCompletionReasonCode
    ] = AwsError.unwrapOptionField("reasonCode", reasonCode)
    def getReasonContext
        : ZIO[Any, AwsError, Map[ReasonContextKey, ReasonContextValue]] =
      AwsError.unwrapOptionField("reasonContext", reasonContext)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.networkmanager.model.RouteAnalysisCompletion
  ) extends zio.aws.networkmanager.model.RouteAnalysisCompletion.ReadOnly {
    override val resultCode: Optional[
      zio.aws.networkmanager.model.RouteAnalysisCompletionResultCode
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.resultCode())
      .map(value =>
        zio.aws.networkmanager.model.RouteAnalysisCompletionResultCode
          .wrap(value)
      )
    override val reasonCode: Optional[
      zio.aws.networkmanager.model.RouteAnalysisCompletionReasonCode
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.reasonCode())
      .map(value =>
        zio.aws.networkmanager.model.RouteAnalysisCompletionReasonCode
          .wrap(value)
      )
    override val reasonContext
        : Optional[Map[ReasonContextKey, ReasonContextValue]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.reasonContext())
        .map(value =>
          value.asScala
            .map({ case (key, value) =>
              zio.aws.networkmanager.model.primitives.ReasonContextKey(
                key
              ) -> zio.aws.networkmanager.model.primitives
                .ReasonContextValue(value)
            })
            .toMap
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.networkmanager.model.RouteAnalysisCompletion
  ): zio.aws.networkmanager.model.RouteAnalysisCompletion.ReadOnly =
    new Wrapper(impl)
}
