package zio.aws.networkmanager.model
import scala.jdk.CollectionConverters._
sealed trait TransitGatewayRegistrationState {
  def unwrap: software.amazon.awssdk.services.networkmanager.model.TransitGatewayRegistrationState
}
object TransitGatewayRegistrationState {
  def wrap(
      value: software.amazon.awssdk.services.networkmanager.model.TransitGatewayRegistrationState
  ): zio.aws.networkmanager.model.TransitGatewayRegistrationState =
    value match {
      case software.amazon.awssdk.services.networkmanager.model.TransitGatewayRegistrationState.UNKNOWN_TO_SDK_VERSION =>
        val r = unknownToSdkVersion
        r
      case software.amazon.awssdk.services.networkmanager.model.TransitGatewayRegistrationState.PENDING =>
        val r = PENDING
        r
      case software.amazon.awssdk.services.networkmanager.model.TransitGatewayRegistrationState.AVAILABLE =>
        val r = AVAILABLE
        r
      case software.amazon.awssdk.services.networkmanager.model.TransitGatewayRegistrationState.DELETING =>
        val r = DELETING
        r
      case software.amazon.awssdk.services.networkmanager.model.TransitGatewayRegistrationState.DELETED =>
        val r = DELETED
        r
      case software.amazon.awssdk.services.networkmanager.model.TransitGatewayRegistrationState.FAILED =>
        val r = FAILED
        r
    }
  case object unknownToSdkVersion
      extends zio.aws.networkmanager.model.TransitGatewayRegistrationState {
    override def unwrap
        : software.amazon.awssdk.services.networkmanager.model.TransitGatewayRegistrationState =
      software.amazon.awssdk.services.networkmanager.model.TransitGatewayRegistrationState.UNKNOWN_TO_SDK_VERSION
  }
  case object PENDING
      extends zio.aws.networkmanager.model.TransitGatewayRegistrationState {
    override def unwrap
        : software.amazon.awssdk.services.networkmanager.model.TransitGatewayRegistrationState =
      software.amazon.awssdk.services.networkmanager.model.TransitGatewayRegistrationState.PENDING
  }
  case object AVAILABLE
      extends zio.aws.networkmanager.model.TransitGatewayRegistrationState {
    override def unwrap
        : software.amazon.awssdk.services.networkmanager.model.TransitGatewayRegistrationState =
      software.amazon.awssdk.services.networkmanager.model.TransitGatewayRegistrationState.AVAILABLE
  }
  case object DELETING
      extends zio.aws.networkmanager.model.TransitGatewayRegistrationState {
    override def unwrap
        : software.amazon.awssdk.services.networkmanager.model.TransitGatewayRegistrationState =
      software.amazon.awssdk.services.networkmanager.model.TransitGatewayRegistrationState.DELETING
  }
  case object DELETED
      extends zio.aws.networkmanager.model.TransitGatewayRegistrationState {
    override def unwrap
        : software.amazon.awssdk.services.networkmanager.model.TransitGatewayRegistrationState =
      software.amazon.awssdk.services.networkmanager.model.TransitGatewayRegistrationState.DELETED
  }
  case object FAILED
      extends zio.aws.networkmanager.model.TransitGatewayRegistrationState {
    override def unwrap
        : software.amazon.awssdk.services.networkmanager.model.TransitGatewayRegistrationState =
      software.amazon.awssdk.services.networkmanager.model.TransitGatewayRegistrationState.FAILED
  }
}
