package zio.aws.networkmanager.model
import zio.ZIO
import zio.aws.networkmanager.model.primitives.{
  TransitGatewayConnectPeerArn,
  GlobalNetworkId
}
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class DisassociateTransitGatewayConnectPeerRequest(
    globalNetworkId: GlobalNetworkId,
    transitGatewayConnectPeerArn: TransitGatewayConnectPeerArn
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.networkmanager.model.DisassociateTransitGatewayConnectPeerRequest = {
    import DisassociateTransitGatewayConnectPeerRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.networkmanager.model.DisassociateTransitGatewayConnectPeerRequest
      .builder()
      .globalNetworkId(
        GlobalNetworkId.unwrap(globalNetworkId): java.lang.String
      )
      .transitGatewayConnectPeerArn(
        TransitGatewayConnectPeerArn.unwrap(
          transitGatewayConnectPeerArn
        ): java.lang.String
      )
      .build()
  }
  def asReadOnly
      : zio.aws.networkmanager.model.DisassociateTransitGatewayConnectPeerRequest.ReadOnly =
    zio.aws.networkmanager.model.DisassociateTransitGatewayConnectPeerRequest
      .wrap(buildAwsValue())
}
object DisassociateTransitGatewayConnectPeerRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.networkmanager.model.DisassociateTransitGatewayConnectPeerRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.networkmanager.model.DisassociateTransitGatewayConnectPeerRequest =
      zio.aws.networkmanager.model.DisassociateTransitGatewayConnectPeerRequest(
        globalNetworkId,
        transitGatewayConnectPeerArn
      )
    def globalNetworkId: GlobalNetworkId
    def transitGatewayConnectPeerArn: TransitGatewayConnectPeerArn
    def getGlobalNetworkId: ZIO[Any, Nothing, GlobalNetworkId] =
      ZIO.succeed(globalNetworkId)
    def getTransitGatewayConnectPeerArn
        : ZIO[Any, Nothing, TransitGatewayConnectPeerArn] =
      ZIO.succeed(transitGatewayConnectPeerArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.networkmanager.model.DisassociateTransitGatewayConnectPeerRequest
  ) extends zio.aws.networkmanager.model.DisassociateTransitGatewayConnectPeerRequest.ReadOnly {
    override val globalNetworkId: GlobalNetworkId =
      zio.aws.networkmanager.model.primitives
        .GlobalNetworkId(impl.globalNetworkId())
    override val transitGatewayConnectPeerArn: TransitGatewayConnectPeerArn =
      zio.aws.networkmanager.model.primitives
        .TransitGatewayConnectPeerArn(impl.transitGatewayConnectPeerArn())
  }
  def wrap(
      impl: software.amazon.awssdk.services.networkmanager.model.DisassociateTransitGatewayConnectPeerRequest
  ): zio.aws.networkmanager.model.DisassociateTransitGatewayConnectPeerRequest.ReadOnly =
    new Wrapper(impl)
}
