package zio.aws.networkmanager.model
import zio.ZIO
import zio.aws.networkmanager.model.primitives.NextToken
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class DescribeGlobalNetworksResponse(
    globalNetworks: Optional[
      Iterable[zio.aws.networkmanager.model.GlobalNetwork]
    ] = Optional.Absent,
    nextToken: Optional[NextToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.networkmanager.model.DescribeGlobalNetworksResponse = {
    import DescribeGlobalNetworksResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.networkmanager.model.DescribeGlobalNetworksResponse
      .builder()
      .optionallyWith(
        globalNetworks.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.globalNetworks)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly
      : zio.aws.networkmanager.model.DescribeGlobalNetworksResponse.ReadOnly =
    zio.aws.networkmanager.model.DescribeGlobalNetworksResponse
      .wrap(buildAwsValue())
}
object DescribeGlobalNetworksResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.networkmanager.model.DescribeGlobalNetworksResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.networkmanager.model.DescribeGlobalNetworksResponse =
      zio.aws.networkmanager.model.DescribeGlobalNetworksResponse(
        globalNetworks.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def globalNetworks
        : Optional[List[zio.aws.networkmanager.model.GlobalNetwork.ReadOnly]]
    def nextToken: Optional[NextToken]
    def getGlobalNetworks: ZIO[Any, AwsError, List[
      zio.aws.networkmanager.model.GlobalNetwork.ReadOnly
    ]] = AwsError.unwrapOptionField("globalNetworks", globalNetworks)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.networkmanager.model.DescribeGlobalNetworksResponse
  ) extends zio.aws.networkmanager.model.DescribeGlobalNetworksResponse.ReadOnly {
    override val globalNetworks
        : Optional[List[zio.aws.networkmanager.model.GlobalNetwork.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.globalNetworks())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.networkmanager.model.GlobalNetwork.wrap(item)
          }.toList
        )
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.networkmanager.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.networkmanager.model.DescribeGlobalNetworksResponse
  ): zio.aws.networkmanager.model.DescribeGlobalNetworksResponse.ReadOnly =
    new Wrapper(impl)
}
