package zio.aws.networkmanager.model
import zio.ZIO
import zio.aws.networkmanager.model.primitives.{
  ConstrainedString,
  ExternalRegionCode
}
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class CoreNetworkEdge(
    edgeLocation: Option[ExternalRegionCode] = None,
    asn: Option[Long] = None,
    insideCidrBlocks: Option[Iterable[ConstrainedString]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.networkmanager.model.CoreNetworkEdge = {
    import CoreNetworkEdge.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.networkmanager.model.CoreNetworkEdge
      .builder()
      .optionallyWith(
        edgeLocation.map(value =>
          ExternalRegionCode.unwrap(value): java.lang.String
        )
      )(_.edgeLocation)
      .optionallyWith(asn.map(value => value: java.lang.Long))(_.asn)
      .optionallyWith(
        insideCidrBlocks.map(value =>
          value.map { item =>
            ConstrainedString.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.insideCidrBlocks)
      .build()
  }
  def asReadOnly: zio.aws.networkmanager.model.CoreNetworkEdge.ReadOnly =
    zio.aws.networkmanager.model.CoreNetworkEdge.wrap(buildAwsValue())
}
object CoreNetworkEdge {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.networkmanager.model.CoreNetworkEdge
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.networkmanager.model.CoreNetworkEdge =
      zio.aws.networkmanager.model.CoreNetworkEdge(
        edgeLocation.map(value => value),
        asn.map(value => value),
        insideCidrBlocks.map(value => value)
      )
    def edgeLocation: Option[ExternalRegionCode]
    def asn: Option[Long]
    def insideCidrBlocks: Option[List[ConstrainedString]]
    def getEdgeLocation: ZIO[Any, AwsError, ExternalRegionCode] =
      AwsError.unwrapOptionField("edgeLocation", edgeLocation)
    def getAsn: ZIO[Any, AwsError, Long] =
      AwsError.unwrapOptionField("asn", asn)
    def getInsideCidrBlocks: ZIO[Any, AwsError, List[ConstrainedString]] =
      AwsError.unwrapOptionField("insideCidrBlocks", insideCidrBlocks)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.networkmanager.model.CoreNetworkEdge
  ) extends zio.aws.networkmanager.model.CoreNetworkEdge.ReadOnly {
    override val edgeLocation: Option[ExternalRegionCode] = scala
      .Option(impl.edgeLocation())
      .map(value =>
        zio.aws.networkmanager.model.primitives.ExternalRegionCode(value)
      )
    override val asn: Option[Long] =
      scala.Option(impl.asn()).map(value => value: Long)
    override val insideCidrBlocks: Option[List[ConstrainedString]] = scala
      .Option(impl.insideCidrBlocks())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.networkmanager.model.primitives.ConstrainedString(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.networkmanager.model.CoreNetworkEdge
  ): zio.aws.networkmanager.model.CoreNetworkEdge.ReadOnly = new Wrapper(impl)
}
